/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.ModelObservationResidual;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;

public class FundamentalResidualSampson
implements ModelObservationResidual<DMatrixRMaj, AssociatedPair> {
    DMatrixRMaj F;
    Point3D_F64 temp = new Point3D_F64();

    @Override
    public void setModel(DMatrixRMaj F) {
        this.F = F;
    }

    @Override
    public double computeResidual(AssociatedPair observation) {
        double bottom = 0.0;
        GeometryMath_F64.mult(this.F, observation.p1, (GeoTuple3D_F64)this.temp);
        bottom += this.temp.x * this.temp.x + this.temp.y * this.temp.y;
        GeometryMath_F64.multTran(this.F, observation.p2, this.temp);
        if ((bottom += this.temp.x * this.temp.x + this.temp.y * this.temp.y) == 0.0) {
            return Double.MAX_VALUE;
        }
        GeometryMath_F64.multTran(this.F, observation.p2, this.temp);
        return (this.temp.x * observation.p1.x + this.temp.y * observation.p1.y + this.temp.z) / bottom;
    }
}

