/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.NormalizationPoint2D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public class PRnPDirectLinearTransform {
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    public SolveNullSpace<DMatrixRMaj> solverNullspace = new SolveNullSpaceSvd_DDRM();
    private DMatrixRMaj ns = new DMatrixRMaj(12, 1);
    private boolean normalize3D = true;
    private DMatrixRMaj A = new DMatrixRMaj(12, 12);

    public boolean process(List<Point4D_F64> worldPts, List<Point2D_F64> observed, DMatrixRMaj solutionModel) {
        if (worldPts.size() != observed.size()) {
            throw new IllegalArgumentException("Number of 3D and 2D points must match");
        }
        if (worldPts.size() < 5) {
            throw new IllegalArgumentException("A minimum of 4 points are required");
        }
        LowLevelMultiViewOps.computeNormalization(observed, this.N1);
        if (this.normalize3D) {
            for (int i = 0; i < worldPts.size(); ++i) {
                worldPts.get(i).normalize();
            }
        }
        int N = worldPts.size();
        this.A.reshape(3 * N, 12);
        for (int i = 0; i < N; ++i) {
            Point2D_F64 pixel = observed.get(i);
            Point4D_F64 X2 = worldPts.get(i);
            double x = (pixel.x - this.N1.meanX) / this.N1.stdX;
            double y = (pixel.y - this.N1.meanY) / this.N1.stdY;
            int idx = i * 3 * 12;
            this.A.data[idx + 4] = -X2.x;
            this.A.data[idx + 5] = -X2.y;
            this.A.data[idx + 6] = -X2.z;
            this.A.data[idx + 7] = -X2.w;
            this.A.data[idx + 8] = y * X2.x;
            this.A.data[idx + 9] = y * X2.y;
            this.A.data[idx + 10] = y * X2.z;
            this.A.data[idx + 11] = y * X2.w;
            this.A.data[idx += 12] = X2.x;
            this.A.data[idx + 1] = X2.y;
            this.A.data[idx + 2] = X2.z;
            this.A.data[idx + 3] = X2.w;
            this.A.data[idx + 8] = -x * X2.x;
            this.A.data[idx + 9] = -x * X2.y;
            this.A.data[idx + 10] = -x * X2.z;
            this.A.data[idx + 11] = -x * X2.w;
            this.A.data[idx += 12] = -y * X2.x;
            this.A.data[idx + 1] = -y * X2.y;
            this.A.data[idx + 2] = -y * X2.z;
            this.A.data[idx + 3] = -y * X2.w;
            this.A.data[idx + 4] = x * X2.x;
            this.A.data[idx + 5] = x * X2.y;
            this.A.data[idx + 6] = x * X2.z;
            this.A.data[idx + 7] = x * X2.w;
        }
        if (!this.solverNullspace.process(this.A, 1, this.ns)) {
            return false;
        }
        this.ns.reshape(3, 4);
        this.N1.remove(this.ns, solutionModel);
        return true;
    }

    public int getMinimumPoints() {
        return 6;
    }

    public boolean isNormalize3D() {
        return this.normalize3D;
    }

    public void setNormalize3D(boolean normalize3D) {
        this.normalize3D = normalize3D;
    }
}

