/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import org.ddogleg.struct.DogArray;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;

public class ScoreRectifiedViewCoveragePixels {
    public int maxSide = 100;
    public double score = 0.0;
    public double scoreAverageOffset = 10.0;
    public double covered = 0.0;
    public double averageValue = 0.0;
    double scale;
    final GrayF32 viewed = new GrayF32(1, 1);
    final DogArray<Point2D_F64> pixel_to_undist = new DogArray<Point2D_F64>(Point2D_F64::new, p -> p.setTo(0.0, 0.0));
    Homography2D_F64 pixel_to_rect = new Homography2D_F64();
    Point2D_F64 rectified = new Point2D_F64();

    public void initialize(int width, int height, PixelTransform<Point2D_F64> transform_pixel_to_undist) {
        this.score = 0.0;
        this.covered = 0.0;
        this.scale = Math.min((double)this.maxSide / (double)width, (double)this.maxSide / (double)height);
        this.viewed.reshape((int)(this.scale * (double)width), (int)(this.scale * (double)height));
        ImageMiscOps.fill(this.viewed, 0.0f);
        this.pixel_to_undist.resize(this.viewed.width * this.viewed.height);
        int index = 0;
        for (int y = 0; y < this.viewed.height; ++y) {
            int x = 0;
            while (x < this.viewed.width) {
                Point2D_F64 undist = (Point2D_F64)this.pixel_to_undist.get(index);
                transform_pixel_to_undist.compute((int)((double)x / this.scale), (int)((double)y / this.scale), undist);
                if (UtilEjml.isUncountable(undist.x) || UtilEjml.isUncountable(undist.y)) {
                    this.viewed.unsafe_set(x, y, -1.0f);
                }
                ++x;
                ++index;
            }
        }
    }

    public void addView(int width, int height, DMatrixRMaj rect, float quality3D, Operation op) {
        if (quality3D == 0.0f) {
            return;
        }
        BoofMiscOps.checkTrue(quality3D >= 0.0f, "Quality must be positive");
        BoofMiscOps.checkTrue(this.scale != 0.0, "You must call initialize() first");
        this.pixel_to_rect.setTo(rect);
        int index = 0;
        for (int y = 0; y < this.viewed.height; ++y) {
            int x = 0;
            while (x < this.viewed.width) {
                if (!(this.viewed.data[index] < 0.0f)) {
                    Point2D_F64 fusedNorm = (Point2D_F64)this.pixel_to_undist.get(index);
                    HomographyPointOps_F64.transform(this.pixel_to_rect, fusedNorm.x, fusedNorm.y, this.rectified);
                    if (BoofMiscOps.isInside(width, height, this.rectified.x, this.rectified.y)) {
                        this.viewed.data[index] = op.process(this.viewed.data[index], quality3D);
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    public double fractionIntersection(int width, int height, DMatrixRMaj rect) {
        this.pixel_to_rect.setTo(rect);
        int intersectedCount = 0;
        int index = 0;
        for (int y = 0; y < this.viewed.height; ++y) {
            int x = 0;
            while (x < this.viewed.width) {
                if (!(this.viewed.data[index] < 0.0f)) {
                    Point2D_F64 fusedNorm = (Point2D_F64)this.pixel_to_undist.get(index);
                    HomographyPointOps_F64.transform(this.pixel_to_rect, fusedNorm.x, fusedNorm.y, this.rectified);
                    if (BoofMiscOps.isInside(width, height, this.rectified.x, this.rectified.y)) {
                        ++intersectedCount;
                    }
                }
                ++x;
                ++index;
            }
        }
        return (double)intersectedCount / (double)(this.viewed.width * this.viewed.height);
    }

    public void process() {
        int totalValid = 0;
        float total = 0.0f;
        int index = 0;
        for (int y = 0; y < this.viewed.height; ++y) {
            int x = 0;
            while (x < this.viewed.width) {
                float value = this.viewed.data[index];
                if (!(value <= 0.0f)) {
                    ++totalValid;
                    total += value;
                }
                ++x;
                ++index;
            }
        }
        this.covered = (double)totalValid / (double)(this.viewed.width * this.viewed.height);
        double average = (double)total / (double)(1 + totalValid);
        this.score = this.covered * (this.scoreAverageOffset + average);
        this.averageValue = total / (1.0f + (float)totalValid);
    }

    public int getMaxSide() {
        return this.maxSide;
    }

    public void setMaxSide(int maxSide) {
        this.maxSide = maxSide;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getScoreAverageOffset() {
        return this.scoreAverageOffset;
    }

    public void setScoreAverageOffset(double scoreAverageOffset) {
        this.scoreAverageOffset = scoreAverageOffset;
    }

    public double getCovered() {
        return this.covered;
    }

    public void setCovered(double covered) {
        this.covered = covered;
    }

    public double getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(double averageValue) {
        this.averageValue = averageValue;
    }

    @FunctionalInterface
    static interface Operation {
        public float process(float var1, float var2);
    }
}

