/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.ellipse;

import boofcv.abst.filter.binary.BinaryContourFinderLinearExternal;
import boofcv.abst.filter.binary.BinaryContourInterface;
import boofcv.abst.filter.binary.BinaryLabelContourFinder;
import boofcv.alg.filter.binary.ContourOps;
import boofcv.alg.filter.binary.ContourPacked;
import boofcv.factory.filter.binary.FactoryBinaryContourFinder;
import boofcv.struct.ConnectRule;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import georegression.fitting.curves.ClosestPointEllipseAngle_F64;
import georegression.fitting.curves.FitEllipseAlgebraic_F64;
import georegression.geometry.UtilEllipse_F64;
import georegression.struct.curve.EllipseQuadratic_F64;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.io.PrintStream;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class BinaryEllipseDetectorPixel {
    private double maxDistanceFromEllipse = 3.0;
    private int minimumContour = 20;
    private int maximumContour = 0;
    private double minimumMinorAxis = 1.5;
    private double maxMajorToMinorRatio = Double.MAX_VALUE;
    private ConnectRule connectRule;
    private BinaryLabelContourFinder contourFinder;
    private GrayS32 labeled = new GrayS32(1, 1);
    private BinaryContourFinderLinearExternal contourExternal;
    private FitEllipseAlgebraic_F64 algebraic = new FitEllipseAlgebraic_F64();
    private ClosestPointEllipseAngle_F64 closestPoint = new ClosestPointEllipseAngle_F64(1.0E-4f, 15);
    protected PixelTransform<Point2D_F32> distToUndist;
    protected Point2D_F32 distortedPoint = new Point2D_F32();
    private PrintStream verbose = null;
    private DogArray<Point2D_F64> pointsF = new DogArray<Point2D_F64>(Point2D_F64::new);
    private DogArray<Found> found = new DogArray<Found>(Found::new);
    private DogArray<Point2D_I32> contourTmp = new DogArray<Point2D_I32>(Point2D_I32::new);

    public BinaryEllipseDetectorPixel(ConnectRule connectRule) {
        this.connectRule = connectRule;
        this.declareContour(false);
    }

    public BinaryEllipseDetectorPixel() {
        this(ConnectRule.FOUR);
    }

    public void setLensDistortion(PixelTransform<Point2D_F32> distToUndist) {
        this.distToUndist = distToUndist;
    }

    public void process(GrayU8 binary) {
        this.found.reset();
        BinaryContourInterface selectedFinder = this.getContourFinder();
        selectedFinder.setMaxContour(this.maximumContour == 0 ? Integer.MAX_VALUE : this.maximumContour);
        selectedFinder.setMinContour(this.minimumContour);
        if (this.isInternalContour()) {
            this.contourFinder.process(binary, this.labeled);
        } else {
            this.contourExternal.process(binary);
        }
        List<ContourPacked> blobs = selectedFinder.getContours();
        for (int i = 0; i < blobs.size(); ++i) {
            ContourPacked c = blobs.get(i);
            selectedFinder.loadContour(c.externalIndex, this.contourTmp);
            this.proccessContour(this.contourTmp.toList(), binary.width, binary.height);
            if (!this.isInternalContour()) continue;
            for (int j = 0; j < c.internalIndexes.size(); ++j) {
                selectedFinder.loadContour(c.internalIndexes.get(j), this.contourTmp);
                this.proccessContour(this.contourTmp.toList(), binary.width, binary.height);
            }
        }
    }

    private void proccessContour(List<Point2D_I32> contour, int width, int height) {
        if (ContourOps.isTouchBorder(contour, width, height)) {
            return;
        }
        this.pointsF.reset();
        this.undistortContour(contour, this.pointsF);
        if (!this.algebraic.process(this.pointsF.toList())) {
            if (this.verbose != null) {
                this.verbose.println("Rejecting: algebraic fit failed. size = " + this.pointsF.size());
            }
            return;
        }
        EllipseQuadratic_F64 quad = this.algebraic.getEllipse();
        Found f = this.found.grow();
        UtilEllipse_F64.convert(quad, f.ellipse);
        boolean accepted = true;
        if (f.ellipse.b <= this.minimumMinorAxis) {
            if (this.verbose != null) {
                this.verbose.println("Rejecting: Minor axis too small. size = " + f.ellipse.b);
            }
            accepted = false;
        } else if (!this.isApproximatelyElliptical(f.ellipse, this.pointsF.toList(), 20)) {
            if (this.verbose != null) {
                this.verbose.println("Rejecting: Not approximately elliptical. size = " + this.pointsF.size());
            }
            accepted = false;
        } else if (f.ellipse.a > this.maxMajorToMinorRatio * f.ellipse.b) {
            if (this.verbose != null) {
                this.verbose.println("Rejecting: Major to minor axis length ratio too extreme = " + this.pointsF.size());
            }
            accepted = false;
        }
        if (accepted) {
            if (this.verbose != null) {
                this.verbose.println("Success!  size = " + this.pointsF.size());
            }
            this.adjustElipseForBinaryBias(f.ellipse);
            f.contour = contour;
        } else {
            this.found.removeTail();
        }
    }

    protected void adjustElipseForBinaryBias(EllipseRotated_F64 ellipse) {
        ellipse.center.x += 0.5;
        ellipse.center.y += 0.5;
        ellipse.a += 0.5;
        ellipse.b += 0.5;
    }

    void undistortContour(List<Point2D_I32> external, DogArray<Point2D_F64> pointsF) {
        for (int j = 0; j < external.size(); ++j) {
            Point2D_I32 p = external.get(j);
            if (this.distToUndist != null) {
                this.distToUndist.compute(p.x, p.y, this.distortedPoint);
                pointsF.grow().setTo(this.distortedPoint.x, this.distortedPoint.y);
                continue;
            }
            pointsF.grow().setTo(p.x, p.y);
        }
    }

    boolean isApproximatelyElliptical(EllipseRotated_F64 ellipse, List<Point2D_F64> points, int maxSamples) {
        this.closestPoint.setEllipse(ellipse);
        double maxDistance2 = this.maxDistanceFromEllipse * this.maxDistanceFromEllipse;
        if (points.size() <= maxSamples) {
            for (int i = 0; i < points.size(); ++i) {
                Point2D_F64 p = points.get(i);
                this.closestPoint.process(p);
                double d = this.closestPoint.getClosest().distance2(p);
                if (!(d > maxDistance2)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < maxSamples; ++i) {
                Point2D_F64 p = points.get(i * points.size() / maxSamples);
                this.closestPoint.process(p);
                double d = this.closestPoint.getClosest().distance2(p);
                if (!(d > maxDistance2)) continue;
                return false;
            }
        }
        return true;
    }

    public List<ContourPacked> getContours() {
        return this.getContourFinder().getContours();
    }

    public void loadContour(int id, DogArray<Point2D_I32> storage) {
        this.getContourFinder().loadContour(id, storage);
    }

    public BinaryContourInterface getContourFinder() {
        if (this.contourFinder != null) {
            return this.contourFinder;
        }
        return this.contourExternal;
    }

    public boolean isVerbose() {
        return this.verbose != null;
    }

    public boolean isInternalContour() {
        return this.contourFinder != null;
    }

    public void setInternalContour(boolean internalContour) {
        if (internalContour == this.isInternalContour()) {
            return;
        }
        this.declareContour(internalContour);
    }

    private void declareContour(boolean internalContour) {
        if (internalContour) {
            this.contourFinder = FactoryBinaryContourFinder.linearChang2004();
            this.contourFinder.setConnectRule(this.connectRule);
            this.contourExternal = null;
        } else {
            this.contourExternal = FactoryBinaryContourFinder.linearExternal();
            this.contourExternal.setConnectRule(this.connectRule);
            this.contourExternal.setCreatePaddedCopy(true);
            this.contourExternal.setCoordinateAdjustment(1, 1);
            this.contourFinder = null;
        }
    }

    public void setVerbose(PrintStream verbose) {
        this.verbose = verbose;
    }

    public List<Found> getFound() {
        return this.found.toList();
    }

    public double getMaxDistanceFromEllipse() {
        return this.maxDistanceFromEllipse;
    }

    public void setMaxDistanceFromEllipse(double maxDistanceFromEllipse) {
        this.maxDistanceFromEllipse = maxDistanceFromEllipse;
    }

    public int getMinimumContour() {
        return this.minimumContour;
    }

    public void setMinimumContour(int minimumContour) {
        this.minimumContour = minimumContour;
    }

    public int getMaximumContour() {
        return this.maximumContour;
    }

    public void setMaximumContour(int maximumContour) {
        this.maximumContour = maximumContour;
    }

    public double getMinimumMinorAxis() {
        return this.minimumMinorAxis;
    }

    public void setMinimumMinorAxis(double minimumMinorAxis) {
        this.minimumMinorAxis = minimumMinorAxis;
    }

    public double getMaxMajorToMinorRatio() {
        return this.maxMajorToMinorRatio;
    }

    public void setMaxMajorToMinorRatio(double maxMajorToMinorRatio) {
        this.maxMajorToMinorRatio = maxMajorToMinorRatio;
    }

    public ConnectRule getConnectRule() {
        return this.connectRule;
    }

    public static class Found {
        public EllipseRotated_F64 ellipse = new EllipseRotated_F64();
        public List<Point2D_I32> contour;
    }
}

