/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.similar;

import boofcv.abst.feature.associate.AssociateDescriptionHashSets;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.scene.FeatureSceneRecognition;
import boofcv.abst.scene.SceneRecognition;
import boofcv.alg.similar.ImageSimilarityAssociatedRatio;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.packed.PackedArrayPoint2D_F64;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class SimilarImagesSceneRecognition<Image extends ImageBase<Image>, TD extends TupleDesc<TD>>
implements LookUpSimilarImages,
VerbosePrint {
    DetectDescribePoint<Image, TD> detector;
    AssociateDescriptionHashSets<TD> asscociator;
    FeatureSceneRecognition<TD> recognizer;
    boolean relearnModel = true;
    int limitMatchesConsider = 30;
    SimilarityTest similarityTest = new ImageSimilarityAssociatedRatio();
    final List<String> imageIDs = new ArrayList<String>();
    final TObjectIntMap<String> imageToIndex = new TObjectIntHashMap<String>(10, 0.5f, -1);
    final DogArray<PairInfo> pairInfo = new DogArray<PairInfo>(PairInfo::new, PairInfo::reset);
    final Map<String, PairInfo> viewId_to_info = new HashMap<String, PairInfo>();
    final PackedArray<TD> descriptions;
    final PackedArray<Point2D_F64> pixels = new PackedArrayPoint2D_F64();
    final DogArray_I32 imageFeatureStartIndexes = new DogArray_I32();
    public double timeFixateLearnMS;
    public double timeFixateAddMS;
    final DogArray<SceneRecognition.Match> sceneMatches = new DogArray<SceneRecognition.Match>(SceneRecognition.Match::new);
    final TD tempDescription;
    final Point2D_F64 tempPixel = new Point2D_F64();
    final DogArray<TD> sourceDescriptions;
    final DogArray<Point2D_F64> sourcePixels;
    final DogArray<TD> destinationDescriptions;
    final DogArray<Point2D_F64> destinationPixels;
    PrintStream verbose;

    public SimilarImagesSceneRecognition(DetectDescribePoint<Image, TD> detector, AssociateDescriptionHashSets<TD> asscociator, FeatureSceneRecognition<TD> recognizer, BoofLambdas.Factory<PackedArray<TD>> factoryPackedDesc) {
        this.detector = detector;
        this.asscociator = asscociator;
        this.recognizer = recognizer;
        this.descriptions = factoryPackedDesc.newInstance();
        this.tempDescription = detector.createDescription();
        this.sourceDescriptions = new DogArray<TupleDesc>(detector::createDescription);
        this.destinationDescriptions = new DogArray<TupleDesc>(detector::createDescription);
        this.sourcePixels = new DogArray<Point2D_F64>(Point2D_F64::new);
        this.destinationPixels = new DogArray<Point2D_F64>(Point2D_F64::new);
        asscociator.createNewSetsFromSource = true;
        asscociator.createNewSetsFromDestination = false;
    }

    public void addImage(String id, Image image) {
        this.imageToIndex.put(id, this.imageIDs.size());
        this.imageIDs.add(id);
        this.detector.detect(image);
        int N = this.detector.getNumberOfFeatures();
        this.imageFeatureStartIndexes.add(this.descriptions.size());
        this.imageFeatureStartIndexes.add(N);
        for (int i = 0; i < N; ++i) {
            this.descriptions.append(this.detector.getDescription(i));
            this.pixels.append(this.detector.getLocation(i));
        }
    }

    public void fixate() {
        long time0 = System.nanoTime();
        if (this.relearnModel) {
            this.learnModel();
        }
        long time1 = System.nanoTime();
        this.timeFixateLearnMS = (double)(time1 - time0) * 1.0E-6;
        if (this.verbose != null) {
            this.verbose.printf("fixate learning time: %.1f (ms)\n", this.timeFixateLearnMS);
        }
        for (int imageIndex = 0; imageIndex < this.imageIDs.size(); ++imageIndex) {
            this.recognizer.addImage(this.imageIDs.get(imageIndex), this.createFeaturesLambda(imageIndex));
        }
        long time2 = System.nanoTime();
        this.timeFixateAddMS = (double)(time2 - time1) * 1.0E-6;
        if (this.verbose != null) {
            this.verbose.printf("fixate learning add: %.1f (ms)\n", this.timeFixateAddMS);
        }
    }

    private void learnModel() {
        this.recognizer.learnModel(new Iterator<FeatureSceneRecognition.Features<TD>>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index * 2 < SimilarImagesSceneRecognition.this.imageFeatureStartIndexes.size;
            }

            @Override
            public FeatureSceneRecognition.Features<TD> next() {
                return SimilarImagesSceneRecognition.this.createFeaturesLambda(this.index++);
            }
        });
    }

    @Override
    public List<String> getImageIDs() {
        return this.imageIDs;
    }

    @Override
    public void findSimilar(String target, @Nullable BoofLambdas.Filter<String> filter, List<String> similarImages) {
        similarImages.clear();
        int imageIndex = this.imageToIndex.get(target);
        this.viewId_to_info.clear();
        this.pairInfo.reset();
        int targetFeatureOffset = this.imageFeatureStartIndexes.get(imageIndex * 2);
        int targetFeatureSize = this.imageFeatureStartIndexes.get(imageIndex * 2 + 1);
        if (!this.recognizer.query(this.createFeaturesLambda(imageIndex), filter, this.limitMatchesConsider, this.sceneMatches)) {
            if (this.verbose != null) {
                this.verbose.printf("image[%d] cbir found no matches\n", imageIndex);
            }
            return;
        }
        if (this.verbose != null) {
            this.verbose.printf("image[%d].cbir_matches.size=%d\n", imageIndex, this.sceneMatches.size);
        }
        this.asscociator.initialize(this.recognizer.getTotalWords());
        this.sourceDescriptions.reset();
        this.sourcePixels.reset();
        for (int i = 0; i < targetFeatureSize; ++i) {
            TupleDesc desc = (TupleDesc)this.sourceDescriptions.grow();
            this.descriptions.getCopy(targetFeatureOffset + i, desc);
            this.pixels.getCopy(targetFeatureOffset + i, this.sourcePixels.grow());
            this.asscociator.addSource(desc, this.recognizer.getQueryWord(i));
        }
        for (int matchIndex = 0; matchIndex < this.sceneMatches.size; ++matchIndex) {
            SceneRecognition.Match match = (SceneRecognition.Match)this.sceneMatches.get(matchIndex);
            int imageIndexMatch = this.imageToIndex.get(match.id);
            if (imageIndex == imageIndexMatch) continue;
            this.addDestFeaturesThenAssociate(imageIndexMatch);
            if (this.verbose != null) {
                this.verbose.printf("_ dst.size=%d associated[%d].size=%d", this.destinationPixels.size, imageIndexMatch, this.asscociator.getMatches().size);
            }
            if (!this.similarityTest.isSimilar(this.sourcePixels, this.destinationPixels, this.asscociator.getMatches())) {
                if (this.verbose == null) continue;
                this.verbose.println();
                continue;
            }
            similarImages.add(match.id);
            PairInfo info = this.pairInfo.grow();
            info.associated.copyAll(this.asscociator.getMatches().toList(), (original, copy) -> copy.setTo((AssociatedIndex)original));
            this.viewId_to_info.put(match.id, info);
            if (this.verbose == null) continue;
            this.verbose.println(" accepted");
        }
    }

    private void addDestFeaturesThenAssociate(int imageIndex) {
        int destFeatureOffset = this.imageFeatureStartIndexes.get(imageIndex * 2);
        int destFeatureSize = this.imageFeatureStartIndexes.get(imageIndex * 2 + 1);
        this.asscociator.clearDestination();
        this.destinationDescriptions.reset();
        this.destinationPixels.reset();
        for (int featureIndex = 0; featureIndex < destFeatureSize; ++featureIndex) {
            TupleDesc desc = (TupleDesc)this.destinationDescriptions.grow();
            this.descriptions.getCopy(destFeatureOffset + featureIndex, desc);
            this.pixels.getCopy(destFeatureOffset + featureIndex, this.destinationPixels.grow());
            this.asscociator.addDestination(desc, this.recognizer.lookupWord(desc));
        }
        this.asscociator.associate();
    }

    @Override
    public void lookupPixelFeats(String target, DogArray<Point2D_F64> features) {
        int imageIndex = this.imageToIndex.get(target);
        if (imageIndex == -1) {
            throw new IllegalArgumentException("Unknown view=" + target);
        }
        int offset = this.imageFeatureStartIndexes.get(imageIndex * 2);
        int size = this.imageFeatureStartIndexes.get(imageIndex * 2 + 1);
        features.resize(size);
        for (int i = 0; i < size; ++i) {
            this.pixels.getCopy(offset + i, (Point2D_F64)features.get(i));
        }
    }

    @Override
    public boolean lookupAssociated(String viewDst, DogArray<AssociatedIndex> pairs) {
        pairs.reset();
        PairInfo info = this.viewId_to_info.get(viewDst);
        if (info == null) {
            throw new IllegalArgumentException("View is not similar " + viewDst);
        }
        pairs.copyAll(info.associated.toList(), (original, copy) -> copy.setTo((AssociatedIndex)original));
        return !pairs.isEmpty();
    }

    public void lookupImageWords(String imageID, DogArray_I32 words) {
        words.reset();
        int imageIndex = this.imageToIndex.get(imageID);
        int offset = this.imageFeatureStartIndexes.get(imageIndex * 2);
        int numFeatures = this.imageFeatureStartIndexes.get(imageIndex * 2 + 1);
        for (int i = 0; i < numFeatures; ++i) {
            words.add(this.recognizer.lookupWord((TupleDesc)this.descriptions.getTemp(offset + i)));
        }
    }

    private FeatureSceneRecognition.Features<TD> createFeaturesLambda(int imageIndex) {
        final int offset = this.imageFeatureStartIndexes.get(imageIndex * 2);
        final int size = this.imageFeatureStartIndexes.get(imageIndex * 2 + 1);
        return new FeatureSceneRecognition.Features<TD>(){

            @Override
            public Point2D_F64 getPixel(int index) {
                SimilarImagesSceneRecognition.this.pixels.getCopy(offset + index, SimilarImagesSceneRecognition.this.tempPixel);
                return SimilarImagesSceneRecognition.this.tempPixel;
            }

            @Override
            public TD getDescription(int index) {
                SimilarImagesSceneRecognition.this.descriptions.getCopy(offset + index, SimilarImagesSceneRecognition.this.tempDescription);
                return SimilarImagesSceneRecognition.this.tempDescription;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> options) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
        BoofMiscOps.verboseChildren(this.verbose, options, this.recognizer);
    }

    public DetectDescribePoint<Image, TD> getDetector() {
        return this.detector;
    }

    public void setDetector(DetectDescribePoint<Image, TD> detector) {
        this.detector = detector;
    }

    public AssociateDescriptionHashSets<TD> getAsscociator() {
        return this.asscociator;
    }

    public FeatureSceneRecognition<TD> getRecognizer() {
        return this.recognizer;
    }

    public boolean isRelearnModel() {
        return this.relearnModel;
    }

    public void setRelearnModel(boolean relearnModel) {
        this.relearnModel = relearnModel;
    }

    public int getLimitMatchesConsider() {
        return this.limitMatchesConsider;
    }

    public void setLimitMatchesConsider(int limitMatchesConsider) {
        this.limitMatchesConsider = limitMatchesConsider;
    }

    public SimilarityTest getSimilarityTest() {
        return this.similarityTest;
    }

    public void setSimilarityTest(SimilarityTest similarityTest) {
        this.similarityTest = similarityTest;
    }

    public double getTimeFixateLearnMS() {
        return this.timeFixateLearnMS;
    }

    public double getTimeFixateAddMS() {
        return this.timeFixateAddMS;
    }

    public static interface SimilarityTest {
        public boolean isSimilar(FastAccess<Point2D_F64> var1, FastAccess<Point2D_F64> var2, FastAccess<AssociatedIndex> var3);
    }

    protected static class PairInfo {
        public DogArray<AssociatedIndex> associated = new DogArray<AssociatedIndex>(AssociatedIndex::new);

        protected PairInfo() {
        }

        public void reset() {
            this.associated.reset();
        }
    }
}

