/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.image.ImageDimension;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;

public class LookUpCameraInfo {
    public final TObjectIntMap<String> idToView = new TObjectIntHashMap<String>();
    public final DogArray_I32 viewToCamera = new DogArray_I32();
    public final DogArray<CameraPinholeBrown> listCalibration = new DogArray<CameraPinholeBrown>(() -> new CameraPinholeBrown(2));
    public final DogArray_B knownCameras = new DogArray_B();

    public int totalViews() {
        return this.viewToCamera.size;
    }

    public int totalCameras() {
        return this.listCalibration.size;
    }

    public int viewToCamera(String viewID) {
        int viewIdx = this.idToView.get(viewID);
        return this.viewToCamera.get(viewIdx);
    }

    public void lookupCalibration(int cameraIdx, CameraPinholeBrown calibration) {
        calibration.setTo((CameraPinhole)this.listCalibration.get(cameraIdx));
    }

    public void lookupCalibration(String viewID, CameraPinholeBrown calibration) {
        int cameraIdx = this.viewToCamera(viewID);
        calibration.setTo((CameraPinhole)this.listCalibration.get(cameraIdx));
    }

    public boolean isCameraKnown(int cameraIdx) {
        return this.knownCameras.get(cameraIdx);
    }

    public void lookupViewShape(String viewID, ImageDimension shape) {
        int cameraIdx = this.viewToCamera(viewID);
        CameraPinholeBrown camera = (CameraPinholeBrown)this.listCalibration.get(cameraIdx);
        shape.setTo(camera.width, camera.height);
    }

    public void addCameraCanonical(int width, int height, double hfov) {
        BoofMiscOps.checkTrue(width > 0 && height > 0, "width and height must be more than zero");
        BoofMiscOps.checkTrue(hfov > 0.0, "hfov must be more than zero degrees");
        PerspectiveOps.createIntrinsic(width, height, hfov, this.listCalibration.grow());
    }

    public void addView(String viewID, int cameraIdx) {
        this.idToView.put(viewID, this.viewToCamera.size);
        this.viewToCamera.add(cameraIdx);
    }
}

