/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.template;

import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.template.TemplateMatchingIntensity;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;

public class TemplateIntensityImage<T extends ImageBase<T>>
implements TemplateMatchingIntensity<T> {
    protected GrayF32 intensity = new GrayF32(1, 1);
    protected T image;
    protected T template;
    protected T mask;
    protected int borderX0;
    protected int borderY0;
    protected int borderX1;
    protected int borderY1;
    protected EvaluatorMethod<T> method;

    public TemplateIntensityImage(EvaluatorMethod<T> method) {
        this.method = method;
    }

    @Override
    public void setInputImage(T image) {
        this.image = image;
    }

    @Override
    public void process(T template) {
        this.template = template;
        this.mask = null;
        this.intensity.reshape(((ImageBase)this.image).width, ((ImageBase)this.image).height);
        int w = ((ImageBase)this.image).width - ((ImageBase)template).width + 1;
        int h = ((ImageBase)this.image).height - ((ImageBase)template).height + 1;
        this.borderX0 = ((ImageBase)template).width / 2;
        this.borderY0 = ((ImageBase)template).height / 2;
        this.borderX1 = ((ImageBase)template).width - this.borderX0;
        this.borderY1 = ((ImageBase)template).height - this.borderY0;
        GImageMiscOps.fillBorder(this.intensity, 0.0, this.borderX0, this.borderY0, this.borderX1, this.borderY1);
        this.method.initialize(this);
        this.processInner(w, h);
        this.template = null;
    }

    protected void processInner(int w, int h) {
        for (int y = 0; y < h; ++y) {
            int index = this.intensity.startIndex + (y + this.borderY0) * this.intensity.stride + this.borderX0;
            for (int x = 0; x < w; ++x) {
                this.intensity.data[index++] = this.method.evaluate(x, y);
            }
        }
    }

    @Override
    public void process(T template, T mask) {
        if (mask == null) {
            this.process(template);
            return;
        }
        this.template = template;
        this.mask = mask;
        this.intensity.reshape(((ImageBase)this.image).width, ((ImageBase)this.image).height);
        int w = ((ImageBase)this.image).width - ((ImageBase)template).width + 1;
        int h = ((ImageBase)this.image).height - ((ImageBase)template).height + 1;
        this.borderX0 = ((ImageBase)template).width / 2;
        this.borderY0 = ((ImageBase)template).height / 2;
        this.borderX1 = ((ImageBase)template).width - this.borderX0;
        this.borderY1 = ((ImageBase)template).height - this.borderY0;
        this.method.initialize(this);
        this.processInnerMask(w, h);
        this.template = null;
        this.mask = null;
    }

    protected void processInnerMask(int w, int h) {
        for (int y = 0; y < h; ++y) {
            int index = this.intensity.startIndex + (y + this.borderY0) * this.intensity.stride + this.borderX0;
            for (int x = 0; x < w; ++x) {
                this.intensity.data[index++] = this.method.evaluateMask(x, y);
            }
        }
    }

    @Override
    public GrayF32 getIntensity() {
        return this.intensity;
    }

    @Override
    public int getBorderX0() {
        return this.borderX0;
    }

    @Override
    public int getBorderY0() {
        return this.borderY0;
    }

    @Override
    public int getBorderX1() {
        return this.borderX1;
    }

    @Override
    public int getBorderY1() {
        return this.borderY1;
    }

    @Override
    public boolean isMaximize() {
        return this.method.isMaximize();
    }

    @Override
    public boolean isBorderProcessed() {
        return this.method.isBorderProcessed();
    }

    public static interface EvaluatorMethod<T extends ImageBase<T>> {
        public void initialize(TemplateIntensityImage<T> var1);

        public float evaluate(int var1, int var2);

        public float evaluateMask(int var1, int var2);

        public boolean isMaximize();

        public boolean isBorderProcessed();
    }
}

