/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.template;

import boofcv.alg.template.TemplateIntensityImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import org.ejml.UtilEjml;

public abstract class TemplateNCC<T extends ImageBase<T>>
implements TemplateIntensityImage.EvaluatorMethod<T> {
    float EPS = UtilEjml.F_EPS;
    TemplateIntensityImage<T> o;

    @Override
    public void initialize(TemplateIntensityImage<T> owner) {
        this.o = owner;
        this.setupTemplate(this.o.template);
    }

    @Override
    public boolean isMaximize() {
        return true;
    }

    public abstract void setupTemplate(T var1);

    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    public static class U8
    extends TemplateNCC<GrayU8> {
        float area;
        float templateMean;
        float templateSigma;

        @Override
        public float evaluate(int tl_x, int tl_y) {
            float top = 0.0f;
            int imageSum = 0;
            float imageSigma = 0.0f;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    imageSum += ((GrayU8)this.o.image).data[imageIndex++] & 0xFF;
                }
            }
            float imageMean = (float)imageSum / this.area;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    int templateVal = ((GrayU8)this.o.template).data[templateIndex++] & 0xFF;
                    int imageVal = ((GrayU8)this.o.image).data[imageIndex++] & 0xFF;
                    float imageDiff = (float)imageVal - imageMean;
                    imageSigma += imageDiff * imageDiff;
                    top += imageDiff * ((float)templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma);
            return top / (this.EPS + imageSigma * this.templateSigma);
        }

        @Override
        public float evaluateMask(int tl_x, int tl_y) {
            float top = 0.0f;
            int imageSum = 0;
            float imageSigma = 0.0f;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    imageSum += ((GrayU8)this.o.image).data[imageIndex++] & 0xFF;
                }
            }
            float imageMean = (float)imageSum / this.area;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                int maskIndex = ((GrayU8)this.o.mask).startIndex + y * ((GrayU8)this.o.mask).stride;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    int templateVal = ((GrayU8)this.o.template).data[templateIndex++] & 0xFF;
                    int imageVal = ((GrayU8)this.o.image).data[imageIndex++] & 0xFF;
                    int m = ((GrayU8)this.o.mask).data[maskIndex++] & 0xFF;
                    float imageDiff = (float)imageVal - imageMean;
                    imageSigma += imageDiff * imageDiff;
                    top += (float)m * imageDiff * ((float)templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma);
            return top / (this.EPS + imageSigma * this.templateSigma);
        }

        @Override
        public void setupTemplate(GrayU8 template) {
            int x;
            int templateIndex;
            int y;
            this.area = ((GrayU8)this.o.template).width * ((GrayU8)this.o.template).height;
            this.templateMean = 0.0f;
            for (y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                for (x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    this.templateMean += (float)(((GrayU8)this.o.template).data[templateIndex++] & 0xFF);
                }
            }
            this.templateMean /= this.area;
            this.templateSigma = 0.0f;
            for (y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                for (x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    float diff = (float)(((GrayU8)this.o.template).data[templateIndex++] & 0xFF) - this.templateMean;
                    this.templateSigma += diff * diff;
                }
            }
            this.templateSigma = (float)Math.sqrt(this.templateSigma);
        }
    }

    public static class F32
    extends TemplateNCC<GrayF32> {
        float area;
        float templateMean;
        float templateSigma;

        @Override
        public float evaluate(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    imageMean += ((GrayF32)this.o.image).data[imageIndex++];
                }
            }
            imageMean /= this.area;
            for (y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float templateVal = ((GrayF32)this.o.template).data[templateIndex++];
                    float imageVal = ((GrayF32)this.o.image).data[imageIndex++];
                    float imageDiff = imageVal - imageMean;
                    imageSigma += imageDiff * imageDiff;
                    top += imageDiff * (templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma);
            return top / (this.EPS + imageSigma * this.templateSigma);
        }

        @Override
        public float evaluateMask(int tl_x, int tl_y) {
            int imageIndex;
            int y;
            float top = 0.0f;
            float imageMean = 0.0f;
            float imageSigma = 0.0f;
            for (y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    imageMean += ((GrayF32)this.o.image).data[imageIndex++];
                }
            }
            imageMean /= this.area;
            for (y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                int maskIndex = ((GrayF32)this.o.mask).startIndex + y * ((GrayF32)this.o.mask).stride;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float templateVal = ((GrayF32)this.o.template).data[templateIndex++];
                    float imageVal = ((GrayF32)this.o.image).data[imageIndex++];
                    float imageDiff = imageVal - imageMean;
                    imageSigma += imageDiff * imageDiff;
                    top += ((GrayF32)this.o.mask).data[maskIndex++] * imageDiff * (templateVal - this.templateMean);
                }
            }
            imageSigma = (float)Math.sqrt(imageSigma);
            return top / (this.EPS + imageSigma * this.templateSigma);
        }

        @Override
        public void setupTemplate(GrayF32 template) {
            int x;
            int templateIndex;
            int y;
            this.area = ((GrayF32)this.o.template).width * ((GrayF32)this.o.template).height;
            this.templateMean = 0.0f;
            for (y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                for (x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    this.templateMean += ((GrayF32)this.o.template).data[templateIndex++];
                }
            }
            this.templateMean /= this.area;
            this.templateSigma = 0.0f;
            for (y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                for (x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float diff = ((GrayF32)this.o.template).data[templateIndex++] - this.templateMean;
                    this.templateSigma += diff * diff;
                }
            }
            this.templateSigma = (float)Math.sqrt(this.templateSigma);
        }
    }
}

