/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.BoofDefaults;
import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.convolve.FactoryConvolve;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.border.BorderType;
import boofcv.struct.gss.GaussianScaleSpace;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class NoCacheScaleSpace<I extends ImageGray<I>, D extends ImageGray<D>>
implements GaussianScaleSpace<I, D> {
    private I originalImage;
    private Class<I> inputType;
    AnyImageDerivative<I, D> anyDeriv;
    private double[] scales;
    private int currentScale;
    private I workImage;
    private I scaledImage;
    BorderType borderDeriv = BoofDefaults.DERIV_BORDER_TYPE;
    BorderType borderBlur = BorderType.NORMALIZED;

    public NoCacheScaleSpace(Class<I> inputType, Class<D> derivType) {
        this.inputType = inputType;
        this.anyDeriv = GImageDerivativeOps.derivativeForScaleSpace(inputType, derivType);
    }

    @Override
    public void setScales(double ... scales) {
        this.scales = scales;
    }

    @Override
    public double getScale(int level) {
        return this.scales[level];
    }

    @Override
    public void setImage(I input) {
        this.originalImage = input;
        if (this.scaledImage == null) {
            this.scaledImage = GeneralizedImageOps.createSingleBand(this.inputType, ((ImageBase)input).getWidth(), ((ImageBase)input).getHeight());
            this.workImage = GeneralizedImageOps.createSingleBand(this.inputType, ((ImageBase)input).getWidth(), ((ImageBase)input).getHeight());
        } else if (((ImageGray)this.scaledImage).width != ((ImageGray)input).width || ((ImageGray)this.scaledImage).height != ((ImageGray)input).height) {
            ((ImageGray)this.scaledImage).reshape(((ImageGray)input).width, ((ImageGray)input).height);
            ((ImageGray)this.workImage).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
    }

    @Override
    public void setActiveScale(int index) {
        this.currentScale = index;
        double sigma = this.scales[index];
        int radius = FactoryKernelGaussian.radiusForSigma(sigma, 0);
        Object kernel = FactoryKernelGaussian.gaussian1D(this.inputType, sigma, radius);
        ImageType<I> _imageType = ImageType.single(this.inputType);
        ConvolveInterface<I, I> blurX = FactoryConvolve.convolve(kernel, _imageType, _imageType, this.borderBlur, true);
        ConvolveInterface<I, I> blurY = FactoryConvolve.convolve(kernel, _imageType, _imageType, this.borderBlur, false);
        blurX.process(this.originalImage, this.workImage);
        blurY.process(this.workImage, this.scaledImage);
        this.anyDeriv.setInput(this.scaledImage);
    }

    @Override
    public double getCurrentScale() {
        return this.scales[this.currentScale];
    }

    @Override
    public int getTotalScales() {
        return this.scales.length;
    }

    @Override
    public I getScaledImage() {
        return this.scaledImage;
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderDeriv = type;
        this.borderBlur = type;
        this.setActiveScale(this.currentScale);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderDeriv;
    }

    @Override
    public D getDerivative(boolean ... isX) {
        return this.anyDeriv.getDerivative(isX);
    }
}

