/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.video;

public interface RelativeBetter {
    public double computeBetterValue(double var1, double var3);

    public static class MaximizeSoftRatio
    implements RelativeBetter {
        double epsilon;

        public MaximizeSoftRatio(double epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public double computeBetterValue(double valueA, double valueB) {
            return Math.max(0.0, valueA / (this.epsilon + valueB) - 1.0);
        }

        public double getEpsilon() {
            return this.epsilon;
        }

        public void setEpsilon(double epsilon) {
            this.epsilon = epsilon;
        }
    }

    public static class ErrorHardRatioSq
    implements RelativeBetter {
        double minimumB;

        public ErrorHardRatioSq(double minimumB) {
            this.minimumB = minimumB;
        }

        @Override
        public double computeBetterValue(double valueA, double valueB) {
            if (valueB < this.minimumB * this.minimumB) {
                return 0.0;
            }
            if (valueA == 0.0) {
                return Double.MAX_VALUE;
            }
            return Math.max(0.0, Math.sqrt(valueB) / Math.sqrt(valueA) - 1.0);
        }

        public double getMinimumB() {
            return this.minimumB;
        }

        public void setMinimumB(double minimumB) {
            this.minimumB = minimumB;
        }
    }

    public static class ErrorHardRatio
    implements RelativeBetter {
        double minimumB;

        public ErrorHardRatio(double minimumB) {
            this.minimumB = minimumB;
        }

        @Override
        public double computeBetterValue(double valueA, double valueB) {
            if (valueB < this.minimumB) {
                return 0.0;
            }
            if (valueA == 0.0) {
                return Double.MAX_VALUE;
            }
            return Math.max(0.0, valueB / valueA - 1.0);
        }

        public double getMinimumB() {
            return this.minimumB;
        }

        public void setMinimumB(double minimumB) {
            this.minimumB = minimumB;
        }
    }
}

