/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.LookUpColorRgb;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class LookUpColorRgbFormats {

    public static class SB_F32
    implements LookUpColorRgb<GrayF32> {
        GrayF32 image;

        @Override
        public void setImage(GrayF32 image) {
            this.image = image;
        }

        @Override
        public int lookupRgb(int x, int y) {
            int v = (int)this.image.unsafe_get(x, y);
            return v << 16 | v << 8 | v;
        }

        @Override
        public ImageType<GrayF32> getImageType() {
            return ImageType.SB_F32;
        }
    }

    public static class SB_U8
    implements LookUpColorRgb<GrayU8> {
        GrayU8 image;

        @Override
        public void setImage(GrayU8 image) {
            this.image = image;
        }

        @Override
        public int lookupRgb(int x, int y) {
            int v = this.image.unsafe_get(x, y);
            return v << 16 | v << 8 | v;
        }

        @Override
        public ImageType<GrayU8> getImageType() {
            return ImageType.SB_U8;
        }
    }

    public static class IL_F32
    implements LookUpColorRgb<InterleavedF32> {
        InterleavedF32 image;

        @Override
        public void setImage(InterleavedF32 image) {
            BoofMiscOps.checkTrue(image.getNumBands() >= 3);
            this.image = image;
        }

        @Override
        public int lookupRgb(int x, int y) {
            int index = this.image.getIndex(x, y, 0);
            int red = (int)this.image.data[index];
            int green = (int)this.image.data[index + 1];
            int blue = (int)this.image.data[index + 2];
            return red << 16 | green << 8 | blue;
        }

        @Override
        public ImageType<InterleavedF32> getImageType() {
            return ImageType.IL_F32;
        }
    }

    public static class IL_U8
    implements LookUpColorRgb<InterleavedU8> {
        InterleavedU8 image;

        @Override
        public void setImage(InterleavedU8 image) {
            BoofMiscOps.checkTrue(image.getNumBands() >= 3);
            this.image = image;
        }

        @Override
        public int lookupRgb(int x, int y) {
            return this.image.get24(x, y);
        }

        @Override
        public ImageType<InterleavedU8> getImageType() {
            return ImageType.IL_U8;
        }
    }

    public static class PL_F32
    implements LookUpColorRgb<Planar<GrayF32>> {
        Planar<GrayF32> image;

        @Override
        public void setImage(Planar<GrayF32> image) {
            BoofMiscOps.checkTrue(image.getNumBands() >= 3);
            this.image = image;
        }

        @Override
        public int lookupRgb(int x, int y) {
            int index = this.image.getIndex(x, y);
            int red = (int)((GrayF32[])this.image.bands)[0].data[index];
            int green = (int)((GrayF32[])this.image.bands)[1].data[index];
            int blue = (int)((GrayF32[])this.image.bands)[2].data[index];
            return red << 16 | green << 8 | blue;
        }

        @Override
        public ImageType<Planar<GrayF32>> getImageType() {
            return ImageType.PL_F32;
        }
    }

    public static class PL_U8
    implements LookUpColorRgb<Planar<GrayU8>> {
        Planar<GrayU8> image;

        @Override
        public void setImage(Planar<GrayU8> image) {
            BoofMiscOps.checkTrue(image.getNumBands() >= 3);
            this.image = image;
        }

        @Override
        public int lookupRgb(int x, int y) {
            return this.image.get24u8(x, y);
        }

        @Override
        public ImageType<Planar<GrayU8>> getImageType() {
            return ImageType.PL_U8;
        }
    }
}

