/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.convert.ConvertTupleDesc;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribePoint;
import boofcv.abst.feature.describe.DescribePointConvertTuple;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.describe.DescribeRadiusAngle_Point;
import boofcv.abst.feature.describe.DescribeSurf_Point;
import boofcv.abst.feature.orientation.ConfigOrientation2;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.describe.ConfigConvertTupleDesc;
import boofcv.factory.feature.describe.ConfigDescribePoint;
import boofcv.factory.feature.describe.FactoryConvertTupleDesc;
import boofcv.factory.feature.describe.FactoryDescribeAlgs;
import boofcv.factory.feature.describe.FactoryDescribePointRadiusAngle;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class FactoryDescribePoint {
    public static <T extends ImageGray<T>, TD extends TupleDesc<TD>> DescribePoint<T, TD> generic(ConfigDescribePoint config, ImageType<T> imageType) {
        DescribePoint<T, TupleDesc_F64> describePoint;
        Class imageClass = imageType.getImageClass();
        switch (config.descriptors.type) {
            case SURF_FAST: {
                describePoint = FactoryDescribePoint.surfFast(config.descriptors.surfFast, config.orientation, config.radius, imageClass);
                break;
            }
            case SURF_STABLE: {
                describePoint = FactoryDescribePoint.surfStable(config.descriptors.surfStability, config.orientation, config.radius, imageClass);
                break;
            }
            default: {
                DescribePointRadiusAngle radAng = FactoryDescribePointRadiusAngle.generic(config.descriptors, imageType);
                Class integralType = GIntegralImageOps.getIntegralType(imageType.getImageClass());
                OrientationIntegral orientationII = FactoryOrientation.genericIntegral(config.orientation, integralType);
                OrientationImage orientation = FactoryOrientation.convertImage(orientationII, imageType.getImageClass());
                describePoint = new DescribeRadiusAngle_Point(radAng, orientation, config.radius);
                break;
            }
        }
        DescribeSurf_Point ret = describePoint;
        if (config.convert.outputData == ConfigConvertTupleDesc.DataType.NATIVE) {
            return ret;
        }
        int dof = ret.createDescription().size();
        ConvertTupleDesc converter = FactoryConvertTupleDesc.generic(config.convert, dof, ret.getDescriptionType());
        return new DescribePointConvertTuple(ret, converter);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribeSurf_Point<T, II> surfFast(@Nullable ConfigSurfDescribe.Fast configSurf, ConfigOrientation2 configOrientation, double regionRadius, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurf alg = FactoryDescribeAlgs.surfSpeed(configSurf, integralType);
        OrientationIntegral orientationII = FactoryOrientation.genericIntegral(configOrientation, integralType);
        return new DescribeSurf_Point(alg, orientationII, regionRadius, imageType);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribeSurf_Point<T, II> surfStable(@Nullable ConfigSurfDescribe.Stability config, ConfigOrientation2 configOrientation, double regionRadius, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurfMod alg = FactoryDescribeAlgs.surfStability(config, integralType);
        OrientationIntegral orientationII = FactoryOrientation.genericIntegral(configOrientation, integralType);
        return new DescribeSurf_Point(alg, orientationII, regionRadius, imageType);
    }
}

