/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.Configuration;

public class ConfigSelfCalibDualQuadratic
implements Configuration {
    public boolean zeroSkew = true;
    public boolean knownAspectRatio = true;
    public double aspectRatio = 1.0;
    public double invalidFractionAccept = 0.15;
    public ConfigConverge refineAlgebraic = new ConfigConverge(1.0E-12, 1.0E-8, 20);

    @Override
    public void checkValidity() {
        this.refineAlgebraic.checkValidity();
        BoofMiscOps.checkTrue(this.aspectRatio > 0.0);
        BoofMiscOps.checkTrue(this.invalidFractionAccept >= 0.0 && this.invalidFractionAccept <= 1.0);
        BoofMiscOps.checkTrue(this.knownAspectRatio && this.zeroSkew, "If aspect ratio is known then zero skew must be assumed");
    }

    public void setTo(ConfigSelfCalibDualQuadratic src) {
        this.zeroSkew = src.zeroSkew;
        this.knownAspectRatio = src.knownAspectRatio;
        this.aspectRatio = src.aspectRatio;
        this.invalidFractionAccept = src.invalidFractionAccept;
        this.refineAlgebraic.setTo(src.refineAlgebraic);
    }
}

