/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import boofcv.io.calibration.CalibrationIO;
import boofcv.struct.Configuration;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class SerializeConfigYaml {
    public static void serialize(Configuration config, @Nullable Object canonical, Writer writer) {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("BoofCV.Version", "0.38");
        state.put("BoofCV.GIT_SHA", "29857de215a2187e09e4203629ecf6b58c61a513");
        state.put(config.getClass().getName(), SerializeConfigYaml.serialize(config, canonical));
        try {
            writer.write("# Serialized " + config.getClass().getName() + "\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(state, writer);
    }

    static Map<String, Object> serialize(Object config, @Nullable Object canonical) {
        HashMap<String, Object> state = new HashMap<String, Object>();
        Class<?> type = config.getClass();
        try {
            Field[] fields;
            for (Field f : fields = type.getFields()) {
                Map<String, Object> result;
                if (f.getType().isEnum() || f.getType().isPrimitive() || f.getType().getName().equals("java.lang.String")) {
                    if (canonical != null && f.get(config).equals(f.get(canonical))) continue;
                    state.put(f.getName(), f.get(config));
                    continue;
                }
                try {
                    type.getMethod("setTo", type);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Referenced object which is not enum, primitive, or a valid class");
                }
                Map<String, Object> map = result = canonical != null ? SerializeConfigYaml.serialize(f.get(config), f.get(canonical)) : SerializeConfigYaml.serialize(f.get(config), null);
                if (result.isEmpty()) continue;
                state.put(f.getName(), result);
            }
            return state;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Configuration> T deserialize(Reader reader) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map state = (Map)yaml.load(reader);
        try {
            for (String key : state.keySet()) {
                if (key.startsWith("BoofCV")) continue;
                Configuration config = (Configuration)Class.forName(key).getConstructor(new Class[0]).newInstance(new Object[0]);
                SerializeConfigYaml.deserialize(config, (Map)state.get(key));
                return (T)config;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Couldn't find object to deserialize");
    }

    private static void deserialize(Object parent, Map<String, Object> state) {
        Class<?> type = parent.getClass();
        try {
            for (String key : state.keySet()) {
                Field f = type.getField(key);
                Class<?> ftype = f.getType();
                if (ftype.isEnum()) {
                    f.set(parent, state.get(key));
                    continue;
                }
                if (ftype.isPrimitive()) {
                    Object value = state.get(key);
                    if (ftype == Boolean.TYPE) {
                        f.set(parent, (boolean)((Boolean)value));
                        continue;
                    }
                    if (ftype == Byte.TYPE) {
                        f.set(parent, ((Number)value).byteValue());
                        continue;
                    }
                    if (ftype == Character.TYPE) {
                        f.set(parent, Character.valueOf(((Character)value).charValue()));
                        continue;
                    }
                    if (ftype == Short.TYPE) {
                        f.set(parent, ((Number)value).shortValue());
                        continue;
                    }
                    if (ftype == Integer.TYPE) {
                        f.set(parent, ((Number)value).intValue());
                        continue;
                    }
                    if (ftype == Long.TYPE) {
                        f.set(parent, ((Number)value).longValue());
                        continue;
                    }
                    if (ftype == Float.TYPE) {
                        f.set(parent, Float.valueOf(((Number)value).floatValue()));
                        continue;
                    }
                    if (ftype == Double.TYPE) {
                        f.set(parent, ((Number)value).doubleValue());
                        continue;
                    }
                    throw new RuntimeException("Unknown primitive " + ftype);
                }
                if (ftype.getName().equals("java.lang.String")) {
                    f.set(parent, state.get(key));
                    continue;
                }
                Object child = ftype.getConstructor(new Class[0]).newInstance(new Object[0]);
                SerializeConfigYaml.deserialize(child, (Map)state.get(key));
                Class<?> c = child.getClass();
                c.getMethod("setTo", c).invoke(f.get(parent), child);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

