/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public class ConfigConverge
implements Configuration {
    public double ftol;
    public double gtol;
    public int maxIterations;

    public ConfigConverge(double ftol, double gtol, int maxIterations) {
        this.ftol = ftol;
        this.gtol = gtol;
        this.maxIterations = maxIterations;
    }

    public ConfigConverge(ConfigConverge src) {
        this.setTo(src);
    }

    public ConfigConverge() {
    }

    public void setTo(double ftol, double gtol, int maxIterations) {
        this.ftol = ftol;
        this.gtol = gtol;
        this.maxIterations = maxIterations;
    }

    public void setTo(ConfigConverge src) {
        this.ftol = src.ftol;
        this.gtol = src.gtol;
        this.maxIterations = src.maxIterations;
    }

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.ftol >= 0.0 && this.ftol <= 1.0, "ftol is out of range");
        BoofMiscOps.checkTrue(this.gtol >= 0.0, "gtol is out of range");
        if (this.maxIterations < 0) {
            throw new IllegalArgumentException("Max iterations has to be set to a value more than or equal to zero");
        }
    }
}

