/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigGenerator;
import boofcv.struct.ConfigGeneratorPatternSearchBase;
import boofcv.struct.Configuration;
import org.ddogleg.struct.DogArray_I32;

public class ConfigGeneratorGrid<Config extends Configuration>
extends ConfigGeneratorPatternSearchBase<Config> {
    DogArray_I32 parameterStates = new DogArray_I32();

    public ConfigGeneratorGrid(long seed, Class<Config> type) {
        super(seed, type);
    }

    @Override
    public String toStringSettings() {
        String ret = "Grid:\n";
        ret = ret + "discretization," + this.rangeDiscretization + "\n";
        ret = ret + super.toStringSettings();
        ret = ret + "rules:\n";
        for (String key : this.pathToRule.keySet()) {
            ret = ret + key + "," + this.pathToRule.get(key) + "\n";
        }
        return ret;
    }

    @Override
    public void initialize() {
        int i;
        super.initialize();
        this.configurationWork = BoofMiscOps.copyConfig(this.configurationBase);
        this.parameterStates.resetResize(this.parameters.size(), 0);
        this.numTrials = 1;
        for (i = 0; i < this.parameters.size(); ++i) {
            this.numTrials *= this.getNumberOfStates((ConfigGenerator.Parameter)this.parameters.get(i));
            if (this.numTrials >= 0) continue;
            throw new IllegalArgumentException("Too many possible states in the grid search. Exceeded size of an int. Try random sampling instead?");
        }
        try {
            for (i = 0; i < this.parameters.size(); ++i) {
                ConfigGenerator.Parameter p = (ConfigGenerator.Parameter)this.parameters.get(i);
                ConfigGeneratorGrid.assignValue(this.configurationWork, p.getPath(), p.selectValue(0.0));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Config next() {
        ++this.trial;
        this.configCurrent = BoofMiscOps.copyConfig(this.configurationWork);
        try {
            boolean finished = false;
            for (int i = 0; i < this.parameters.size() && !finished; ++i) {
                ConfigGenerator.Parameter p = (ConfigGenerator.Parameter)this.parameters.get(i);
                int state = this.parameterStates.get(i);
                int numStates = this.getNumberOfStates(p);
                if (++state >= numStates) {
                    this.parameterStates.set(i, 0);
                    state = 0;
                } else {
                    this.parameterStates.set(i, state);
                    finished = true;
                }
                double fraction = numStates == 1 ? 0.0 : (double)state / (double)(numStates - 1);
                ConfigGeneratorGrid.assignValue(this.configurationWork, p.getPath(), p.selectValue(fraction));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Config)this.configCurrent;
    }
}

