/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;

public class ListIntPoint2D {
    DogArray_I32 points = new DogArray_I32();
    int imageWidth;

    public void configure(int width, int height) {
        this.imageWidth = width;
        this.points.reset();
    }

    public void add(int x, int y) {
        this.points.add(y * this.imageWidth + x);
    }

    public void get(int index, Point2D_I16 p) {
        int v = this.points.data[index];
        p.x = (short)(v % this.imageWidth);
        p.y = (short)(v / this.imageWidth);
    }

    public void get(int index, Point2D_I32 p) {
        int v = this.points.data[index];
        p.x = v % this.imageWidth;
        p.y = v / this.imageWidth;
    }

    public void get(int index, Point2D_F32 p) {
        int v = this.points.data[index];
        p.x = v % this.imageWidth;
        p.y = v / this.imageWidth;
    }

    public void get(int index, Point2D_F64 p) {
        int v = this.points.data[index];
        p.x = v % this.imageWidth;
        p.y = v / this.imageWidth;
    }

    public Point2D_I32 get(int index) {
        Point2D_I32 p = new Point2D_I32();
        this.get(index, p);
        return p;
    }

    public void copyInto(DogArray<Point2D_I16> dst) {
        for (int i = 0; i < this.points.size; ++i) {
            this.get(i, dst.grow());
        }
    }

    public int size() {
        return this.points.size;
    }

    public DogArray_I32 getPoints() {
        return this.points;
    }
}

