/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.TupleDesc_B;
import org.ddogleg.struct.DogArray_I32;

public class PackedTupleArray_B
implements PackedArray<TupleDesc_B> {
    public final int dof;
    public final DogArray_I32 array;
    public final TupleDesc_B temp;
    protected int numElements;
    protected final int numInts;

    public PackedTupleArray_B(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_B(dof);
        this.numInts = this.temp.data.length;
        this.array = new DogArray_I32();
        this.array.resize(0);
    }

    @Override
    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    @Override
    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.numInts);
    }

    @Override
    public void append(TupleDesc_B element) {
        this.array.addAll(element.data, 0, this.numInts);
        ++this.numElements;
    }

    @Override
    public TupleDesc_B getTemp(int index) {
        System.arraycopy(this.array.data, index * this.numInts, this.temp.data, 0, this.numInts);
        return this.temp;
    }

    @Override
    public void getCopy(int index, TupleDesc_B dst) {
        System.arraycopy(this.array.data, index * this.numInts, dst.data, 0, this.numInts);
    }

    @Override
    public void copy(TupleDesc_B src, TupleDesc_B dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.numInts);
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public Class<TupleDesc_B> getElementType() {
        return TupleDesc_B.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_B> op) {
        int pointIndex = idx0;
        idx1 *= this.numInts;
        for (int i = idx0 *= this.numInts; i < idx1; i += this.numInts) {
            System.arraycopy(this.array.data, i, this.temp.data, 0, this.numInts);
            op.process(pointIndex++, this.temp);
        }
    }
}

