/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.TupleDesc_S8;
import org.ddogleg.struct.BigDogArray_I8;
import org.ddogleg.struct.BigDogGrowth;

public class PackedTupleBigArray_S8
implements PackedArray<TupleDesc_S8> {
    public final int dof;
    public final BigDogArray_I8 array;
    public final TupleDesc_S8 temp;
    protected int numElements;

    public PackedTupleBigArray_S8(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_S8(dof);
        this.array = new BigDogArray_I8(dof, dof * 65536, BigDogGrowth.GROW_FIRST);
        this.array.resize(0);
    }

    @Override
    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    @Override
    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
    }

    @Override
    public void append(TupleDesc_S8 element) {
        this.array.append(element.data, 0, this.dof);
        ++this.numElements;
    }

    @Override
    public TupleDesc_S8 getTemp(int index) {
        this.array.getArray(index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    @Override
    public void getCopy(int index, TupleDesc_S8 dst) {
        this.array.getArray(index * this.dof, dst.data, 0, this.dof);
    }

    @Override
    public void copy(TupleDesc_S8 src, TupleDesc_S8 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public Class<TupleDesc_S8> getElementType() {
        return TupleDesc_S8.class;
    }

    @Override
    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_S8> op) {
        this.array.processByBlock(idx0 * this.dof, idx1 * this.dof, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / this.dof;
            for (int i = arrayIdx0; i < arrayIdx1; i += this.dof) {
                System.arraycopy(array, i, this.temp.data, 0, this.dof);
                op.process(pointIndex++, this.temp);
            }
        });
    }
}

