/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.geo;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;

public class TrifocalTensor {
    public DMatrixRMaj T1 = new DMatrixRMaj(3, 3);
    public DMatrixRMaj T2 = new DMatrixRMaj(3, 3);
    public DMatrixRMaj T3 = new DMatrixRMaj(3, 3);

    public DMatrixRMaj getT(int index) {
        switch (index) {
            case 0: {
                return this.T1;
            }
            case 1: {
                return this.T2;
            }
            case 2: {
                return this.T3;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    public void setTo(TrifocalTensor a) {
        this.T1.setTo(a.T1);
        this.T2.setTo(a.T2);
        this.T3.setTo(a.T3);
    }

    public void convertFrom(DMatrixRMaj m) {
        if (m.getNumElements() != 27) {
            throw new IllegalArgumentException("Input matrix/vector must have 27 elements");
        }
        for (int i = 0; i < 9; ++i) {
            this.T1.data[i] = m.data[i];
            this.T2.data[i] = m.data[i + 9];
            this.T3.data[i] = m.data[i + 18];
        }
    }

    public void convertTo(DMatrixRMaj m) {
        if (m.getNumElements() != 27) {
            throw new IllegalArgumentException("Input matrix/vector must have 27 elements");
        }
        for (int i = 0; i < 9; ++i) {
            m.data[i] = this.T1.data[i];
            m.data[i + 9] = this.T2.data[i];
            m.data[i + 18] = this.T3.data[i];
        }
    }

    public TrifocalTensor copy() {
        TrifocalTensor ret = new TrifocalTensor();
        ret.T1.setTo(this.T1);
        ret.T2.setTo(this.T2);
        ret.T3.setTo(this.T3);
        return ret;
    }

    public void normalizeScale() {
        double sum = 0.0;
        sum += SpecializedOps_DDRM.elementSumSq(this.T1);
        sum += SpecializedOps_DDRM.elementSumSq(this.T2);
        double n = Math.sqrt(sum += SpecializedOps_DDRM.elementSumSq(this.T3));
        CommonOps_DDRM.scale(1.0 / n, this.T1);
        CommonOps_DDRM.scale(1.0 / n, this.T2);
        CommonOps_DDRM.scale(1.0 / n, this.T3);
    }

    public String toString() {
        return "TrifocalTensor {\nT1:\n" + this.T1 + "\nT2:\n" + this.T2 + "\nT3:\n" + this.T3 + "}";
    }

    public void print() {
        System.out.println(this);
    }
}

