/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;
import org.ddogleg.clustering.PointDistance;

public abstract class TuplePointDistanceEuclideanSq<T extends TupleDesc<T>>
implements PointDistance<T> {
    @Override
    public PointDistance<T> newInstanceThread() {
        return this;
    }

    public static class S8
    extends TuplePointDistanceEuclideanSq<TupleDesc_S8> {
        @Override
        public double distance(TupleDesc_S8 a, TupleDesc_S8 b) {
            return DescriptorDistance.euclideanSq(a, b);
        }
    }

    public static class U8
    extends TuplePointDistanceEuclideanSq<TupleDesc_U8> {
        @Override
        public double distance(TupleDesc_U8 a, TupleDesc_U8 b) {
            return DescriptorDistance.euclideanSq(a, b);
        }
    }

    public static class F32
    extends TuplePointDistanceEuclideanSq<TupleDesc_F32> {
        @Override
        public double distance(TupleDesc_F32 a, TupleDesc_F32 b) {
            return DescriptorDistance.euclideanSq(a, b);
        }
    }

    public static class F64
    extends TuplePointDistanceEuclideanSq<TupleDesc_F64> {
        @Override
        public double distance(TupleDesc_F64 a, TupleDesc_F64 b) {
            return DescriptorDistance.euclideanSq(a, b);
        }
    }
}

