/*
 * Decompiled with CFR 0.152.
 */
package deepboof.factory;

import deepboof.Tensor;
import deepboof.backward.DSpatialPadding2D;
import deepboof.backward.NumericalGradient;
import deepboof.forward.ConfigPadding;
import deepboof.impl.backward.standard.DClippedPadding2D_F64;
import deepboof.impl.backward.standard.DConstantPadding2D_F64;
import deepboof.impl.backward.standard.NumericalGradient_F64;
import deepboof.tensors.Tensor_F32;
import deepboof.tensors.Tensor_F64;

public class FactoryBackwards<T extends Tensor<T>> {
    Class<T> tensorType;

    public FactoryBackwards(Class<T> tensorType) {
        this.tensorType = tensorType;
    }

    public NumericalGradient<T> createNumericalGradient() {
        if (this.tensorType == Tensor_F64.class) {
            return new NumericalGradient_F64();
        }
        throw new IllegalArgumentException("Unknown");
    }

    public <P extends DSpatialPadding2D<T>> P spatialPadding(ConfigPadding config) {
        if (this.tensorType == Tensor_F64.class) {
            switch (config.type) {
                case ZERO: 
                case MAX_NEGATIVE: {
                    return (P)new DConstantPadding2D_F64(config);
                }
                case CLIPPED: {
                    return (P)new DClippedPadding2D_F64(config);
                }
            }
        } else if (this.tensorType == Tensor_F32.class) {
            // empty if block
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

