/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.line;

import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQRP_FDRM;
import org.ejml.interfaces.SolveNullSpace;

public class FitLineParametricSvd_F32 {
    float mean_x;
    float mean_y;
    float std_x;
    float std_y;
    public SolveNullSpace<FMatrixRMaj> solver = new SolveNullSpaceQRP_FDRM();
    FMatrixRMaj A = new FMatrixRMaj(1, 1);
    FMatrixRMaj AA = new FMatrixRMaj(1, 1);
    FMatrixRMaj ns = new FMatrixRMaj(2, 1);

    public boolean fit(List<Point2D_F32> points, LineParametric2D_F32 line) {
        this.computeNormalization(points);
        this.A.reshape(points.size(), 2);
        int idx = 0;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            this.A.data[idx++] = (p.x - this.mean_x) / this.std_x;
            this.A.data[idx++] = (p.y - this.mean_y) / this.std_y;
        }
        CommonOps_FDRM.multTransA(this.A, this.A, this.AA);
        if (this.solver.process(this.AA, 1, this.ns)) {
            line.p.setTo(this.mean_x, this.mean_y);
            line.slope.x = -this.ns.data[1] * this.std_x;
            line.slope.y = this.ns.data[0] * this.std_y;
            return true;
        }
        return false;
    }

    private void computeNormalization(List<Point2D_F32> points) {
        Point2D_F32 p;
        int i;
        this.mean_y = 0.0f;
        this.mean_x = 0.0f;
        this.std_y = 0.0f;
        this.std_x = 0.0f;
        for (i = 0; i < points.size(); ++i) {
            p = points.get(i);
            this.mean_x += p.x;
            this.mean_y += p.y;
        }
        this.mean_x /= (float)points.size();
        this.mean_y /= (float)points.size();
        for (i = 0; i < points.size(); ++i) {
            p = points.get(i);
            float dx = p.x - this.mean_x;
            float dy = p.y - this.mean_y;
            this.std_x += dx * dx;
            this.std_y += dy * dy;
        }
        this.std_x = this.std_x == 0.0f ? Math.abs(this.mean_x) : (float)Math.sqrt(this.std_x / (float)points.size());
        this.std_y = this.std_y == 0.0f ? Math.abs(this.mean_y) : (float)Math.sqrt(this.std_y / (float)points.size());
    }
}

