/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilPoint3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.se.Se3_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.SingularOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F32;

public class MotionSe3PointSVD_F32
implements MotionTransformPoint<Se3_F32, Point3D_F32> {
    private Se3_F32 motion = new Se3_F32();
    SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd(3, 3, true, true, false);

    @Override
    public Se3_F32 getTransformSrcToDst() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point3D_F32> srcPts, List<Point3D_F32> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        Point3D_F32 meanSrc = UtilPoint3D_F32.mean(srcPts, null);
        Point3D_F32 meanDst = UtilPoint3D_F32.mean(dstPts, null);
        int N = srcPts.size();
        float s11 = 0.0f;
        float s12 = 0.0f;
        float s13 = 0.0f;
        float s21 = 0.0f;
        float s22 = 0.0f;
        float s23 = 0.0f;
        float s31 = 0.0f;
        float s32 = 0.0f;
        float s33 = 0.0f;
        for (int i = 0; i < N; ++i) {
            Point3D_F32 f = srcPts.get(i);
            Point3D_F32 t = dstPts.get(i);
            float dfx = f.x - meanSrc.x;
            float dfy = f.y - meanSrc.y;
            float dfz = f.z - meanSrc.z;
            float dtx = t.x - meanDst.x;
            float dty = t.y - meanDst.y;
            float dtz = t.z - meanDst.z;
            s11 += dtx * dfx;
            s12 += dtx * dfy;
            s13 += dtx * dfz;
            s21 += dty * dfx;
            s22 += dty * dfy;
            s23 += dty * dfz;
            s31 += dtz * dfx;
            s32 += dtz * dfy;
            s33 += dtz * dfz;
        }
        FMatrixRMaj Sigma = new FMatrixRMaj(3, 3, true, s11, s12, s13, s21, s22, s23, s31, s32, s33);
        if (!this.svd.decompose(Sigma)) {
            return false;
        }
        FMatrixRMaj U = this.svd.getU(null, false);
        FMatrixRMaj V = this.svd.getV(null, false);
        SingularOps_FDRM.descendingOrder(U, false, this.svd.getSingularValues(), 3, V, false);
        if (CommonOps_FDRM.det(U) < 0.0f ^ CommonOps_FDRM.det(V) < 0.0f) {
            V.data[2] = -V.data[2];
            V.data[5] = -V.data[5];
            V.data[8] = -V.data[8];
        }
        CommonOps_FDRM.multTransB(U, V, this.motion.getR());
        Point3D_F32 temp = new Point3D_F32();
        GeometryMath_F32.mult(this.motion.getR(), meanSrc, temp);
        this.motion.getT().setTo(meanDst.x - temp.x, meanDst.y - temp.y, meanDst.z - temp.z);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

