/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point2D_F32;
import georegression.struct.trig.Circle2D_F32;

public class UtilCircle2D_F32 {
    public static float evaluate(float x, float y, Circle2D_F32 circle) {
        return (x -= circle.center.x) * x + (y -= circle.center.y) * y - circle.radius * circle.radius;
    }

    public static boolean circle(Point2D_F32 x0, Point2D_F32 x1, Point2D_F32 x2, Circle2D_F32 circle) {
        float xa = (x0.x + x1.x) / 2.0f;
        float ya = (x0.y + x1.y) / 2.0f;
        float xb = (x1.x + x2.x) / 2.0f;
        float yb = (x1.y + x2.y) / 2.0f;
        float m2 = x0.x - x1.x;
        float n1 = x1.y - x2.y;
        float n2 = x2.x - x1.x;
        float m1 = x1.y - x0.y;
        float bottom = m2 * n1 - n2 * m1;
        if (bottom == 0.0f) {
            return false;
        }
        float alpha = (-m2 * (xb - xa) + m1 * (yb - ya)) / bottom;
        circle.center.x = xb + n1 * alpha;
        circle.center.y = yb + n2 * alpha;
        circle.radius = circle.center.distance(x0);
        return true;
    }

    public static float circleRadiusSq(Point2D_F32 x0, Point2D_F32 x1, Point2D_F32 x2) {
        float xa = (x0.x + x1.x) / 2.0f;
        float ya = (x0.y + x1.y) / 2.0f;
        float xb = (x1.x + x2.x) / 2.0f;
        float yb = (x1.y + x2.y) / 2.0f;
        float m2 = x0.x - x1.x;
        float n1 = x1.y - x2.y;
        float n2 = x2.x - x1.x;
        float m1 = x1.y - x0.y;
        float bottom = m2 * n1 - n2 * m1;
        if (bottom == 0.0f) {
            return Float.NaN;
        }
        float alpha = (-m2 * (xb - xa) + m1 * (yb - ya)) / bottom;
        float dx = xb + n1 * alpha - x0.x;
        float dy = yb + n2 * alpha - x0.y;
        return dx * dx + dy * dy;
    }
}

