/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.UtilVector3D_F32;
import georegression.metric.ClosestPoint3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.plane.PlaneTangent3D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se3_F32;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class UtilPlane3D_F32 {
    public static PlaneGeneral3D_F32 convert(PlaneNormal3D_F32 input, @Nullable PlaneGeneral3D_F32 output) {
        if (output == null) {
            output = new PlaneGeneral3D_F32();
        }
        Vector3D_F32 n = input.n;
        Point3D_F32 p = input.p;
        output.A = n.x;
        output.B = n.y;
        output.C = n.z;
        output.D = n.x * p.x + n.y * p.y + n.z * p.z;
        return output;
    }

    public static PlaneNormal3D_F32 convert(PlaneGeneral3D_F32 input, @Nullable PlaneNormal3D_F32 output) {
        if (output == null) {
            output = new PlaneNormal3D_F32();
        }
        float top = -input.D;
        float n2 = input.A * input.A + input.B * input.B + input.C * input.C;
        output.p.x = -input.A * top / n2;
        output.p.y = -input.B * top / n2;
        output.p.z = -input.C * top / n2;
        output.n.setTo(input.A, input.B, input.C);
        return output;
    }

    public static PlaneNormal3D_F32 convert(PlaneTangent3D_F32 input, @Nullable PlaneNormal3D_F32 output) {
        if (output == null) {
            output = new PlaneNormal3D_F32();
        }
        output.n.x = input.x;
        output.n.y = input.y;
        output.n.z = input.z;
        output.p.setTo(input);
        return output;
    }

    public static PlaneNormal3D_F32 convert(Se3_F32 planeToWorld, @Nullable PlaneNormal3D_F32 output) {
        if (output == null) {
            output = new PlaneNormal3D_F32();
        }
        output.n.x = planeToWorld.R.unsafe_get(0, 2);
        output.n.y = planeToWorld.R.unsafe_get(1, 2);
        output.n.z = planeToWorld.R.unsafe_get(2, 2);
        output.p.setTo(planeToWorld.T.x, planeToWorld.T.y, planeToWorld.T.z);
        return output;
    }

    public static void hessianNormalForm(PlaneGeneral3D_F32 plane) {
        float n = (float)Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
        plane.A /= n;
        plane.B /= n;
        plane.C /= n;
        plane.D /= n;
    }

    public static float evaluate(PlaneGeneral3D_F32 plane, Point3D_F32 point) {
        return plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
    }

    public static float evaluate(PlaneNormal3D_F32 plane, Point3D_F32 point) {
        float dx = point.x - plane.p.x;
        float dy = point.y - plane.p.y;
        float dz = point.z - plane.p.z;
        return plane.n.x * dx + plane.n.y * dy + plane.n.z * dz;
    }

    public static void selectAxis2D(Vector3D_F32 normal, Vector3D_F32 axisX, Vector3D_F32 axisY) {
        UtilVector3D_F32.perpendicularCanonical(normal, axisX);
        axisX.normalize();
        axisY.crossSetTo(normal, axisX);
        axisY.normalize();
    }

    public static void point3Dto2D(Point3D_F32 pointOnPlane, Vector3D_F32 axisX, Vector3D_F32 axisY, Point3D_F32 A, Point2D_F32 output) {
        float x = A.x - pointOnPlane.x;
        float y = A.y - pointOnPlane.y;
        float z = A.z - pointOnPlane.z;
        output.x = x * axisX.x + y * axisX.y + z * axisX.z;
        output.y = x * axisY.x + y * axisY.y + z * axisY.z;
    }

    public static void point2Dto3D(Point3D_F32 origin, Vector3D_F32 axisX, Vector3D_F32 axisY, Point2D_F32 A, Point3D_F32 output) {
        output.x = origin.x + axisX.x * A.x + axisY.y * A.y;
        output.y = origin.y + axisX.y * A.x + axisY.y * A.y;
        output.z = origin.z + axisX.z * A.x + axisY.y * A.y;
    }

    public static boolean equals(PlaneNormal3D_F32 a, PlaneNormal3D_F32 b, float tol) {
        PlaneGeneral3D_F32 genA = UtilPlane3D_F32.convert(a, null);
        PlaneGeneral3D_F32 genB = UtilPlane3D_F32.convert(b, null);
        float normA = (float)Math.sqrt(genA.A * genA.A + genA.B * genA.B + genA.C * genA.C + genA.D * genA.D);
        float normB = (float)Math.sqrt(genB.A * genB.A + genB.B * genB.B + genB.C * genB.C + genB.D * genB.D);
        genA.A /= normA;
        genA.B /= normA;
        genA.C /= normA;
        genA.D /= normA;
        genB.A /= normB;
        genB.B /= normB;
        genB.C /= normB;
        genB.D /= normB;
        int numMatch0 = 0;
        if (Math.abs(genA.A - genB.A) <= tol) {
            ++numMatch0;
        }
        if (Math.abs(genA.B - genB.B) <= tol) {
            ++numMatch0;
        }
        if (Math.abs(genA.C - genB.C) <= tol) {
            ++numMatch0;
        }
        if (Math.abs(genA.D - genB.D) <= tol) {
            ++numMatch0;
        }
        if (numMatch0 == 4) {
            return true;
        }
        if (Math.abs(genA.A + genB.A) > tol) {
            return false;
        }
        if (Math.abs(genA.B + genB.B) > tol) {
            return false;
        }
        if (Math.abs(genA.C + genB.C) > tol) {
            return false;
        }
        return !(Math.abs(genA.D + genB.D) > tol);
    }

    public static Se3_F32 planeToWorld(PlaneGeneral3D_F32 plane, @Nullable Se3_F32 planeToWorld) {
        if (planeToWorld == null) {
            planeToWorld = new Se3_F32();
        }
        Vector3D_F32 axisZ = new Vector3D_F32(plane.A, plane.B, plane.C);
        axisZ.normalize();
        Vector3D_F32 axisX = new Vector3D_F32();
        Vector3D_F32 axisY = new Vector3D_F32();
        UtilPlane3D_F32.selectAxis2D(axisZ, axisX, axisY);
        return UtilPlane3D_F32.planeToWorld(plane, axisX, axisY, axisZ, planeToWorld);
    }

    public static Se3_F32 planeToWorld(PlaneGeneral3D_F32 plane, Vector3D_F32 axisX, Vector3D_F32 axisY, Vector3D_F32 axisZ, @Nullable Se3_F32 planeToWorld) {
        if (planeToWorld == null) {
            planeToWorld = new Se3_F32();
        }
        FMatrixRMaj R = planeToWorld.R;
        R.data[0] = axisX.x;
        R.data[1] = axisY.x;
        R.data[2] = axisZ.x;
        R.data[3] = axisX.y;
        R.data[4] = axisY.y;
        R.data[5] = axisZ.y;
        R.data[6] = axisX.z;
        R.data[7] = axisY.z;
        R.data[8] = axisZ.z;
        Point3D_F32 cp = ClosestPoint3D_F32.closestPointOrigin(plane, null);
        planeToWorld.getT().setTo(cp.x, cp.y, cp.z);
        return planeToWorld;
    }
}

