/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;
import org.jetbrains.annotations.Nullable;

public class UtilVector2D_F64 {
    public static double acute(Vector2D_F64 a, Vector2D_F64 b) {
        double dot = a.dot(b);
        double value = dot / (a.norm() * b.norm());
        if (value > 1.0) {
            value = 1.0;
        } else if (value < -1.0) {
            value = -1.0;
        }
        return Math.acos(value);
    }

    public static double acute(double ax, double ay, double bx, double by) {
        double nb;
        double dot = ax * bx + ay * by;
        double na = Math.sqrt(ax * ax + ay * ay);
        double value = dot / (na * (nb = Math.sqrt(bx * bx + by * by)));
        if (value > 1.0) {
            value = 1.0;
        } else if (value < -1.0) {
            value = -1.0;
        }
        return Math.acos(value);
    }

    public static Vector2D_F64 minus(Point2D_F64 a, Point2D_F64 b, @Nullable Vector2D_F64 output) {
        if (output == null) {
            output = new Vector2D_F64();
        }
        output.x = a.x - b.x;
        output.y = a.y - b.y;
        return output;
    }

    public static boolean identicalSign(double xa, double ya, double xb, double yb, double tol) {
        double dx0 = xb - xa;
        double dy0 = yb - ya;
        double error0 = dx0 * dx0 + dy0 * dy0;
        double dx1 = xb + xa;
        double dy1 = yb + ya;
        double error1 = dx1 * dx1 + dy1 * dy1;
        if (error0 < error1) {
            return error0 <= tol * tol;
        }
        return error1 <= tol * tol;
    }
}

