/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Vector3D_F32;
import java.util.Random;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class UtilVector3D_F32 {
    public static Vector3D_F32 createRandom(float min, float max, Random rand) {
        float range = max - min;
        Vector3D_F32 a = new Vector3D_F32();
        a.x = range * rand.nextFloat() + min;
        a.y = range * rand.nextFloat() + min;
        a.z = range * rand.nextFloat() + min;
        return a;
    }

    public static Vector3D_F32 perpendicularCanonical(Vector3D_F32 A, @Nullable Vector3D_F32 output) {
        float scale;
        if (output == null) {
            output = new Vector3D_F32();
        }
        if ((scale = Math.abs(A.x) + Math.abs(A.y) + Math.abs(A.z)) == 0.0f) {
            output.setTo(0.0f, 0.0f, 0.0f);
        } else {
            float x = A.x / scale;
            float y = A.y / scale;
            float z = A.z / scale;
            if (Math.abs(x) > Math.abs(y)) {
                output.setTo(z, 0.0f, -x);
            } else {
                output.setTo(0.0f, z, -y);
            }
        }
        return output;
    }

    public static boolean isIdentical(Vector3D_F32 a, Vector3D_F32 b, float tol) {
        if (Math.abs(a.x - b.x) > tol) {
            return false;
        }
        if (Math.abs(a.y - b.y) > tol) {
            return false;
        }
        return Math.abs(a.z - b.z) <= tol;
    }

    public static void normalize(Vector3D_F32 v) {
        float a = v.norm();
        v.x /= a;
        v.y /= a;
        v.z /= a;
    }

    public static FMatrixRMaj createMatrix(@Nullable FMatrixRMaj R, Vector3D_F32 ... v) {
        if (R == null) {
            R = new FMatrixRMaj(3, v.length);
        }
        for (int i = 0; i < v.length; ++i) {
            R.set(0, i, v[i].x);
            R.set(1, i, v[i].y);
            R.set(2, i, v[i].z);
        }
        return R;
    }

    public static Vector3D_F32 convert(FMatrixRMaj m) {
        Vector3D_F32 v = new Vector3D_F32();
        v.x = m.data[0];
        v.y = m.data[1];
        v.z = m.data[2];
        return v;
    }

    public static float acute(GeoTuple3D_F32 a, GeoTuple3D_F32 b) {
        float dot = a.x * b.x + a.y * b.y + a.z * b.z;
        float value = dot / (a.norm() * b.norm());
        if (value > 1.0f) {
            value = 1.0f;
        } else if (value < -1.0f) {
            value = -1.0f;
        }
        return (float)Math.acos(value);
    }

    public static int axisMaxMag(GeoTuple3D_F32<?> v) {
        int bestAxis = -1;
        float best = -1.0f;
        for (int i = 0; i < 3; ++i) {
            float m = Math.abs(v.getIdx(i));
            if (!(m > best)) continue;
            best = m;
            bestAxis = i;
        }
        return bestAxis;
    }
}

