/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry.lines;

import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.point.Point3D_F32;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_FDRM;
import org.ejml.interfaces.SolveNullSpace;

public class IntersectionLinesGeneral_F32 {
    public SolveNullSpace<FMatrixRMaj> solver = new SolveNullSpaceSvd_FDRM();
    protected final FMatrixRMaj A = new FMatrixRMaj(1, 1);
    protected final FMatrixRMaj x = new FMatrixRMaj(3, 1);

    public boolean process(List<LineGeneral2D_F32> lines, Point3D_F32 intersection) {
        if (lines.size() < 2) {
            throw new IllegalArgumentException("At least two lines are needed");
        }
        this.A.reshape(lines.size(), 3);
        for (int row = 0; row < lines.size(); ++row) {
            LineGeneral2D_F32 l = lines.get(row);
            this.A.data[row * 3] = l.A;
            this.A.data[row * 3 + 1] = l.B;
            this.A.data[row * 3 + 2] = l.C;
        }
        if (!this.solver.process(this.A, 1, this.x)) {
            return false;
        }
        intersection.setTo(this.x.get(0), this.x.get(1), this.x.get(2));
        return true;
    }
}

