/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry.polygon;

import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Rectangle2D_F64;

public class AreaIntersectionPolygon2D_F64 {
    static final double gamut = 5.0E8;
    static final double mid = 2.5E8;
    private long ssss;
    private double sclx;
    private double scly;

    public double computeArea(Polygon2D_F64 a, Polygon2D_F64 b) {
        this.ssss = 0L;
        this.sclx = 0.0;
        this.scly = 0.0;
        return this.inter(a, b);
    }

    private static void range(Polygon2D_F64 points, Rectangle2D_F64 bbox) {
        UtilPolygons2D_F64.bounding(points, bbox);
    }

    private static long area(Point2D_I32 a, Point2D_I32 p, Point2D_I32 q) {
        return (long)p.x * (long)q.y - (long)p.y * (long)q.x + (long)a.x * (long)(p.y - q.y) + (long)a.y * (long)(q.x - p.x);
    }

    private static boolean ovl(Rng p, Rng q) {
        return p.mn < q.mx && q.mn < p.mx;
    }

    private void cntrib(int f_x, int f_y, int t_x, int t_y, int w) {
        this.ssss += (long)w * (long)(t_x - f_x) * (long)(t_y + f_y) / 2L;
    }

    private void fit(Polygon2D_F64 x, Vertex[] ix, int fudge, Rectangle2D_F64 B) {
        int c = x.size();
        while (c-- > 0) {
            ix[c] = new Vertex();
            ix[c].ip = new Point2D_I32();
            ix[c].ip.x = (int)((x.get(c).getX() - B.p0.x) * this.sclx - 2.5E8) & 0xFFFFFFF8 | fudge | c & 1;
            ix[c].ip.y = (int)((x.get(c).getY() - B.p0.y) * this.scly - 2.5E8) & 0xFFFFFFF8 | fudge;
        }
        ix[0].ip.y += x.size() & 1;
        ix[x.size()] = ix[0];
        c = x.size();
        while (c-- > 0) {
            ix[c].rx = ix[c].ip.x < ix[c + 1].ip.x ? new Rng(ix[c].ip.x, ix[c + 1].ip.x) : new Rng(ix[c + 1].ip.x, ix[c].ip.x);
            ix[c].ry = ix[c].ip.y < ix[c + 1].ip.y ? new Rng(ix[c].ip.y, ix[c + 1].ip.y) : new Rng(ix[c + 1].ip.y, ix[c].ip.y);
            ix[c].in = 0;
        }
    }

    private void cross(Vertex a, Vertex b, Vertex c, Vertex d, double a1, double a2, double a3, double a4) {
        double r1 = a1 / (a1 + a2);
        double r2 = a3 / (a3 + a4);
        this.cntrib((int)((double)a.ip.x + r1 * (double)(b.ip.x - a.ip.x)), (int)((double)a.ip.y + r1 * (double)(b.ip.y - a.ip.y)), b.ip.x, b.ip.y, 1);
        this.cntrib(d.ip.x, d.ip.y, (int)((double)c.ip.x + r2 * (double)(d.ip.x - c.ip.x)), (int)((double)c.ip.y + r2 * (double)(d.ip.y - c.ip.y)), 1);
        ++a.in;
        --c.in;
    }

    private void inness(Vertex[] P, int cP, Vertex[] Q, int cQ) {
        int s = 0;
        int c = cQ;
        Point2D_I32 p = P[0].ip;
        while (c-- > 0) {
            if (Q[c].rx.mn >= p.x || p.x >= Q[c].rx.mx) continue;
            boolean sgn = 0L < AreaIntersectionPolygon2D_F64.area(p, Q[c].ip, Q[c + 1].ip);
            s += sgn != Q[c].ip.x < Q[c + 1].ip.x ? 0 : (sgn ? -1 : 1);
        }
        for (int j = 0; j < cP; ++j) {
            if (s != 0) {
                this.cntrib(P[j].ip.x, P[j].ip.y, P[j + 1].ip.x, P[j + 1].ip.y, s);
            }
            s += P[j].in;
        }
    }

    private double inter(Polygon2D_F64 a, Polygon2D_F64 b) {
        if (a.size() < 3 || b.size() < 3) {
            return 0.0;
        }
        Vertex[] ipa = new Vertex[a.size() + 1];
        Vertex[] ipb = new Vertex[b.size() + 1];
        Rectangle2D_F64 bbox = new Rectangle2D_F64(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
        AreaIntersectionPolygon2D_F64.range(a, bbox);
        AreaIntersectionPolygon2D_F64.range(b, bbox);
        double rngx = bbox.p1.x - bbox.p0.x;
        this.sclx = 5.0E8 / rngx;
        double rngy = bbox.p1.y - bbox.p0.y;
        this.scly = 5.0E8 / rngy;
        double ascale = this.sclx * this.scly;
        this.fit(a, ipa, 0, bbox);
        this.fit(b, ipb, 2, bbox);
        for (int j = 0; j < a.size(); ++j) {
            for (int k = 0; k < b.size(); ++k) {
                long a4;
                long a3;
                long a2;
                long a1;
                boolean o;
                if (!AreaIntersectionPolygon2D_F64.ovl(ipa[j].rx, ipb[k].rx) || !AreaIntersectionPolygon2D_F64.ovl(ipa[j].ry, ipb[k].ry) || (o = (a1 = -AreaIntersectionPolygon2D_F64.area(ipa[j].ip, ipb[k].ip, ipb[k + 1].ip)) < 0L) != (a2 = AreaIntersectionPolygon2D_F64.area(ipa[j + 1].ip, ipb[k].ip, ipb[k + 1].ip)) < 0L || (a3 = AreaIntersectionPolygon2D_F64.area(ipb[k].ip, ipa[j].ip, ipa[j + 1].ip)) < 0L != (a4 = -AreaIntersectionPolygon2D_F64.area(ipb[k + 1].ip, ipa[j].ip, ipa[j + 1].ip)) < 0L) continue;
                if (o) {
                    this.cross(ipa[j], ipa[j + 1], ipb[k], ipb[k + 1], a1, a2, a3, a4);
                    continue;
                }
                this.cross(ipb[k], ipb[k + 1], ipa[j], ipa[j + 1], a3, a4, a1, a2);
            }
        }
        this.inness(ipa, a.size(), ipb, b.size());
        this.inness(ipb, b.size(), ipa, a.size());
        return (double)this.ssss / ascale;
    }

    static class Rng {
        int mn;
        int mx;

        Rng(int mn, int mx) {
            this.mn = mn;
            this.mx = mx;
        }
    }

    static class Vertex {
        Point2D_I32 ip;
        Rng rx;
        Rng ry;
        int in;

        Vertex() {
        }
    }
}

