/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;

public class Area2D_F64 {
    public static double triangle(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        double inner = a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
        return Math.abs(inner / 2.0);
    }

    public static double quadrilateral(Quadrilateral_F64 quad) {
        double dx;
        double dy;
        double bx = quad.b.x - quad.a.x;
        double cy = quad.c.y - quad.a.y;
        double by = quad.b.y - quad.a.y;
        double cx = quad.c.x - quad.a.x;
        if (bx * cy - by * cx >= 0.0 == cx * (dy = quad.d.y - quad.a.y) - cy * (dx = quad.d.x - quad.a.x) >= 0.0) {
            return Area2D_F64.triangle(quad.a, quad.b, quad.c) + Area2D_F64.triangle(quad.a, quad.c, quad.d);
        }
        return Area2D_F64.triangle(quad.a, quad.b, quad.d) + Area2D_F64.triangle(quad.b, quad.c, quad.d);
    }

    public static double polygonSimple(Polygon2D_F64 poly) {
        double total = 0.0;
        Point2D_F64 v0 = poly.get(0);
        Point2D_F64 v1 = poly.get(1);
        for (int i = 2; i < poly.size(); ++i) {
            Point2D_F64 v2 = poly.get(i);
            total += v1.x * (v2.y - v0.y);
            v0 = v1;
            v1 = v2;
        }
        Point2D_F64 v2 = poly.get(0);
        total += v1.x * (v2.y - v0.y);
        v0 = v1;
        v1 = v2;
        v2 = poly.get(1);
        return Math.abs((total += v1.x * (v2.y - v0.y)) / 2.0);
    }

    public static double rectangle(Rectangle2D_F64 r) {
        return r.area();
    }
}

