/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.fitting.curves.ClosestPointEllipseAngle_F64;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import org.jetbrains.annotations.Nullable;

public class ClosestPoint2D_F64 {
    public static Point2D_F64 closestPoint(LineGeneral2D_F64 line, Point2D_F64 p, @Nullable Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        double AA = line.A * line.A;
        double AB = line.A * line.B;
        double BB = line.B * line.B;
        output.y = AA * p.y - AB * p.x - line.B * line.C;
        output.y /= AA + BB;
        output.x = BB * p.x - AB * p.y - line.A * line.C;
        output.x /= AA + BB;
        return output;
    }

    public static Point2D_F64 closestPoint(LineParametric2D_F64 line, Point2D_F64 p, @Nullable Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        double t = ClosestPoint2D_F64.closestPointT(line, p);
        output.x = line.p.x + line.slope.x * t;
        output.y = line.p.y + line.slope.y * t;
        return output;
    }

    public static double closestPointT(LineParametric2D_F64 line, Point2D_F64 p) {
        double t = line.slope.x * (p.x - line.p.x) + line.slope.y * (p.y - line.p.y);
        return t /= line.slope.x * line.slope.x + line.slope.y * line.slope.y;
    }

    public static double closestPointT(LineParametric2D_F64 line, Point2D_F64 p, double scale) {
        double sx = line.slope.x / scale;
        double sy = line.slope.y / scale;
        double t = sx * (p.x - line.p.x) + sy * (p.y - line.p.y);
        return t /= sx * sx + sy * sy;
    }

    public static double closestPointT(LineParametric2D_F64 line, double x, double y) {
        double t = line.slope.x * (x - line.p.x) + line.slope.y * (y - line.p.y);
        return t /= line.slope.x * line.slope.x + line.slope.y * line.slope.y;
    }

    public static double closestPointT(LineParametric2D_F64 line, double x, double y, double scale) {
        double sx = line.slope.x / scale;
        double sy = line.slope.y / scale;
        double t = sx * (x - line.p.x) + sy * (y - line.p.y);
        return t /= sx * sx + sy * sy;
    }

    public static Point2D_F64 closestPoint(LineSegment2D_F64 line, Point2D_F64 p, @Nullable Point2D_F64 output) {
        if (output == null) {
            output = new Point2D_F64();
        }
        double slopeX = line.b.x - line.a.x;
        double slopeY = line.b.y - line.a.y;
        double t = slopeX * (p.x - line.a.x) + slopeY * (p.y - line.a.y);
        if ((t /= slopeX * slopeX + slopeY * slopeY) < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        output.x = line.a.x + slopeX * t;
        output.y = line.a.y + slopeY * t;
        return output;
    }

    public static Point2D_F64 closestPoint(EllipseRotated_F64 ellipse, Point2D_F64 p) {
        ClosestPointEllipseAngle_F64 alg = new ClosestPointEllipseAngle_F64(GrlConstants.TEST_F64, 30);
        alg.setEllipse(ellipse);
        alg.process(p);
        return alg.getClosest();
    }
}

