/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.GeometryMath_F32;
import georegression.misc.GrlConstants;
import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.line.LineSegment3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.shapes.Box3D_F32;
import georegression.struct.shapes.BoxLength3D_F32;
import georegression.struct.shapes.Sphere3D_F32;
import georegression.struct.shapes.Triangle3D_F32;
import org.ddogleg.struct.FastAccess;

public class Intersection3D_F32 {
    public static boolean intersection(PlaneNormal3D_F32 plane, LineParametric3D_F32 line, Point3D_F32 intersection) {
        float dx = plane.p.x - line.p.x;
        float dy = plane.p.y - line.p.y;
        float dz = plane.p.z - line.p.z;
        float top = dx * plane.n.x + dy * plane.n.y + dz * plane.n.z;
        float bottom = line.slope.dot(plane.n);
        if (bottom == 0.0f) {
            return false;
        }
        float d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersection(PlaneGeneral3D_F32 plane, LineParametric3D_F32 line, Point3D_F32 intersection) {
        float top = plane.D - plane.A * line.p.x - plane.B * line.p.y - plane.C * line.p.z;
        float bottom = plane.A * line.slope.x + plane.B * line.slope.y + plane.C * line.slope.z;
        if (bottom == 0.0f) {
            return false;
        }
        float d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersection(PlaneGeneral3D_F32 a, PlaneGeneral3D_F32 b, LineParametric3D_F32 line) {
        GeometryMath_F32.cross(a.A, a.B, a.C, b.A, b.B, b.C, line.slope);
        if (line.slope.normSq() == 0.0f) {
            return false;
        }
        float n2 = a.A * a.A + a.B * a.B + a.C * a.C;
        float closestX = a.A * a.D / n2;
        float closestY = a.B * a.D / n2;
        float closestZ = a.C * a.D / n2;
        float slopeX = a.B * line.slope.z - a.C * line.slope.y;
        float slopeY = a.C * line.slope.x - a.A * line.slope.z;
        float slopeZ = a.A * line.slope.y - a.B * line.slope.x;
        float top = b.D - b.A * closestX - b.B * closestY - b.C * closestZ;
        float bottom = b.A * slopeX + b.B * slopeY + b.C * slopeZ;
        float d = top / bottom;
        line.p.x = closestX + d * slopeX;
        line.p.y = closestY + d * slopeY;
        line.p.z = closestZ + d * slopeZ;
        return true;
    }

    public static int intersection(Triangle3D_F32 T, LineSegment3D_F32 R, Point3D_F32 output) {
        return Intersection3D_F32.intersection(T, R, output, new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32());
    }

    public static int intersection(Triangle3D_F32 T, LineSegment3D_F32 R, Point3D_F32 output, Vector3D_F32 u, Vector3D_F32 v, Vector3D_F32 n, Vector3D_F32 dir, Vector3D_F32 w0) {
        u.minus(T.v1, T.v0);
        v.minus(T.v2, T.v0);
        n.crossSetTo(u, v);
        if (n.normSq() == 0.0f) {
            return -1;
        }
        dir.minus(R.b, R.a);
        w0.minus(R.a, T.v0);
        float a = -n.dot(w0);
        float b = n.dot(dir);
        if (Math.abs(b) < GrlConstants.F_EPS) {
            if (a == 0.0f) {
                return 2;
            }
            return 0;
        }
        float r = a / b;
        if (r < 0.0f) {
            return 0;
        }
        if (r > 1.0f) {
            return 0;
        }
        output.x = R.a.x + r * dir.x;
        output.y = R.a.y + r * dir.y;
        output.z = R.a.z + r * dir.z;
        if (Intersection3D_F32.containedPlane(T.v0, output, u, v, w0)) {
            return 1;
        }
        return 0;
    }

    public static int intersection(Triangle3D_F32 T, LineParametric3D_F32 R, Point3D_F32 output) {
        return Intersection3D_F32.intersection(T, R, output, new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32());
    }

    public static int intersection(Triangle3D_F32 T, LineParametric3D_F32 R, Point3D_F32 output, Vector3D_F32 u, Vector3D_F32 v, Vector3D_F32 n, Vector3D_F32 w0) {
        u.minus(T.v1, T.v0);
        v.minus(T.v2, T.v0);
        n.crossSetTo(u, v);
        if (n.normSq() == 0.0f) {
            return -1;
        }
        Vector3D_F32 dir = R.slope;
        w0.minus(R.p, T.v0);
        float a = -n.dot(w0);
        float b = n.dot(dir);
        if (Math.abs(b) < GrlConstants.F_EPS) {
            if (a == 0.0f) {
                return 2;
            }
            return 0;
        }
        float r = a / b;
        output.x = R.p.x + r * dir.x;
        output.y = R.p.y + r * dir.y;
        output.z = R.p.z + r * dir.z;
        if (Intersection3D_F32.containedPlane(T.v0, output, u, v, w0)) {
            if (r >= 0.0f) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    public static int intersectConvex(FastAccess<Point3D_F32> polygon, LineParametric3D_F32 line, Point3D_F32 output, Vector3D_F32 n, Vector3D_F32 u, Vector3D_F32 v, Vector3D_F32 w0) {
        if (polygon.size < 3) {
            throw new IllegalArgumentException("There must be 3 or more points");
        }
        Point3D_F32 v0 = polygon.get(0);
        Point3D_F32 v1 = polygon.get(1);
        Point3D_F32 v2 = polygon.get(2);
        u.minus(v1, v0);
        v.minus(v2, v0);
        n.crossSetTo(u, v);
        if (n.normSq() == 0.0f) {
            return -1;
        }
        Vector3D_F32 dir = line.slope;
        w0.minus(line.p, v0);
        float a = -n.dot(w0);
        float b = n.dot(dir);
        if (Math.abs(b) < GrlConstants.F_EPS) {
            if (a == 0.0f) {
                return 2;
            }
            return 0;
        }
        float r = a / b;
        output.x = line.p.x + r * dir.x;
        output.y = line.p.y + r * dir.y;
        output.z = line.p.z + r * dir.z;
        for (int i = 2; i < polygon.size; ++i) {
            if (Intersection3D_F32.containedPlane(v0, output, u, v, w0)) {
                if (r >= 0.0f) {
                    return 1;
                }
                return 3;
            }
            if (i >= polygon.size - 1) continue;
            u.minus(polygon.get(i), v0);
            v.minus(polygon.get(i + 1), v0);
        }
        return 0;
    }

    public static int intersectConvex(FastAccess<Point3D_F32> polygon, LineParametric3D_F32 line, Point3D_F32 output) {
        return Intersection3D_F32.intersectConvex(polygon, line, output, new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32(), new Vector3D_F32());
    }

    private static boolean containedPlane(Point3D_F32 T_v0, Point3D_F32 output, Vector3D_F32 u, Vector3D_F32 v, Vector3D_F32 w0) {
        float uu = u.dot(u);
        float uv = u.dot(v);
        float vv = v.dot(v);
        w0.minus(output, T_v0);
        float wu = w0.dot(u);
        float wv = w0.dot(v);
        float D2 = uv * uv - uu * vv;
        float s = (uv * wv - vv * wu) / D2;
        if (s < 0.0f || s > 1.0f) {
            return false;
        }
        float t = (uv * wu - uu * wv) / D2;
        return !(t < 0.0f) && !(s + t > 1.0f);
    }

    public static boolean contained(BoxLength3D_F32 box, Point3D_F32 point) {
        return box.p.x <= point.x && point.x < box.p.x + box.lengthX && box.p.y <= point.y && point.y < box.p.y + box.lengthY && box.p.z <= point.z && point.z < box.p.z + box.lengthZ;
    }

    public static boolean contained(Box3D_F32 box, Point3D_F32 point) {
        return box.p0.x <= point.x && point.x < box.p1.x && box.p0.y <= point.y && point.y < box.p1.y && box.p0.z <= point.z && point.z < box.p1.z;
    }

    public static boolean contained2(Box3D_F32 box, Point3D_F32 point) {
        return box.p0.x <= point.x && point.x <= box.p1.x && box.p0.y <= point.y && point.y <= box.p1.y && box.p0.z <= point.z && point.z <= box.p1.z;
    }

    public static boolean contained(Box3D_F32 boxA, Box3D_F32 boxB) {
        return boxA.p0.x <= boxB.p0.x && boxA.p1.x >= boxB.p1.x && boxA.p0.y <= boxB.p0.y && boxA.p1.y >= boxB.p1.y && boxA.p0.z <= boxB.p0.z && boxA.p1.z >= boxB.p1.z;
    }

    public static float intersectionArea(Box3D_F32 a, Box3D_F32 b) {
        if (!Intersection3D_F32.intersection(a, b)) {
            return 0.0f;
        }
        float x0 = Math.max(a.p0.x, b.p0.x);
        float x1 = Math.min(a.p1.x, b.p1.x);
        float y0 = Math.max(a.p0.y, b.p0.y);
        float y1 = Math.min(a.p1.y, b.p1.y);
        float z0 = Math.max(a.p0.z, b.p0.z);
        float z1 = Math.min(a.p1.z, b.p1.z);
        return (x1 - x0) * (y1 - y0) * (z1 - z0);
    }

    public static boolean intersection(Box3D_F32 boxA, Box3D_F32 boxB) {
        return Intersection3D_F32.intersection(boxA.p0.x, boxB.p0.x, boxA.p1.x, boxB.p1.x) && Intersection3D_F32.intersection(boxA.p0.y, boxB.p0.y, boxA.p1.y, boxB.p1.y) && Intersection3D_F32.intersection(boxA.p0.z, boxB.p0.z, boxA.p1.z, boxB.p1.z);
    }

    protected static boolean intersection(float a0, float b0, float a1, float b1) {
        if (a0 <= b0) {
            return b0 < a1;
        }
        return a0 < b1;
    }

    public static boolean intersection(LineParametric3D_F32 line, Sphere3D_F32 sphere, Point3D_F32 a, Point3D_F32 b) {
        float XX;
        float C;
        float A;
        float r2 = sphere.radius * sphere.radius;
        float PP = GeometryMath_F32.dot(line.p, line.p);
        float PV = GeometryMath_F32.dot(line.p, line.slope);
        float PX = GeometryMath_F32.dot(line.p, sphere.center);
        float VV = GeometryMath_F32.dot(line.slope, line.slope);
        float VX = GeometryMath_F32.dot(line.slope, sphere.center);
        float B = 2.0f * (PV - VX);
        float inner = B * B - 4.0f * (A = VV) * (C = PP + (XX = GeometryMath_F32.dot(sphere.center, sphere.center)) - 2.0f * PX - r2);
        if (inner < 0.0f) {
            return false;
        }
        float sqrt = (float)Math.sqrt(inner);
        float t0 = (-B + sqrt) / (2.0f * A);
        float t1 = (-B - sqrt) / (2.0f * A);
        line.setPointOnLine(t0, a);
        line.setPointOnLine(t1, b);
        return true;
    }
}

