/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import georegression.struct.curve.PolynomialCurve_F64;
import org.ejml.FancyPrint;

public class PolynomialQuadratic1D_F64
implements PolynomialCurve_F64 {
    public double a;
    public double b;
    public double c;

    public PolynomialQuadratic1D_F64() {
    }

    public PolynomialQuadratic1D_F64(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double evaluate(double t) {
        return this.a + this.b * t + this.c * t * t;
    }

    public void setTo(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public void setTo(PolynomialQuadratic1D_F64 src) {
        this.a = src.a;
        this.b = src.b;
        this.c = src.c;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "PolynomialQuadratic1D_F64{a=" + fp.p(this.a) + ", b=" + fp.p(this.b) + ", c=" + fp.p(this.c) + '}';
    }

    @Override
    public double get(int coefficient) {
        switch (coefficient) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public void set(int coefficient, double value) {
        switch (coefficient) {
            case 0: {
                this.a = value;
                return;
            }
            case 1: {
                this.b = value;
                return;
            }
            case 2: {
                this.c = value;
                return;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public int degree() {
        return 2;
    }
}

