/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.geometry.UtilLine2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;
import java.io.Serializable;
import org.ejml.FancyPrint;

public class LineParametric2D_F64
implements Serializable {
    public Point2D_F64 p = new Point2D_F64();
    public Vector2D_F64 slope = new Vector2D_F64();

    public LineParametric2D_F64(double x_0, double y_0, double slopeX, double slopeY) {
        this.p.setTo(x_0, y_0);
        this.slope.setTo(slopeX, slopeY);
    }

    public LineParametric2D_F64(Point2D_F64 p, Vector2D_F64 slope) {
        this.setPoint(p);
        this.setSlope(slope);
    }

    public LineParametric2D_F64(Point2D_F64 a, Point2D_F64 b) {
        UtilLine2D_F64.convert(a, b, this);
    }

    public LineParametric2D_F64() {
    }

    public void setTo(LineParametric2D_F64 line) {
        this.p.setTo(line.p);
        this.slope.set(line.slope);
    }

    public void setPoint(Point2D_F64 pt) {
        this.p.setTo(pt);
    }

    public void setPoint(double x, double y) {
        this.p.x = x;
        this.p.y = y;
    }

    public void setSlope(Vector2D_F64 slope) {
        this.slope.set(slope);
    }

    public void setSlope(double slopeX, double slopeY) {
        this.slope.x = slopeX;
        this.slope.y = slopeY;
    }

    public void setAngle(double angle) {
        this.slope.setTo(Math.cos(angle), Math.sin(angle));
    }

    public double getAngle() {
        return Math.atan2(this.slope.y, this.slope.x);
    }

    public Point2D_F64 getPointOnLine(double t) {
        return new Point2D_F64(this.slope.x * t + this.p.x, this.slope.y * t + this.p.y);
    }

    public void getPointOnLine(double t, Point2D_F64 x) {
        x.x = this.slope.x * t + this.p.x;
        x.y = this.slope.y * t + this.p.y;
    }

    public Point2D_F64 getPoint() {
        return this.p;
    }

    public final double getSlopeX() {
        return this.slope.x;
    }

    public final double getSlopeY() {
        return this.slope.y;
    }

    public final double getX() {
        return this.p.x;
    }

    public final double getY() {
        return this.p.y;
    }

    public Point2D_F64 getP() {
        return this.p;
    }

    public void setP(Point2D_F64 p) {
        this.p = p;
    }

    public Vector2D_F64 getSlope() {
        return this.slope;
    }

    public LineParametric2D_F64 copy() {
        return new LineParametric2D_F64(this.p, this.slope);
    }

    public String toString() {
        FancyPrint f = new FancyPrint();
        return this.getClass().getSimpleName() + " P( " + f.s(this.p.x) + " " + f.s(this.p.y) + " ) Slope( " + f.s(this.slope.x) + " " + f.s(this.slope.y) + " )";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineParametric2D_F64)) {
            return false;
        }
        LineParametric2D_F64 o = (LineParametric2D_F64)obj;
        return this.p.equals(o.p) && this.slope.equals(o.slope);
    }

    public int hashCode() {
        return this.p.hashCode() + this.slope.hashCode();
    }
}

