/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.twist;

import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.misc.GrlConstants;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se3_F32;
import georegression.struct.so.Rodrigues_F32;
import georegression.transform.twist.TwistCoordinate_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.jetbrains.annotations.Nullable;

public class TwistOps_F32 {
    public static FMatrixRMaj homogenous(Se3_F32 transform, @Nullable FMatrixRMaj H) {
        if (H == null) {
            H = new FMatrixRMaj(4, 4);
        } else {
            H.reshape(4, 4);
        }
        CommonOps_FDRM.insert(transform.R, H, 0, 0);
        H.data[3] = transform.T.x;
        H.data[7] = transform.T.y;
        H.data[11] = transform.T.z;
        H.data[12] = 0.0f;
        H.data[13] = 0.0f;
        H.data[14] = 0.0f;
        H.data[15] = 1.0f;
        return H;
    }

    public static FMatrixRMaj homogenous(TwistCoordinate_F32 twist, @Nullable FMatrixRMaj H) {
        if (H == null) {
            H = new FMatrixRMaj(4, 4);
        } else {
            H.reshape(4, 4);
            H.data[12] = 0.0f;
            H.data[13] = 0.0f;
            H.data[14] = 0.0f;
            H.data[15] = 0.0f;
        }
        H.data[0] = 0.0f;
        H.data[1] = -twist.w.z;
        H.data[2] = twist.w.y;
        H.data[3] = twist.v.x;
        H.data[4] = twist.w.z;
        H.data[5] = 0.0f;
        H.data[6] = -twist.w.x;
        H.data[7] = twist.v.y;
        H.data[8] = -twist.w.y;
        H.data[9] = twist.w.x;
        H.data[10] = 0.0f;
        H.data[11] = twist.v.z;
        return H;
    }

    public static Se3_F32 exponential(TwistCoordinate_F32 twist, float theta, @Nullable Se3_F32 motion) {
        float w_norm;
        if (motion == null) {
            motion = new Se3_F32();
        }
        if ((w_norm = twist.w.norm()) == 0.0f) {
            CommonOps_FDRM.setIdentity(motion.R);
            motion.T.x = twist.v.x * theta;
            motion.T.y = twist.v.y * theta;
            motion.T.z = twist.v.z * theta;
            return motion;
        }
        FMatrixRMaj R = motion.getR();
        float wx = twist.w.x / w_norm;
        float wy = twist.w.y / w_norm;
        float wz = twist.w.z / w_norm;
        ConvertRotation3D_F32.rodriguesToMatrix(wx, wy, wz, theta * w_norm, R);
        theta *= w_norm;
        float vx = twist.v.x;
        float vy = twist.v.y;
        float vz = twist.v.z;
        float wv_x = wy * vz - wz * vy;
        float wv_y = wz * vx - wx * vz;
        float wv_z = wx * vy - wy * vx;
        float left_x = (1.0f - R.data[0]) * wv_x - R.data[1] * wv_y - R.data[2] * wv_z;
        float left_y = -R.data[3] * wv_x + (1.0f - R.data[4]) * wv_y - R.data[5] * wv_z;
        float left_z = -R.data[6] * wv_x - R.data[7] * wv_y + (1.0f - R.data[8]) * wv_z;
        float right_x = (wx * wx * vx + wx * wy * vy + wx * wz * vz) * theta;
        float right_y = (wy * wx * vx + wy * wy * vy + wy * wz * vz) * theta;
        float right_z = (wz * wx * vx + wz * wy * vy + wz * wz * vz) * theta;
        motion.T.x = left_x + right_x;
        motion.T.y = left_y + right_y;
        motion.T.z = left_z + right_z;
        motion.T.divide(w_norm);
        return motion;
    }

    public static TwistCoordinate_F32 twist(Se3_F32 motion, @Nullable TwistCoordinate_F32 twist) {
        if (twist == null) {
            twist = new TwistCoordinate_F32();
        }
        if (MatrixFeatures_FDRM.isIdentity(motion.R, GrlConstants.TEST_F32)) {
            twist.w.setTo(0.0f, 0.0f, 0.0f);
            twist.v.setTo(motion.T);
        } else {
            Rodrigues_F32 rod = new Rodrigues_F32();
            ConvertRotation3D_F32.matrixToRodrigues(motion.R, rod);
            twist.w.setTo(rod.unitAxisRotation);
            float theta = rod.theta;
            FMatrixRMaj A = CommonOps_FDRM.identity(3);
            CommonOps_FDRM.subtract(A, motion.R, A);
            FMatrixRMaj w_hat = GeometryMath_F32.crossMatrix(twist.w, null);
            FMatrixRMaj tmp = A.copy();
            CommonOps_FDRM.mult(tmp, w_hat, A);
            Vector3D_F32 w = twist.w;
            A.data[0] = A.data[0] + w.x * w.x * theta;
            A.data[1] = A.data[1] + w.x * w.y * theta;
            A.data[2] = A.data[2] + w.x * w.z * theta;
            A.data[3] = A.data[3] + w.y * w.x * theta;
            A.data[4] = A.data[4] + w.y * w.y * theta;
            A.data[5] = A.data[5] + w.y * w.z * theta;
            A.data[6] = A.data[6] + w.z * w.x * theta;
            A.data[7] = A.data[7] + w.z * w.y * theta;
            A.data[8] = A.data[8] + w.z * w.z * theta;
            FMatrixRMaj y = new FMatrixRMaj(3, 1);
            y.data[0] = motion.T.x;
            y.data[1] = motion.T.y;
            y.data[2] = motion.T.z;
            FMatrixRMaj x = new FMatrixRMaj(3, 1);
            CommonOps_FDRM.solve(A, y, x);
            twist.w.scale(rod.theta);
            twist.v.x = x.data[0];
            twist.v.y = x.data[1];
            twist.v.z = x.data[2];
            twist.v.scale(rod.theta);
        }
        return twist;
    }
}

