/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.distance;

import java.util.ArrayDeque;
import java.util.Iterator;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.distance.PointIndex;
import org.ddogleg.fitting.modelset.distance.StatisticalFit;

public class FitByMeanStatistics<Model, Point>
implements StatisticalFit<Model, Point> {
    protected DistanceFromModel<Model, Point> modelError;
    protected ArrayDeque<PointIndex<Point>> allPoints = new ArrayDeque();
    private final double pruneThreshold;
    private double meanError;
    private double stdError;

    public FitByMeanStatistics(double pruneThreshold) {
        this.pruneThreshold = pruneThreshold;
    }

    @Override
    public void init(DistanceFromModel<Model, Point> modelError, ArrayDeque<PointIndex<Point>> allPoints) {
        this.modelError = modelError;
        this.allPoints = allPoints;
    }

    @Override
    public void computeStatistics() {
        this.computeMean();
        this.computeStandardDeviation();
    }

    @Override
    public void prune() {
        double thresh = this.stdError * this.pruneThreshold;
        Iterator<PointIndex<Point>> iter = this.allPoints.iterator();
        while (iter.hasNext()) {
            Object pt = iter.next().data;
            if (!(this.modelError.distance(pt) - this.meanError > thresh)) continue;
            iter.remove();
        }
    }

    @Override
    public double getErrorMetric() {
        return this.meanError;
    }

    private void computeMean() {
        this.meanError = 0.0;
        int size = this.allPoints.size();
        for (PointIndex<Point> inlier : this.allPoints) {
            Object pt = inlier.data;
            this.meanError += this.modelError.distance(pt);
        }
        this.meanError /= (double)size;
    }

    private void computeStandardDeviation() {
        this.stdError = 0.0;
        int size = this.allPoints.size();
        for (PointIndex<Point> inlier : this.allPoints) {
            Object pt = inlier.data;
            double e = this.modelError.distance(pt) - this.meanError;
            this.stdError += e * e;
        }
        this.stdError = Math.sqrt(this.stdError / (double)size);
    }
}

