/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.ransac;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.ddogleg.DDoglegConcurrency;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.struct.Factory;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class Ransac_MT<Model, Point>
extends Ransac<Model, Point> {
    final GrowArray<Ransac.TrialHelper> helpers;
    final Object lock = new Object();
    volatile int bestInlierSize;
    volatile int bestInlierTrial;
    @Nullable
    volatile Ransac.TrialHelper bestHelper;

    public Ransac_MT(long randSeed, int maxIterations, double thresholdFit, ModelManager<Model> modelManager, Class<Point> pointType) {
        super(randSeed, maxIterations, thresholdFit, modelManager, pointType);
        this.helpers = new GrowArray<Ransac.TrialHelper>(() -> new Ransac.TrialHelper(this), Ransac.TrialHelper::reset, Ransac.TrialHelper.class);
    }

    @Override
    public boolean process(List<Point> dataSet) {
        if (dataSet.size() < this.sampleSize) {
            return false;
        }
        Objects.requireNonNull(this.factoryDistance, "Must specify the model");
        this.checkTrialGenerators();
        this.bestInlierSize = -1;
        this.bestInlierTrial = -1;
        this.bestHelper = null;
        DDoglegConcurrency.loopFor(0, this.maxIterations, 1, this.helpers, (helper, trial) -> {
            Ransac_MT.randomDraw(helper.selectedIdx, dataSet.size(), this.sampleSize, (Random)this.trialRNG.get(trial));
            Ransac_MT.addSelect(helper.selectedIdx, this.sampleSize, dataSet, helper.initialSample);
            if (!helper.modelGenerator.generate(helper.initialSample, helper.candidateParam)) {
                return;
            }
            int threshold = Math.max(this.bestInlierSize - 1, helper.bestFitPoints.size());
            if (!helper.selectMatchSet(dataSet, threshold, this.thresholdFit, helper.candidateParam)) {
                return;
            }
            if (this.bestInlierSize > helper.candidatePoints.size()) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.bestInlierSize > helper.candidatePoints.size()) {
                    return;
                }
                if (this.bestInlierSize == helper.candidatePoints.size() && this.bestInlierTrial < trial) {
                    return;
                }
                this.bestInlierSize = helper.candidatePoints.size();
                this.bestInlierTrial = trial;
                this.bestHelper = helper;
            }
            helper.swapCandidateWithBest();
        });
        Ransac.TrialHelper result = this.helper = Objects.requireNonNull(this.bestHelper);
        return result.bestFitPoints.size() > 0;
    }

    @Override
    public void setModel(Factory<ModelGenerator<Model, Point>> factoryGenerator, Factory<DistanceFromModel<Model, Point>> factoryDistance) {
        this.factoryGenerator = factoryGenerator;
        this.factoryDistance = factoryDistance;
        this.helpers.releaseInternalArray();
        this.helpers.resize(1);
        this.sampleSize = this.helpers.get((int)0).modelGenerator.getMinimumPoints();
    }
}

