/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.KdTree;

public class KdTreeMemory<P> {
    protected List<KdTree.Node> unusedNodes = new ArrayList<KdTree.Node>();
    protected List<KdTree> unusedTrees = new ArrayList<KdTree>();
    protected List<KdTree.Node> open = new ArrayList<KdTree.Node>();

    public KdTree.Node requestNode() {
        if (this.unusedNodes.isEmpty()) {
            return new KdTree.Node();
        }
        return this.unusedNodes.remove(this.unusedNodes.size() - 1);
    }

    public KdTree.Node requestNode(P point, int index) {
        KdTree.Node n = this.requestNode();
        n.point = point;
        n.index = index;
        n.split = -1;
        return n;
    }

    public KdTree requestTree(int N) {
        if (this.unusedTrees.isEmpty()) {
            return new KdTree(N);
        }
        KdTree tree = this.unusedTrees.remove(this.unusedTrees.size() - 1);
        tree.N = N;
        return tree;
    }

    public void recycle(KdTree.Node node) {
        node.point = null;
        node.left = null;
        node.right = null;
        this.unusedNodes.add(node);
    }

    public void recycleGraph(KdTree tree) {
        if (tree.root != null) {
            this.open.add(tree.root);
            while (!this.open.isEmpty()) {
                KdTree.Node n = this.open.remove(this.open.size() - 1);
                if (n.left != null) {
                    this.open.add(n.left);
                }
                if (n.right != null) {
                    this.open.add(n.right);
                }
                this.recycle(n);
            }
            tree.root = null;
        }
        this.unusedTrees.add(tree);
    }
}

