/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg.searches;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeDistance;

public abstract class KdTreeSearchBestBinFirst<P> {
    protected int maxNodesSearched;
    protected int N;
    private double maxDistance = Double.MAX_VALUE;
    private final PriorityQueue<Helper> queue = new PriorityQueue();
    private KdTree[] trees;
    protected double bestDistanceSq;
    private final List<Helper> unused = new ArrayList<Helper>();
    protected int numNodesSearched = 0;
    KdTreeDistance<P> distance;

    protected KdTreeSearchBestBinFirst(KdTreeDistance<P> distance, int maxNodesSearched) {
        this.distance = distance;
        this.maxNodesSearched = maxNodesSearched;
    }

    public void setTree(KdTree tree) {
        if (this.trees == null || this.trees.length != 1) {
            this.trees = new KdTree[]{tree};
        } else {
            this.trees[0] = tree;
        }
        this.N = tree.N;
    }

    public void setTrees(KdTree[] trees) {
        if (this.trees == null || this.trees.length != trees.length) {
            this.trees = (KdTree[])trees.clone();
        } else {
            System.arraycopy(trees, 0, this.trees, 0, trees.length);
        }
        this.N = trees[0].N;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public void _findClosest(P target) {
        this.numNodesSearched = 0;
        this.bestDistanceSq = this.maxDistance;
        for (int i = 0; i < this.trees.length; ++i) {
            KdTree.Node root = this.trees[i].root;
            if (root == null) continue;
            this.searchNode(target, root);
        }
        while (!this.queue.isEmpty() && this.numNodesSearched++ < this.maxNodesSearched) {
            Helper h = (Helper)this.queue.remove();
            KdTree.Node n = h.node;
            this.recycle(h);
            if (!this.canImprove(h.closestPossibleSq)) continue;
            this.searchNode(target, n);
        }
        this.unused.addAll(this.queue);
        this.queue.clear();
    }

    protected void searchNode(P target, KdTree.Node n) {
        while (n != null) {
            KdTree.Node further;
            KdTree.Node nearer;
            this.checkBestDistance(n, target);
            if (n.isLeaf()) break;
            double splitValue = this.distance.valueAt(n.point, n.split);
            if (this.distance.valueAt(target, n.split) <= splitValue) {
                nearer = n.left;
                further = n.right;
            } else {
                nearer = n.right;
                further = n.left;
            }
            double dx = splitValue - this.distance.valueAt(target, n.split);
            if (further != null && this.canImprove(dx * dx)) {
                this.addToQueue(dx * dx, further, target);
            }
            n = nearer;
        }
    }

    protected void addToQueue(double closestDistanceSq, KdTree.Node node, P target) {
        if (!node.isLeaf()) {
            Helper h = this.unused.isEmpty() ? new Helper() : this.unused.remove(this.unused.size() - 1);
            h.closestPossibleSq = closestDistanceSq;
            h.node = node;
            this.queue.add(h);
        } else {
            this.checkBestDistance(node, target);
        }
    }

    protected abstract void checkBestDistance(KdTree.Node var1, P var2);

    protected abstract boolean canImprove(double var1);

    private void recycle(Helper h) {
        this.unused.add(h);
    }

    protected static class Helper
    implements Comparable<Helper> {
        double closestPossibleSq;
        KdTree.Node node;

        protected Helper() {
        }

        @Override
        public int compareTo(Helper o) {
            return Double.compare(this.closestPossibleSq, o.closestPossibleSq);
        }
    }
}

