/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.DDoglegConcurrency;
import org.ddogleg.optimization.math.HessianSchurComplement_Base;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.CommonOps_MT_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import org.ejml.sparse.csc.mult.MatrixVectorMult_DSCC;
import org.ejml.sparse.csc.mult.Workspace_MT_DSCC;
import pabeles.concurrency.GrowArray;

public class HessianSchurComplement_DSCC
extends HessianSchurComplement_Base<DMatrixSparseCSC> {
    DMatrixSparseCSC transposed = new DMatrixSparseCSC(1, 1);
    IGrowArray gw = new IGrowArray();
    DGrowArray gx = new DGrowArray();
    GrowArray<Workspace_MT_DSCC> concurrentWork = new GrowArray<Workspace_MT_DSCC>(Workspace_MT_DSCC::new);
    GrowArray<DGrowArray> concurrentArrays = new GrowArray<DGrowArray>(DGrowArray::new);

    public HessianSchurComplement_DSCC() {
        this(LinearSolverFactory_DSCC.cholesky(FillReducing.NONE), LinearSolverFactory_DSCC.cholesky(FillReducing.NONE));
    }

    public HessianSchurComplement_DSCC(LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solverA, LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solverD) {
        super(solverA, solverD);
    }

    @Override
    public void computeHessian(DMatrixSparseCSC jacLeft, DMatrixSparseCSC jacRight) {
        ((DMatrixSparseCSC)this.A).reshape(jacLeft.numCols, jacLeft.numCols, 1);
        ((DMatrixSparseCSC)this.B).reshape(jacLeft.numCols, jacRight.numCols, 1);
        ((DMatrixSparseCSC)this.D).reshape(jacRight.numCols, jacRight.numCols, 1);
        if (DDoglegConcurrency.isUseConcurrent()) {
            CommonOps_DSCC.transpose(jacLeft, this.transposed, this.gw);
            CommonOps_MT_DSCC.mult(this.transposed, jacLeft, (DMatrixSparseCSC)this.A, this.concurrentWork);
            CommonOps_MT_DSCC.mult(this.transposed, jacRight, (DMatrixSparseCSC)this.B, this.concurrentWork);
            CommonOps_DSCC.transpose(jacRight, this.transposed, this.gw);
            CommonOps_MT_DSCC.mult(this.transposed, jacRight, (DMatrixSparseCSC)this.D, this.concurrentWork);
        } else {
            CommonOps_DSCC.transpose(jacLeft, this.transposed, this.gw);
            CommonOps_DSCC.mult(this.transposed, jacLeft, (DMatrixSparseCSC)this.A, this.gw, this.gx);
            CommonOps_DSCC.mult(this.transposed, jacRight, (DMatrixSparseCSC)this.B, this.gw, this.gx);
            CommonOps_DSCC.transpose(jacRight, this.transposed, this.gw);
            CommonOps_DSCC.mult(this.transposed, jacRight, (DMatrixSparseCSC)this.D, this.gw, this.gx);
        }
    }

    @Override
    public DMatrixSparseCSC createMatrix() {
        return new DMatrixSparseCSC(1, 1);
    }

    @Override
    protected double innerProduct(double[] a, int offsetA, DMatrixSparseCSC B, double[] c, int offsetC) {
        return MatrixVectorMult_DSCC.innerProduct(a, offsetA, B, c, offsetC);
    }

    @Override
    protected void extractDiag(DMatrixSparseCSC input, DMatrixRMaj output) {
        CommonOps_DSCC.extractDiag(input, output);
    }

    @Override
    protected void divideRowsCols(double[] diagA, int offsetA, DMatrixSparseCSC B, double[] diagC, int offsetC) {
        CommonOps_DSCC.divideRowsCols(diagA, offsetA, B, diagC, offsetC);
    }

    @Override
    protected void multTransA(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C) {
        CommonOps_DSCC.transpose(A, this.transposed, this.gw);
        if (DDoglegConcurrency.isUseConcurrent()) {
            CommonOps_MT_DSCC.mult(this.transposed, B, C, this.concurrentWork);
        } else {
            CommonOps_DSCC.mult(this.transposed, B, C, this.gw, this.gx);
        }
    }

    @Override
    protected void multTransA(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        if (DDoglegConcurrency.isUseConcurrent()) {
            CommonOps_MT_DSCC.multTransA(A, B, C, this.concurrentArrays);
        } else {
            CommonOps_DSCC.multTransA(A, B, C, this.gx);
        }
    }

    @Override
    protected void add(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC B, DMatrixSparseCSC C) {
        if (DDoglegConcurrency.isUseConcurrent()) {
            CommonOps_MT_DSCC.add(alpha, A, beta, B, C, this.concurrentWork);
        } else {
            CommonOps_DSCC.add(alpha, A, beta, B, C, this.gw, this.gx);
        }
    }

    @Override
    protected void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        if (DDoglegConcurrency.isUseConcurrent()) {
            CommonOps_MT_DSCC.mult(A, B, C, this.concurrentArrays);
        } else {
            CommonOps_DSCC.mult(A, B, C);
        }
    }
}

