/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.quasinewton;

import java.io.PrintStream;
import org.ddogleg.optimization.LineSearch;
import org.ddogleg.optimization.functions.CoupledDerivative;
import org.ddogleg.optimization.quasinewton.SearchInterpolate;
import org.ejml.UtilEjml;
import org.jetbrains.annotations.Nullable;

public class LineSearchFletcher86
implements LineSearch {
    protected double tolStep = UtilEjml.EPS;
    protected CoupledDerivative function;
    protected double valueZero;
    protected double derivZero;
    protected double stp;
    protected double fp;
    protected double gp;
    double t1;
    double t2;
    double t3;
    double fzero;
    double gzero;
    double stmax;
    double fmin;
    private double ftol;
    private double gtol;
    protected double stprev;
    protected double fprev;
    protected double gprev;
    int mode;
    private double stpmax;
    double pLow;
    double pHi;
    double fLow;
    boolean updated;
    @Nullable
    PrintStream verbose;
    boolean converged;

    public LineSearchFletcher86(double t1, double t2, double t3) {
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t3;
    }

    public LineSearchFletcher86() {
        this(9.0, 0.1, 0.5);
    }

    @Override
    public void setConvergence(double ftol, double gtol) {
        if (ftol < 0.0) {
            throw new IllegalArgumentException("c1 must be more than zero");
        }
        if (ftol > gtol) {
            throw new IllegalArgumentException("c1 must be less or equal to than c2");
        }
        if (gtol >= 1.0) {
            throw new IllegalArgumentException("c2 must be less than one");
        }
        this.ftol = ftol;
        this.gtol = gtol;
    }

    @Override
    public void setFunction(CoupledDerivative function, double fmin) {
        this.function = function;
        this.fmin = fmin;
    }

    @Override
    public void init(double funcAtZero, double derivAtZero, double funcAtInit, double initAlpha, double stepMin, double stepMax) {
        if (stepMax <= 0.0) {
            throw new IllegalArgumentException("stepMax must be greater than zero");
        }
        this.initializeSearch(funcAtZero, derivAtZero, funcAtInit, initAlpha);
        this.fzero = funcAtZero;
        this.gzero = derivAtZero;
        this.stprev = 0.0;
        this.fprev = funcAtZero;
        this.gprev = derivAtZero;
        this.mode = 0;
        this.converged = false;
        this.stmax = (this.fmin - this.fzero) / (this.ftol * this.gzero);
        this.stpmax = stepMax;
        this.updated = false;
    }

    protected void initializeSearch(double valueZero, double derivZero, double initValue, double initAlpha) {
        if (derivZero >= 0.0) {
            throw new IllegalArgumentException("Derivative at zero must be decreasing");
        }
        if (initAlpha <= 0.0) {
            throw new IllegalArgumentException("initAlpha must be more than zero");
        }
        this.valueZero = valueZero;
        this.derivZero = derivZero;
        this.stp = initAlpha;
        this.fp = initValue;
        this.gp = Double.NaN;
    }

    @Override
    public boolean iterate() {
        this.updated = false;
        boolean ret = this.mode <= 1 ? (this.converged = this.bracket()) : (this.converged = this.section());
        return ret;
    }

    protected boolean bracket() {
        this.function.setInput(this.stp);
        if (this.mode != 0) {
            this.fp = this.function.computeFunction();
            this.gp = Double.NaN;
        } else {
            this.mode = 1;
        }
        if (this.fp > this.valueZero + this.ftol * this.stp * this.derivZero) {
            this.setModeToSection(this.stprev, this.fprev, this.stp);
            return false;
        }
        if (this.fp >= this.fprev) {
            this.setModeToSection(this.stprev, this.fprev, this.stp);
            return false;
        }
        this.gp = this.function.computeDerivative();
        if (Math.abs(this.gp) <= -this.gtol * this.derivZero) {
            return true;
        }
        if (this.gp >= 0.0) {
            this.setModeToSection(this.stp, this.fp, this.stprev);
            return false;
        }
        if (this.stmax <= 2.0 * this.stp - this.stprev) {
            this.stprev = this.stp;
            this.gprev = this.gp;
            this.fprev = this.fp;
            this.stp = this.stmax;
            this.updated = true;
        } else {
            double temp = this.stp;
            this.stp = this.interpolate(2.0 * this.stp - this.stprev, Math.min(this.stpmax, this.stp + this.t1 * (this.stp - this.stprev)));
            this.stprev = temp;
            this.gprev = this.gp;
            this.fprev = this.fp;
            this.updated = true;
        }
        if (this.checkSmallStep()) {
            if (this.verbose != null) {
                this.verbose.println("WARNING: Small steps");
            }
            return true;
        }
        return false;
    }

    private void setModeToSection(double alphaLow, double valueLow, double alphaHigh) {
        this.pLow = alphaLow;
        this.fLow = valueLow;
        this.pHi = alphaHigh;
        this.mode = 2;
    }

    protected boolean section() {
        double temp = this.stp;
        this.stp = this.interpolate(this.pLow + this.t2 * (this.pHi - this.pLow), this.pHi - this.t3 * (this.pHi - this.pLow));
        this.updated = true;
        if (!Double.isNaN(this.gp)) {
            this.stprev = temp;
            this.fprev = this.fp;
            this.gprev = this.gp;
        }
        if (this.checkSmallStep()) {
            if (this.verbose != null) {
                this.verbose.println("WARNING: Small steps");
            }
            return true;
        }
        this.function.setInput(this.stp);
        this.fp = this.function.computeFunction();
        this.gp = Double.NaN;
        if (this.fp > this.valueZero + this.ftol * this.stp * this.derivZero || this.fp >= this.fLow) {
            this.pHi = this.stp;
        } else {
            this.gp = this.function.computeDerivative();
            if (Math.abs(this.gp) <= -this.gtol * this.derivZero) {
                return true;
            }
            if (this.gp * (this.pHi - this.pLow) >= 0.0) {
                this.pHi = this.pLow;
            }
            if (Math.abs((this.pLow - this.stp) * this.gp) <= this.tolStep) {
                return true;
            }
            this.pLow = this.stp;
            this.fLow = this.fp;
        }
        return false;
    }

    @Override
    public double getStep() {
        return this.stp;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, int level) {
        this.verbose = out;
    }

    protected boolean checkSmallStep() {
        double max = Math.max(this.stp, this.stprev);
        return Math.abs(this.stp - this.stprev) / max < this.tolStep;
    }

    protected double interpolate(double boundA, double boundB) {
        double u;
        double l;
        double alphaNew;
        if (Double.isNaN(this.gp)) {
            alphaNew = SearchInterpolate.quadratic(this.fprev, this.gprev, this.stprev, this.fp, this.stp);
        } else {
            alphaNew = SearchInterpolate.cubic2(this.fprev, this.gprev, this.stprev, this.fp, this.gp, this.stp);
            if (Double.isNaN(alphaNew)) {
                alphaNew = SearchInterpolate.quadratic(this.fprev, this.gprev, this.stprev, this.fp, this.stp);
            }
        }
        if (boundA < boundB) {
            l = boundA;
            u = boundB;
        } else {
            l = boundB;
            u = boundA;
        }
        if (alphaNew < l) {
            alphaNew = l;
        } else if (alphaNew > u) {
            alphaNew = u;
        }
        return alphaNew;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    @Override
    public double getFunction() {
        return this.fp;
    }

    @Override
    public double getGTol() {
        return this.gtol;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }
}

