/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;

public class CountingSort {
    DogArray_I32 histogram = new DogArray_I32();
    DogArray<DogArray_I32> histIndexes = new DogArray<DogArray_I32>(DogArray_I32::new);
    int minValue;
    int maxValue;

    public CountingSort() {
    }

    public CountingSort(int minValue, int maxValue) {
        this.setRange(minValue, maxValue);
    }

    public void setRange(int minValue, int maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.histogram.resize(maxValue - minValue + 1);
        this.histIndexes.resize(maxValue - minValue + 1);
    }

    public void sort(int[] data, int begin, int end) {
        this.histogram.fill(0);
        for (int i = begin; i < end; ++i) {
            int n = data[i] - this.minValue;
            this.histogram.data[n] = this.histogram.data[n] + 1;
        }
        int index = begin;
        for (int i = 0; i < this.histogram.size; ++i) {
            int N = this.histogram.get(i);
            int value = i + this.minValue;
            for (int j = 0; j < N; ++j) {
                data[index++] = value;
            }
        }
    }

    public void sort(int[] input, int startIndex, int[] output, int startOutput, int length) {
        this.histogram.fill(0);
        for (int i = 0; i < length; ++i) {
            int n = input[i + startIndex] - this.minValue;
            this.histogram.data[n] = this.histogram.data[n] + 1;
        }
        int index = startOutput;
        for (int i = 0; i < this.histogram.size; ++i) {
            int N = this.histogram.get(i);
            int value = i + this.minValue;
            for (int j = 0; j < N; ++j) {
                output[index++] = value;
            }
        }
    }

    public void sortIndex(int[] input, int start, int length, int[] indexes) {
        int i;
        for (i = 0; i < length; ++i) {
            indexes[i] = i;
        }
        for (i = 0; i < this.histogram.size; ++i) {
            ((DogArray_I32)this.histIndexes.get(i)).reset();
        }
        for (i = 0; i < length; ++i) {
            int indexInput = i + start;
            ((DogArray_I32[])this.histIndexes.data)[input[indexInput] - this.minValue].add(indexInput);
        }
        int index = 0;
        for (int i2 = 0; i2 < this.histIndexes.size; ++i2) {
            DogArray_I32 matches = (DogArray_I32)this.histIndexes.get(i2);
            for (int j = 0; j < matches.size; ++j) {
                indexes[index++] = matches.data[j];
            }
        }
    }
}

