/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.BigDogArrayBase;
import org.ddogleg.struct.BigDogGrowth;
import org.ddogleg.struct.DogArray_B;

public class BigDogArray_B
extends BigDogArrayBase<boolean[]> {
    public BigDogArray_B() {
        this(8, 32768, BigDogGrowth.GROW_FIRST);
    }

    public BigDogArray_B(int initialAllocation) {
        this(initialAllocation, 32768, BigDogGrowth.GROW_FIRST);
    }

    public BigDogArray_B(int initialAllocation, int blockSize, BigDogGrowth growth) {
        super(initialAllocation, blockSize, growth);
    }

    @Override
    protected boolean[] newArrayInstance(int size) {
        return new boolean[size];
    }

    @Override
    protected int arrayLength(boolean[] array) {
        return array.length;
    }

    public void append(boolean value) {
        this.allocate(this.size + 1, true, true);
        ((boolean[][])this.blocks.data)[this.size / this.blockSize][this.size % this.blockSize] = value;
        ++this.size;
    }

    public void add(boolean value) {
        this.append(value);
    }

    public void resize(int desiredSize, boolean initialValue) {
        this.allocate(desiredSize, true, false);
        int originalSize = this.size;
        this.size = desiredSize;
        this.fill(originalSize, desiredSize, initialValue);
    }

    public void fill(int idx0, int idx1, boolean value) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> Arrays.fill(block, block0, block1, value));
    }

    public void set(int index, boolean value) {
        ((boolean[][])this.blocks.data)[index / this.blockSize][index % this.blockSize] = value;
    }

    public void setTail(int index, boolean value) {
        this.set(this.size - index - 1, value);
    }

    public void getArray(int index, boolean[] array, int offset, int length) {
        this.processByBlock(index, index + length, (block, block0, block1, arrayLoc) -> System.arraycopy(block, block0, array, offset + arrayLoc, block1 - block0));
    }

    public boolean get(int index) {
        return ((boolean[][])this.blocks.data)[index / this.blockSize][index % this.blockSize];
    }

    public boolean getTail(int index) {
        return this.get(this.size - index - 1);
    }

    public void forEach(int idx0, int idx1, DogArray_B.FunctionEach op) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> {
            for (int i = block0; i < block1; ++i) {
                op.process(block[i]);
            }
        });
    }

    public void forIdx(int idx0, int idx1, DogArray_B.FunctionEachIdx op) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> {
            int index = idx0 + offset;
            for (int i = block0; i < block1; ++i) {
                op.process(index++, block[i]);
            }
        });
    }

    public void applyIdx(int idx0, int idx1, DogArray_B.FunctionApplyIdx op) {
        this.processByBlock(idx0, idx1, (block, block0, block1, offset) -> {
            int index = idx0 + offset;
            for (int i = block0; i < block1; ++i) {
                block[i] = op.process(index++, block[i]);
            }
        });
    }
}

