/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.DProcess;
import org.ddogleg.struct.DProcessIdx;
import org.ddogleg.struct.DogArrayList;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.FastAccess;
import org.jetbrains.annotations.Nullable;

public class DogArray<T>
extends FastAccess<T> {
    private Factory<T> factory;
    private DProcess<T> reset;
    private DProcess<T> initialize = new DProcess.DoNothing();
    private final DogArrayList<T> list = new DogArrayList(this);

    public DogArray(Class<T> type, Factory<T> factory) {
        super(type);
        this.init(10, factory);
    }

    public DogArray(Factory<T> factory) {
        super(factory.newInstance().getClass());
        this.init(10, factory);
    }

    public DogArray(Factory<T> factory, DProcess<T> reset) {
        super(factory.newInstance().getClass());
        this.reset = reset;
        this.init(10, factory);
    }

    public DogArray(Factory<T> factory, DProcess<T> reset, DProcess<T> initialize) {
        super(factory.newInstance().getClass());
        this.reset = reset;
        this.initialize = initialize;
        this.init(10, factory);
    }

    public DogArray(int initialMaxSize, Factory<T> factory) {
        super(factory.newInstance().getClass());
        this.init(initialMaxSize, factory);
    }

    protected void init(int initialMaxSize, Factory<T> factory) {
        this.size = 0;
        this.factory = factory;
        if (this.reset == null) {
            this.reset = new DProcess.DoNothing();
        }
        this.data = (Object[])Array.newInstance(this.type, initialMaxSize);
        if (factory != null) {
            for (int i = 0; i < initialMaxSize; ++i) {
                try {
                    this.data[i] = this.createInstance();
                    continue;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("declareInstances is true, but createInstance() can't create a new instance.  Maybe override createInstance()?");
                }
            }
        }
    }

    @Override
    public List<T> toList() {
        return this.list;
    }

    public void remove(int[] indexes, int fromIndex, int toIndex, @Nullable List<T> workSpace) {
        int i;
        if (toIndex <= fromIndex) {
            return;
        }
        if (workSpace == null) {
            workSpace = new ArrayList<T>();
        } else {
            workSpace.clear();
        }
        Arrays.sort(indexes, fromIndex, toIndex);
        int target = indexes[fromIndex];
        int count = 0;
        for (i = indexes[fromIndex]; i < this.size; ++i) {
            if (i == target) {
                workSpace.add(this.data[i]);
                if (++count < toIndex - fromIndex) {
                    target = indexes[fromIndex + count];
                    continue;
                }
                target = -1;
                continue;
            }
            this.data[i - count] = this.data[i];
        }
        for (i = 0; i < workSpace.size(); ++i) {
            this.data[this.size - i - 1] = workSpace.get(i);
        }
        this.size -= workSpace.size();
    }

    public T removeTail() {
        if (this.size > 0) {
            --this.size;
            return (T)this.data[this.size];
        }
        throw new IllegalArgumentException("Size is already zero");
    }

    public void reset() {
        this.size = 0;
    }

    public T grow() {
        if (this.size < this.data.length) {
            Object ret = this.data[this.size++];
            this.reset.process(ret);
            return (T)ret;
        }
        this.reserve((this.data.length + 1) * 2);
        return (T)this.data[this.size++];
    }

    public <S> void copyAll(List<S> list, Set<S, T> setter) {
        this.reserve(this.size() + list.size());
        for (int i = 0; i < list.size(); ++i) {
            T dst = this.grow();
            setter.set(list.get(i), dst);
        }
    }

    @Override
    public T remove(int index) {
        Object removed = this.data[index];
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        this.data[this.size - 1] = removed;
        --this.size;
        return (T)removed;
    }

    public boolean remove(T target) {
        int index = this.indexOf(target);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public T removeSwap(int index) {
        Object removed = this.data[index];
        this.data[index] = this.data[this.size - 1];
        this.data[this.size - 1] = removed;
        --this.size;
        return (T)removed;
    }

    public void reserve(int length) {
        if (this.data.length >= length) {
            return;
        }
        Object[] data = (Object[])Array.newInstance(this.type, length);
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        if (this.factory != null) {
            for (int i = this.data.length; i < length; ++i) {
                data[i] = this.createInstance();
            }
        }
        this.data = data;
    }

    public void resize(int length, DProcess<T> configure) {
        this.reserve(length);
        for (int i = this.size; i < length; ++i) {
            this.reset.process(this.data[i]);
            configure.process(this.data[i]);
        }
        this.size = length;
    }

    public void resize(int length, DProcessIdx<T> configure) {
        this.reserve(length);
        for (int i = this.size; i < length; ++i) {
            this.reset.process(this.data[i]);
            configure.process(i, this.data[i]);
        }
        this.size = length;
    }

    public void resize(int newSize) {
        this.reserve(newSize);
        for (int i = this.size; i < newSize; ++i) {
            this.reset.process(this.data[i]);
        }
        this.size = newSize;
    }

    public void resetResize(int newSize) {
        this.reset();
        this.resize(newSize);
    }

    public void shuffle(Random rand) {
        for (int i = 0; i < this.size; ++i) {
            int selected = rand.nextInt(this.size - i);
            Object tmp = this.data[selected];
            this.data[selected] = this.data[this.size - i - 1];
            this.data[this.size - i - 1] = tmp;
        }
    }

    protected T createInstance() {
        T instance = this.factory.newInstance();
        this.initialize.process(instance);
        this.reset.process(instance);
        return instance;
    }

    public List<T> copyIntoList(List<T> ret) {
        if (ret == null) {
            ret = new ArrayList<T>(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            ret.add(this.data[i]);
        }
        return ret;
    }

    public boolean isUnused(T object) {
        Object[] data = this.data;
        for (int i = this.size; i < data.length; ++i) {
            if (data[i] != object) continue;
            return true;
        }
        return false;
    }

    public T[] getData() {
        return this.data;
    }

    public void setData(T[] data) {
        this.data = data;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public final boolean isDeclare() {
        return this.factory != null;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Factory<T> getFactory() {
        return this.factory;
    }

    public DProcess<T> getReset() {
        return this.reset;
    }

    public void setReset(DProcess<T> reset) {
        this.reset = reset;
    }

    public DProcess<T> getInitialize() {
        return this.initialize;
    }

    public void setInitialize(DProcess<T> initialize) {
        this.initialize = initialize;
    }

    public static interface Set<S, D> {
        public void set(S var1, D var2);
    }
}

