/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.sorting.QuickSort_S32;
import org.ddogleg.struct.DogArrayPrimitive;
import org.ddogleg.struct.DogLambdas;

public class DogArray_I32
implements DogArrayPrimitive<DogArray_I32> {
    public int[] data;
    public int size;

    public DogArray_I32(int reserve) {
        this.data = new int[reserve];
        this.size = 0;
    }

    public DogArray_I32() {
        this(10);
    }

    public static DogArray_I32 zeros(int length) {
        DogArray_I32 out = new DogArray_I32(length);
        out.size = length;
        return out;
    }

    public static DogArray_I32 array(int ... values) {
        DogArray_I32 out = DogArray_I32.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    public static DogArray_I32 range(int idx0, int idx1) {
        DogArray_I32 out = DogArray_I32.zeros(idx1 - idx0);
        for (int i = idx0; i < idx1; ++i) {
            out.data[i - idx0] = i;
        }
        return out;
    }

    public int count(int value) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++total;
        }
        return total;
    }

    public boolean isEquals(int ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(DogArray_I32 queue) {
        if (this.size + queue.size > this.data.length) {
            int[] temp = new int[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(int[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array. " + endIndex + " > " + array.length);
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            int[] temp = new int[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(int val2) {
        this.push(val2);
    }

    public void push(int val2) {
        if (this.size == this.data.length) {
            int[] temp;
            try {
                temp = new int[this.size * 2 + 5];
            }
            catch (OutOfMemoryError e) {
                System.gc();
                temp = new int[3 * this.size / 2];
            }
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val2;
    }

    public void setTo(int[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public DogArray_I32 setTo(int ... src) {
        this.setTo(src, 0, src.length);
        return this;
    }

    public int[] toArray() {
        int[] out = new int[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last. first=" + first + " last=" + last);
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size. last=" + last + " size=" + this.size);
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, int value) {
        if (this.size == this.data.length) {
            int[] temp = new int[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public int removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        int ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        return ret;
    }

    public int removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public int getTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        return this.data[this.size - 1];
    }

    public int getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public void setTail(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        this.data[this.size - index - 1] = value;
    }

    public int getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public int unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = value;
    }

    @Override
    public void setTo(DogArray_I32 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    @Override
    public void resize(int size) {
        this.reserve(size);
        this.size = size;
    }

    public void resize(int size, int value) {
        int priorSize = this.size;
        this.resize(size);
        if (priorSize >= size) {
            return;
        }
        this.fill(priorSize, size, value);
    }

    public void resetResize(int size, int value) {
        this.reset();
        this.resize(size, value);
    }

    public void resize(int size, DogLambdas.AssignIdx_I32 op) {
        int priorSize = this.size;
        this.resize(size);
        for (int i = priorSize; i < size; ++i) {
            this.data[i] = op.assign(i);
        }
    }

    public void fill(int value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void fill(int idx0, int idx1, int value) {
        Arrays.fill(this.data, idx0, idx1, value);
    }

    public boolean contains(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extend(int size) {
        this.reserve(size);
        this.size = size;
    }

    @Override
    public void reserve(int amount) {
        if (this.data.length >= amount) {
            return;
        }
        if (this.size == 0) {
            this.data = null;
            this.data = new int[amount];
        } else {
            int[] tmp = new int[amount];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, 0);
    }

    @Override
    public DogArray_I32 copy() {
        DogArray_I32 ret = new DogArray_I32(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            int tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public int pop() {
        return this.data[--this.size];
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfGreatest() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        int best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.data[i] <= best) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    public int indexOfLeast() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        int best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.data[i] >= best) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void sort(QuickSort_S32 sorter) {
        sorter.sort(this.data, this.size);
    }

    public void forIdx(FunctionEachIdx func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(this.data[i]);
        }
    }

    public void applyIdx(FunctionApplyIdx func) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = func.process(i, this.data[i]);
        }
    }

    public int count(Filter filter) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!filter.include(this.data[i])) continue;
            ++total;
        }
        return total;
    }

    @FunctionalInterface
    public static interface FunctionEachIdx {
        public void process(int var1, int var2);
    }

    @FunctionalInterface
    public static interface FunctionEach {
        public void process(int var1);
    }

    @FunctionalInterface
    public static interface FunctionApplyIdx {
        public int process(int var1, int var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public boolean include(int var1);
    }
}

