///////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2012 maintech GmbH, Otto-Hahn-Str. 15, 97204 Hoechberg, Germany //
// written by Christian Daniel                                                   //
// Copyright (C) 2015-2019 Edouard Griffiths, F4EXB <f4exb06@gmail.com>          //
//                                                                               //
// This program is free software; you can redistribute it and/or modify          //
// it under the terms of the GNU General Public License as published by          //
// the Free Software Foundation as version 3 of the License, or                  //
// (at your option) any later version.                                           //
//                                                                               //
// This program is distributed in the hope that it will be useful,               //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                  //
// GNU General Public License V3 for more details.                               //
//                                                                               //
// You should have received a copy of the GNU General Public License             //
// along with this program. If not, see <http://www.gnu.org/licenses/>.          //
///////////////////////////////////////////////////////////////////////////////////

#ifndef DEVICES_HACKRF_DEVICEHACKRFSHARED_H_
#define DEVICES_HACKRF_DEVICEHACKRFSHARED_H_

#include <stdint.h>

#include "util/message.h"
#include "export.h"

class DEVICES_API DeviceHackRFShared
{
public:
    class DEVICES_API MsgSynchronizeSampleRate : public Message
    {
        MESSAGE_CLASS_DECLARATION

    public:
        uint64_t getDeviceSampleRate() const { return m_deviceSampleRate; }

        static MsgSynchronizeSampleRate *create(uint64_t deviceSampleRate)
        {
            return new MsgSynchronizeSampleRate(deviceSampleRate);
        }

    private:
        uint64_t m_deviceSampleRate;

        MsgSynchronizeSampleRate(uint64_t deviceSampleRate) :
            Message(),
            m_deviceSampleRate(deviceSampleRate)
        { }
    };

    static const unsigned int m_sampleFifoMinRate;
};


#endif /* DEVICES_HACKRF_DEVICEHACKRFSHARED_H_ */
