///////////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2019 Edouard Griffiths, F4EXB <f4exb06@gmail.com>                   //
//                                                                                   //
// This program is free software; you can redistribute it and/or modify              //
// it under the terms of the GNU General Public License as published by              //
// the Free Software Foundation as version 3 of the License, or                      //
// (at your option) any later version.                                               //
//                                                                                   //
// This program is distributed in the hope that it will be useful,                   //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                    //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                      //
// GNU General Public License V3 for more details.                                   //
//                                                                                   //
// You should have received a copy of the GNU General Public License                 //
// along with this program. If not, see <http://www.gnu.org/licenses/>.              //
///////////////////////////////////////////////////////////////////////////////////////

/*
    (defun ldpcformat ()
      (interactive)
      (save-restriction
        (narrow-to-region (region-beginning) (region-end))
	(goto-char (point-min))
	(while (re-search-forward "\\([^ 0-9]\\)\\([0-9]\\)\\([^0-9]\\)" nil t) (replace-match "\\1    \\2\\3"))
	(goto-char (point-min))
	(while (re-search-forward "\\([^ 0-9]\\)\\([0-9][0-9]\\)\\([^0-9]\\)" nil t) (replace-match "\\1   \\2\\3"))
	(goto-char (point-min))
	(while (re-search-forward "\\([^ 0-9]\\)\\([0-9][0-9][0-9]\\)\\([^0-9]\\)" nil t) (replace-match "\\1  \\2\\3"))
	(goto-char (point-min))
	(while (re-search-forward "\\([^ 0-9]\\)\\([0-9][0-9][0-9][0-9]\\)\\([^0-9]\\)" nil t) (replace-match "\\1 \\2\\3"))
      )
    )
  */
// (defun align2 () (interactive) (while (re-search-forward "\\([^ 0-9]\\)\\([0-9][0-9]\\)\\([^0-9]\\)" (region-end)) (replace-match "\\1   \\2\\3")))
// (defun align3 () (interactive) (while (re-search-forward "\\([^ 0-9]\\)\\([0-9][0-9][0-9]\\)\\([^0-9]\\)" (region-end)) (replace-match "\\1  \\2\\3")))
// (defun align4 () (interactive) (while (re-search-forward "\\([^ 0-9]\\)\\([0-9][0-9][0-9][0-9]\\)\\([^0-9]\\)" (region-end)) (replace-match "\\1 \\2\\3")))

// EN 302 307-1 Table B.1
static const s2_ldpc_table ldpc_nf_fec14 =
    {135, 45, {
                  {12, {23606, 36098, 1140, 28859, 18148, 18510, 6226, 540, 42014, 20879, 23802, 47088}},
                  {12, {16419, 24928, 16609, 17248, 7693, 24997, 42587, 16858, 34921, 21042, 37024, 20692}},
                  {12, {1874, 40094, 18704, 14474, 14004, 11519, 13106, 28826, 38669, 22363, 30255, 31105}},
                  {12, {22254, 40564, 22645, 22532, 6134, 9176, 39998, 23892, 8937, 15608, 16854, 31009}},
                  {12, {8037, 40401, 13550, 19526, 41902, 28782, 13304, 32796, 24679, 27140, 45980, 10021}},
                  {12, {40540, 44498, 13911, 22435, 32701, 18405, 39929, 25521, 12497, 9851, 39223, 34823}},
                  {12, {15233, 45333, 5041, 44979, 45710, 42150, 19416, 1892, 23121, 15860, 8832, 10308}},
                  {12, {10468, 44296, 3611, 1480, 37581, 32254, 13817, 6883, 32892, 40258, 46538, 11940}},
                  {12, {6705, 21634, 28150, 43757, 895, 6547, 20970, 28914, 30117, 25736, 41734, 11392}},
                  {12, {22002, 5739, 27210, 27828, 34192, 37992, 10915, 6998, 3824, 42130, 4494, 35739}},
                  {12, {8515, 1191, 13642, 30950, 25943, 12673, 16726, 34261, 31828, 3340, 8747, 39225}},
                  {12, {18979, 17058, 43130, 4246, 4793, 44030, 19454, 29511, 47929, 15174, 24333, 19354}},
                  {12, {16694, 8381, 29642, 46516, 32224, 26344, 9405, 18292, 12437, 27316, 35466, 41992}},
                  {12, {15642, 5871, 46489, 26723, 23396, 7257, 8974, 3156, 37420, 44823, 35423, 13541}},
                  {12, {42858, 32008, 41282, 38773, 26570, 2702, 27260, 46974, 1469, 20887, 27426, 38553}},
                  {3, {22152, 24261, 8297}},
                  {3, {19347, 9978, 27802}},
                  {3, {34991, 6354, 33561}},
                  {3, {29782, 30875, 29523}},
                  {3, {9278, 48512, 14349}},
                  {3, {38061, 4165, 43878}},
                  {3, {8548, 33172, 34410}},
                  {3, {22535, 28811, 23950}},
                  {3, {20439, 4027, 24186}},
                  {3, {38618, 8187, 30947}},
                  {3, {35538, 43880, 21459}},
                  {3, {7091, 45616, 15063}},
                  {3, {5505, 9315, 21908}},
                  {3, {36046, 32914, 11836}},
                  {3, {7304, 39782, 33721}},
                  {3, {16905, 29962, 12980}},
                  {3, {11171, 23709, 22460}},
                  {3, {34541, 9937, 44500}},
                  {3, {14035, 47316, 8815}},
                  {3, {15057, 45482, 24461}},
                  {3, {30518, 36877, 879}},
                  {3, {7583, 13364, 24332}},
                  {3, {448, 27056, 4682}},
                  {3, {12083, 31378, 21670}},
                  {3, {1159, 18031, 2221}},
                  {3, {17028, 38715, 9350}},
                  {3, {17343, 24530, 29574}},
                  {3, {46128, 31039, 32818}},
                  {3, {20373, 36967, 18345}},
                  {3, {46685, 20622, 32806}},
              }};

// EN 302 307-1 Table B.2
static const s2_ldpc_table ldpc_nf_fec13 =
    {120, 60, {
                  {12, {34903, 20927, 32093, 1052, 25611, 16093, 16454, 5520, 506, 37399, 18518, 21120}},
                  {11, {11636, 14594, 22158, 14763, 15333, 6838, 22222, 37856, 14985, 31041, 18704}},
                  {13, {32910, 17449, 1665, 35639, 16624, 12867, 12449, 10241, 11650, 25622, 34372, 19878, 26894}},
                  {12, {29235, 19780, 36056, 20129, 20029, 5457, 8157, 35554, 21237, 7943, 13873, 14980}},
                  {11, {9912, 7143, 35911, 12043, 17360, 37253, 25588, 11827, 29152, 21936, 24125}},
                  {13, {40870, 40701, 36035, 39556, 12366, 19946, 29072, 16365, 35495, 22686, 11106, 8756, 34863}},
                  {12, {19165, 15702, 13536, 40238, 4465, 40034, 40590, 37540, 17162, 1712, 20577, 14138}},
                  {12, {31338, 19342, 9301, 39375, 3211, 1316, 33409, 28670, 12282, 6118, 29236, 35787}},
                  {12, {11504, 30506, 19558, 5100, 24188, 24738, 30397, 33775, 9699, 6215, 3397, 37451}},
                  {12, {34689, 23126, 7571, 1058, 12127, 27518, 23064, 11265, 14867, 30451, 28289, 2966}},
                  {12, {11660, 15334, 16867, 15160, 38343, 3778, 4265, 39139, 17293, 26229, 42604, 13486}},
                  {12, {31497, 1365, 14828, 7453, 26350, 41346, 28643, 23421, 8354, 16255, 11055, 24279}},
                  {12, {15687, 12467, 13906, 5215, 41328, 23755, 20800, 6447, 7970, 2803, 33262, 39843}},
                  {12, {5363, 22469, 38091, 28457, 36696, 34471, 23619, 2404, 24229, 41754, 1297, 18563}},
                  {12, {3673, 39070, 14480, 30279, 37483, 7580, 29519, 30519, 39831, 20252, 18132, 20010}},
                  {12, {34386, 7252, 27526, 12950, 6875, 43020, 31566, 39069, 18985, 15541, 40020, 16715}},
                  {12, {1721, 37332, 39953, 17430, 32134, 29162, 10490, 12971, 28581, 29331, 6489, 35383}},
                  {12, {736, 7022, 42349, 8783, 6767, 11871, 21675, 10325, 11548, 25978, 431, 24085}},
                  {12, {1925, 10602, 28585, 12170, 15156, 34404, 8351, 13273, 20208, 5800, 15367, 21764}},
                  {12, {16279, 37832, 34792, 21250, 34192, 7406, 41488, 18346, 29227, 26127, 25493, 7048}},
                  {3, {39948, 28229, 24899}},
                  {3, {17408, 14274, 38993}},
                  {3, {38774, 15968, 28459}},
                  {3, {41404, 27249, 27425}},
                  {3, {41229, 6082, 43114}},
                  {3, {13957, 4979, 40654}},
                  {3, {3093, 3438, 34992}},
                  {3, {34082, 6172, 28760}},
                  {3, {42210, 34141, 41021}},
                  {3, {14705, 17783, 10134}},
                  {3, {41755, 39884, 22773}},
                  {3, {14615, 15593, 1642}},
                  {3, {29111, 37061, 39860}},
                  {3, {9579, 33552, 633}},
                  {3, {12951, 21137, 39608}},
                  {3, {38244, 27361, 29417}},
                  {3, {2939, 10172, 36479}},
                  {3, {29094, 5357, 19224}},
                  {3, {9562, 24436, 28637}},
                  {3, {40177, 2326, 13504}},
                  {3, {6834, 21583, 42516}},
                  {3, {40651, 42810, 25709}},
                  {3, {31557, 32138, 38142}},
                  {3, {18624, 41867, 39296}},
                  {3, {37560, 14295, 16245}},
                  {3, {6821, 21679, 31570}},
                  {3, {25339, 25083, 22081}},
                  {3, {8047, 697, 35268}},
                  {3, {9884, 17073, 19995}},
                  {3, {26848, 35245, 8390}},
                  {3, {18658, 16134, 14807}},
                  {3, {12201, 32944, 5035}},
                  {3, {25236, 1216, 38986}},
                  {3, {42994, 24782, 8681}},
                  {3, {28321, 4932, 34249}},
                  {3, {4107, 29382, 32124}},
                  {3, {22157, 2624, 14468}},
                  {3, {38788, 27081, 7936}},
                  {3, {4368, 26148, 10578}},
                  {3, {25353, 4122, 39751}},
              }};

// EN 302 307-1 Table B.3
static const s2_ldpc_table ldpc_nf_fec25 =
    {108, 72, {
                  {12, {31413, 18834, 28884, 947, 23050, 14484, 14809, 4968, 455, 33659, 16666, 19008}},
                  {12, {13172, 19939, 13354, 13719, 6132, 20086, 34040, 13442, 27958, 16813, 29619, 16553}},
                  {12, {1499, 32075, 14962, 11578, 11204, 9217, 10485, 23062, 30936, 17892, 24204, 24885}},
                  {12, {32490, 18086, 18007, 4957, 7285, 32073, 19038, 7152, 12486, 13483, 24808, 21759}},
                  {12, {32321, 10839, 15620, 33521, 23030, 10646, 26236, 19744, 21713, 36784, 8016, 12869}},
                  {12, {35597, 11129, 17948, 26160, 14729, 31943, 20416, 10000, 7882, 31380, 27858, 33356}},
                  {12, {14125, 12131, 36199, 4058, 35992, 36594, 33698, 15475, 1566, 18498, 12725, 7067}},
                  {12, {17406, 8372, 35437, 2888, 1184, 30068, 25802, 11056, 5507, 26313, 32205, 37232}},
                  {12, {15254, 5365, 17308, 22519, 35009, 718, 5240, 16778, 23131, 24092, 20587, 33385}},
                  {12, {27455, 17602, 4590, 21767, 22266, 27357, 30400, 8732, 5596, 3060, 33703, 3596}},
                  {12, {6882, 873, 10997, 24738, 20770, 10067, 13379, 27409, 25463, 2673, 6998, 31378}},
                  {12, {15181, 13645, 34501, 3393, 3840, 35227, 15562, 23615, 38342, 12139, 19471, 15483}},
                  {12, {13350, 6707, 23709, 37204, 25778, 21082, 7511, 14588, 10010, 21854, 28375, 33591}},
                  {12, {12514, 4695, 37190, 21379, 18723, 5802, 7182, 2529, 29936, 35860, 28338, 10835}},
                  {12, {34283, 25610, 33026, 31017, 21259, 2165, 21807, 37578, 1175, 16710, 21939, 30841}},
                  {12, {27292, 33730, 6836, 26476, 27539, 35784, 18245, 16394, 17939, 23094, 19216, 17432}},
                  {12, {11655, 6183, 38708, 28408, 35157, 17089, 13998, 36029, 15052, 16617, 5638, 36464}},
                  {12, {15693, 28923, 26245, 9432, 11675, 25720, 26405, 5838, 31851, 26898, 8090, 37037}},
                  {12, {24418, 27583, 7959, 35562, 37771, 17784, 11382, 11156, 37855, 7073, 21685, 34515}},
                  {12, {10977, 13633, 30969, 7516, 11943, 18199, 5231, 13825, 19589, 23661, 11150, 35602}},
                  {12, {19124, 30774, 6670, 37344, 16510, 26317, 23518, 22957, 6348, 34069, 8845, 20175}},
                  {12, {34985, 14441, 25668, 4116, 3019, 21049, 37308, 24551, 24727, 20104, 24850, 12114}},
                  {12, {38187, 28527, 13108, 13985, 1425, 21477, 30807, 8613, 26241, 33368, 35913, 32477}},
                  {12, {5903, 34390, 24641, 26556, 23007, 27305, 38247, 2621, 9122, 32806, 21554, 18685}},
                  {3, {17287, 27292, 19033}},
                  {3, {25796, 31795, 12152}},
                  {3, {12184, 35088, 31226}},
                  {3, {38263, 33386, 24892}},
                  {3, {23114, 37995, 29796}},
                  {3, {34336, 10551, 36245}},
                  {3, {35407, 175, 7203}},
                  {3, {14654, 38201, 22605}},
                  {3, {28404, 6595, 1018}},
                  {3, {19932, 3524, 29305}},
                  {3, {31749, 20247, 8128}},
                  {3, {18026, 36357, 26735}},
                  {3, {7543, 29767, 13588}},
                  {3, {13333, 25965, 8463}},
                  {3, {14504, 36796, 19710}},
                  {3, {4528, 25299, 7318}},
                  {3, {35091, 25550, 14798}},
                  {3, {7824, 215, 1248}},
                  {3, {30848, 5362, 17291}},
                  {3, {28932, 30249, 27073}},
                  {3, {13062, 2103, 16206}},
                  {3, {7129, 32062, 19612}},
                  {3, {9512, 21936, 38833}},
                  {3, {35849, 33754, 23450}},
                  {3, {18705, 28656, 18111}},
                  {3, {22749, 27456, 32187}},
                  {3, {28229, 31684, 30160}},
                  {3, {15293, 8483, 28002}},
                  {3, {14880, 13334, 12584}},
                  {3, {28646, 2558, 19687}},
                  {3, {6259, 4499, 26336}},
                  {3, {11952, 28386, 8405}},
                  {3, {10609, 961, 7582}},
                  {3, {10423, 13191, 26818}},
                  {3, {15922, 36654, 21450}},
                  {3, {10492, 1532, 1205}},
                  {3, {30551, 36482, 22153}},
                  {3, {5156, 11330, 34243}},
                  {3, {28616, 35369, 13322}},
                  {3, {8962, 1485, 21186}},
                  {3, {23541, 17445, 35561}},
                  {3, {33133, 11593, 19895}},
                  {3, {33917, 7863, 33651}},
                  {3, {20063, 28331, 10702}},
                  {3, {13195, 21107, 21859}},
                  {3, {4364, 31137, 4804}},
                  {3, {5585, 2037, 4830}},
                  {3, {30672, 16927, 14800}},
              }};

// EN 302 307-1 Table B.4
static const s2_ldpc_table ldpc_nf_fec12 =
    {90, 90, {
                 {8, {54, 9318, 14392, 27561, 26909, 10219, 2534, 8597}},
                 {8, {55, 7263, 4635, 2530, 28130, 3033, 23830, 3651}},
                 {8, {56, 24731, 23583, 26036, 17299, 5750, 792, 9169}},
                 {8, {57, 5811, 26154, 18653, 11551, 15447, 13685, 16264}},
                 {8, {58, 12610, 11347, 28768, 2792, 3174, 29371, 12997}},
                 {8, {59, 16789, 16018, 21449, 6165, 21202, 15850, 3186}},
                 {8, {60, 31016, 21449, 17618, 6213, 12166, 8334, 18212}},
                 {8, {61, 22836, 14213, 11327, 5896, 718, 11727, 9308}},
                 {8, {62, 2091, 24941, 29966, 23634, 9013, 15587, 5444}},
                 {8, {63, 22207, 3983, 16904, 28534, 21415, 27524, 25912}},
                 {8, {64, 25687, 4501, 22193, 14665, 14798, 16158, 5491}},
                 {8, {65, 4520, 17094, 23397, 4264, 22370, 16941, 21526}},
                 {8, {66, 10490, 6182, 32370, 9597, 30841, 25954, 2762}},
                 {8, {67, 22120, 22865, 29870, 15147, 13668, 14955, 19235}},
                 {8, {68, 6689, 18408, 18346, 9918, 25746, 5443, 20645}},
                 {8, {69, 29982, 12529, 13858, 4746, 30370, 10023, 24828}},
                 {8, {70, 1262, 28032, 29888, 13063, 24033, 21951, 7863}},
                 {8, {71, 6594, 29642, 31451, 14831, 9509, 9335, 31552}},
                 {8, {72, 1358, 6454, 16633, 20354, 24598, 624, 5265}},
                 {8, {73, 19529, 295, 18011, 3080, 13364, 8032, 15323}},
                 {8, {74, 11981, 1510, 7960, 21462, 9129, 11370, 25741}},
                 {8, {75, 9276, 29656, 4543, 30699, 20646, 21921, 28050}},
                 {8, {76, 15975, 25634, 5520, 31119, 13715, 21949, 19605}},
                 {8, {77, 18688, 4608, 31755, 30165, 13103, 10706, 29224}},
                 {8, {78, 21514, 23117, 12245, 26035, 31656, 25631, 30699}},
                 {8, {79, 9674, 24966, 31285, 29908, 17042, 24588, 31857}},
                 {8, {80, 21856, 27777, 29919, 27000, 14897, 11409, 7122}},
                 {8, {81, 29773, 23310, 263, 4877, 28622, 20545, 22092}},
                 {8, {82, 15605, 5651, 21864, 3967, 14419, 22757, 15896}},
                 {8, {83, 30145, 1759, 10139, 29223, 26086, 10556, 5098}},
                 {8, {84, 18815, 16575, 2936, 24457, 26738, 6030, 505}},
                 {8, {85, 30326, 22298, 27562, 20131, 26390, 6247, 24791}},
                 {8, {86, 928, 29246, 21246, 12400, 15311, 32309, 18608}},
                 {8, {87, 20314, 6025, 26689, 16302, 2296, 3244, 19613}},
                 {8, {88, 6237, 11943, 22851, 15642, 23857, 15112, 20947}},
                 {8, {89, 26403, 25168, 19038, 18384, 8882, 12719, 7093}},
                 {3, {0, 14567, 24965}},
                 {3, {1, 3908, 100}},
                 {3, {2, 10279, 240}},
                 {3, {3, 24102, 764}},
                 {3, {4, 12383, 4173}},
                 {3, {5, 13861, 15918}},
                 {3, {6, 21327, 1046}},
                 {3, {7, 5288, 14579}},
                 {3, {8, 28158, 8069}},
                 {3, {9, 16583, 11098}},
                 {3, {10, 16681, 28363}},
                 {3, {11, 13980, 24725}},
                 {3, {12, 32169, 17989}},
                 {3, {13, 10907, 2767}},
                 {3, {14, 21557, 3818}},
                 {3, {15, 26676, 12422}},
                 {3, {16, 7676, 8754}},
                 {3, {17, 14905, 20232}},
                 {3, {18, 15719, 24646}},
                 {3, {19, 31942, 8589}},
                 {3, {20, 19978, 27197}},
                 {3, {21, 27060, 15071}},
                 {3, {22, 6071, 26649}},
                 {3, {23, 10393, 11176}},
                 {3, {24, 9597, 13370}},
                 {3, {25, 7081, 17677}},
                 {3, {26, 1433, 19513}},
                 {3, {27, 26925, 9014}},
                 {3, {28, 19202, 8900}},
                 {3, {29, 18152, 30647}},
                 {3, {30, 20803, 1737}},
                 {3, {31, 11804, 25221}},
                 {3, {32, 31683, 17783}},
                 {3, {33, 29694, 9345}},
                 {3, {34, 12280, 26611}},
                 {3, {35, 6526, 26122}},
                 {3, {36, 26165, 11241}},
                 {3, {37, 7666, 26962}},
                 {3, {38, 16290, 8480}},
                 {3, {39, 11774, 10120}},
                 {3, {40, 30051, 30426}},
                 {3, {41, 1335, 15424}},
                 {3, {42, 6865, 17742}},
                 {3, {43, 31779, 12489}},
                 {3, {44, 32120, 21001}},
                 {3, {45, 14508, 6996}},
                 {3, {46, 979, 25024}},
                 {3, {47, 4554, 21896}},
                 {3, {48, 7989, 21777}},
                 {3, {49, 4972, 20661}},
                 {3, {50, 6612, 2730}},
                 {3, {51, 12742, 4418}},
                 {3, {52, 29194, 595}},
                 {3, {53, 19267, 20113}},
             }};

// EN 302 307-1 Table B.5
static const s2_ldpc_table ldpc_nf_fec35 =
    {72, 108, {
                  {12, {22422, 10282, 11626, 19997, 11161, 2922, 3122, 99, 5625, 17064, 8270, 179}},
                  {12, {25087, 16218, 17015, 828, 20041, 25656, 4186, 11629, 22599, 17305, 22515, 6463}},
                  {12, {11049, 22853, 25706, 14388, 5500, 19245, 8732, 2177, 13555, 11346, 17265, 3069}},
                  {12, {16581, 22225, 12563, 19717, 23577, 11555, 25496, 6853, 25403, 5218, 15925, 21766}},
                  {12, {16529, 14487, 7643, 10715, 17442, 11119, 5679, 14155, 24213, 21000, 1116, 15620}},
                  {12, {5340, 8636, 16693, 1434, 5635, 6516, 9482, 20189, 1066, 15013, 25361, 14243}},
                  {12, {18506, 22236, 20912, 8952, 5421, 15691, 6126, 21595, 500, 6904, 13059, 6802}},
                  {12, {8433, 4694, 5524, 14216, 3685, 19721, 25420, 9937, 23813, 9047, 25651, 16826}},
                  {12, {21500, 24814, 6344, 17382, 7064, 13929, 4004, 16552, 12818, 8720, 5286, 2206}},
                  {12, {22517, 2429, 19065, 2921, 21611, 1873, 7507, 5661, 23006, 23128, 20543, 19777}},
                  {12, {1770, 4636, 20900, 14931, 9247, 12340, 11008, 12966, 4471, 2731, 16445, 791}},
                  {12, {6635, 14556, 18865, 22421, 22124, 12697, 9803, 25485, 7744, 18254, 11313, 9004}},
                  {12, {19982, 23963, 18912, 7206, 12500, 4382, 20067, 6177, 21007, 1195, 23547, 24837}},
                  {12, {756, 11158, 14646, 20534, 3647, 17728, 11676, 11843, 12937, 4402, 8261, 22944}},
                  {12, {9306, 24009, 10012, 11081, 3746, 24325, 8060, 19826, 842, 8836, 2898, 5019}},
                  {12, {7575, 7455, 25244, 4736, 14400, 22981, 5543, 8006, 24203, 13053, 1120, 5128}},
                  {12, {3482, 9270, 13059, 15825, 7453, 23747, 3656, 24585, 16542, 17507, 22462, 14670}},
                  {12, {15627, 15290, 4198, 22748, 5842, 13395, 23918, 16985, 14929, 3726, 25350, 24157}},
                  {12, {24896, 16365, 16423, 13461, 16615, 8107, 24741, 3604, 25904, 8716, 9604, 20365}},
                  {12, {3729, 17245, 18448, 9862, 20831, 25326, 20517, 24618, 13282, 5099, 14183, 8804}},
                  {12, {16455, 17646, 15376, 18194, 25528, 1777, 6066, 21855, 14372, 12517, 4488, 17490}},
                  {12, {1400, 8135, 23375, 20879, 8476, 4084, 12936, 25536, 22309, 16582, 6402, 24360}},
                  {12, {25119, 23586, 128, 4761, 10443, 22536, 8607, 9752, 25446, 15053, 1856, 4040}},
                  {12, {377, 21160, 13474, 5451, 17170, 5938, 10256, 11972, 24210, 17833, 22047, 16108}},
                  {12, {13075, 9648, 24546, 13150, 23867, 7309, 19798, 2988, 16858, 4825, 23950, 15125}},
                  {12, {20526, 3553, 11525, 23366, 2452, 17626, 19265, 20172, 18060, 24593, 13255, 1552}},
                  {12, {18839, 21132, 20119, 15214, 14705, 7096, 10174, 5663, 18651, 19700, 12524, 14033}},
                  {12, {4127, 2971, 17499, 16287, 22368, 21463, 7943, 18880, 5567, 8047, 23363, 6797}},
                  {12, {10651, 24471, 14325, 4081, 7258, 4949, 7044, 1078, 797, 22910, 20474, 4318}},
                  {12, {21374, 13231, 22985, 5056, 3821, 23718, 14178, 9978, 19030, 23594, 8895, 25358}},
                  {12, {6199, 22056, 7749, 13310, 3999, 23697, 16445, 22636, 5225, 22437, 24153, 9442}},
                  {12, {7978, 12177, 2893, 20778, 3175, 8645, 11863, 24623, 10311, 25767, 17057, 3691}},
                  {12, {20473, 11294, 9914, 22815, 2574, 8439, 3699, 5431, 24840, 21908, 16088, 18244}},
                  {12, {8208, 5755, 19059, 8541, 24924, 6454, 11234, 10492, 16406, 10831, 11436, 9649}},
                  {12, {16264, 11275, 24953, 2347, 12667, 19190, 7257, 7174, 24819, 2938, 2522, 11749}},
                  {12, {3627, 5969, 13862, 1538, 23176, 6353, 2855, 17720, 2472, 7428, 573, 15036}},
                  {3, {0, 18539, 18661}},
                  {3, {1, 10502, 3002}},
                  {3, {2, 9368, 10761}},
                  {3, {3, 12299, 7828}},
                  {3, {4, 15048, 13362}},
                  {3, {5, 18444, 24640}},
                  {3, {6, 20775, 19175}},
                  {3, {7, 18970, 10971}},
                  {3, {8, 5329, 19982}},
                  {3, {9, 11296, 18655}},
                  {3, {10, 15046, 20659}},
                  {3, {11, 7300, 22140}},
                  {3, {12, 22029, 14477}},
                  {3, {13, 11129, 742}},
                  {3, {14, 13254, 13813}},
                  {3, {15, 19234, 13273}},
                  {3, {16, 6079, 21122}},
                  {3, {17, 22782, 5828}},
                  {3, {18, 19775, 4247}},
                  {3, {19, 1660, 19413}},
                  {3, {20, 4403, 3649}},
                  {3, {21, 13371, 25851}},
                  {3, {22, 22770, 21784}},
                  {3, {23, 10757, 14131}},
                  {3, {24, 16071, 21617}},
                  {3, {25, 6393, 3725}},
                  {3, {26, 597, 19968}},
                  {3, {27, 5743, 8084}},
                  {3, {28, 6770, 9548}},
                  {3, {29, 4285, 17542}},
                  {3, {30, 13568, 22599}},
                  {3, {31, 1786, 4617}},
                  {3, {32, 23238, 11648}},
                  {3, {33, 19627, 2030}},
                  {3, {34, 13601, 13458}},
                  {3, {35, 13740, 17328}},
                  {3, {36, 25012, 13944}},
                  {3, {37, 22513, 6687}},
                  {3, {38, 4934, 12587}},
                  {3, {39, 21197, 5133}},
                  {3, {40, 22705, 6938}},
                  {3, {41, 7534, 24633}},
                  {3, {42, 24400, 12797}},
                  {3, {43, 21911, 25712}},
                  {3, {44, 12039, 1140}},
                  {3, {45, 24306, 1021}},
                  {3, {46, 14012, 20747}},
                  {3, {47, 11265, 15219}},
                  {3, {48, 4670, 15531}},
                  {3, {49, 9417, 14359}},
                  {3, {50, 2415, 6504}},
                  {3, {51, 24964, 24690}},
                  {3, {52, 14443, 8816}},
                  {3, {53, 6926, 1291}},
                  {3, {54, 6209, 20806}},
                  {3, {55, 13915, 4079}},
                  {3, {56, 24410, 13196}},
                  {3, {57, 13505, 6117}},
                  {3, {58, 9869, 8220}},
                  {3, {59, 1570, 6044}},
                  {3, {60, 25780, 17387}},
                  {3, {61, 20671, 24913}},
                  {3, {62, 24558, 20591}},
                  {3, {63, 12402, 3702}},
                  {3, {64, 8314, 1357}},
                  {3, {65, 20071, 14616}},
                  {3, {66, 17014, 3688}},
                  {3, {67, 19837, 946}},
                  {3, {68, 15195, 12136}},
                  {3, {69, 7758, 22808}},
                  {3, {70, 3564, 2925}},
                  {3, {71, 3434, 7769}},
              }};

// EN 302 307-1 Table B.6
static const s2_ldpc_table ldpc_nf_fec23 =
    {60, 120, {
                  {13, {0, 10491, 16043, 506, 12826, 8065, 8226, 2767, 240, 18673, 9279, 10579, 20928}},
                  {13, {1, 17819, 8313, 6433, 6224, 5120, 5824, 12812, 17187, 9940, 13447, 13825, 18483}},
                  {13, {2, 17957, 6024, 8681, 18628, 12794, 5915, 14576, 10970, 12064, 20437, 4455, 7151}},
                  {13, {3, 19777, 6183, 9972, 14536, 8182, 17749, 11341, 5556, 4379, 17434, 15477, 18532}},
                  {13, {4, 4651, 19689, 1608, 659, 16707, 14335, 6143, 3058, 14618, 17894, 20684, 5306}},
                  {13, {5, 9778, 2552, 12096, 12369, 15198, 16890, 4851, 3109, 1700, 18725, 1997, 15882}},
                  {13, {6, 486, 6111, 13743, 11537, 5591, 7433, 15227, 14145, 1483, 3887, 17431, 12430}},
                  {13, {7, 20647, 14311, 11734, 4180, 8110, 5525, 12141, 15761, 18661, 18441, 10569, 8192}},
                  {13, {8, 3791, 14759, 15264, 19918, 10132, 9062, 10010, 12786, 10675, 9682, 19246, 5454}},
                  {13, {9, 19525, 9485, 7777, 19999, 8378, 9209, 3163, 20232, 6690, 16518, 716, 7353}},
                  {13, {10, 4588, 6709, 20202, 10905, 915, 4317, 11073, 13576, 16433, 368, 3508, 21171}},
                  {13, {11, 14072, 4033, 19959, 12608, 631, 19494, 14160, 8249, 10223, 21504, 12395, 4322}},
                  {3, {12, 13800, 14161}},
                  {3, {13, 2948, 9647}},
                  {3, {14, 14693, 16027}},
                  {3, {15, 20506, 11082}},
                  {3, {16, 1143, 9020}},
                  {3, {17, 13501, 4014}},
                  {3, {18, 1548, 2190}},
                  {3, {19, 12216, 21556}},
                  {3, {20, 2095, 19897}},
                  {3, {21, 4189, 7958}},
                  {3, {22, 15940, 10048}},
                  {3, {23, 515, 12614}},
                  {3, {24, 8501, 8450}},
                  {3, {25, 17595, 16784}},
                  {3, {26, 5913, 8495}},
                  {3, {27, 16394, 10423}},
                  {3, {28, 7409, 6981}},
                  {3, {29, 6678, 15939}},
                  {3, {30, 20344, 12987}},
                  {3, {31, 2510, 14588}},
                  {3, {32, 17918, 6655}},
                  {3, {33, 6703, 19451}},
                  {3, {34, 496, 4217}},
                  {3, {35, 7290, 5766}},
                  {3, {36, 10521, 8925}},
                  {3, {37, 20379, 11905}},
                  {3, {38, 4090, 5838}},
                  {3, {39, 19082, 17040}},
                  {3, {40, 20233, 12352}},
                  {3, {41, 19365, 19546}},
                  {3, {42, 6249, 19030}},
                  {3, {43, 11037, 19193}},
                  {3, {44, 19760, 11772}},
                  {3, {45, 19644, 7428}},
                  {3, {46, 16076, 3521}},
                  {3, {47, 11779, 21062}},
                  {3, {48, 13062, 9682}},
                  {3, {49, 8934, 5217}},
                  {3, {50, 11087, 3319}},
                  {3, {51, 18892, 4356}},
                  {3, {52, 7894, 3898}},
                  {3, {53, 5963, 4360}},
                  {3, {54, 7346, 11726}},
                  {3, {55, 5182, 5609}},
                  {3, {56, 2412, 17295}},
                  {3, {57, 9845, 20494}},
                  {3, {58, 6687, 1864}},
                  {3, {59, 20564, 5216}},
                  {3, {0, 18226, 17207}},
                  {3, {1, 9380, 8266}},
                  {3, {2, 7073, 3065}},
                  {3, {3, 18252, 13437}},
                  {3, {4, 9161, 15642}},
                  {3, {5, 10714, 10153}},
                  {3, {6, 11585, 9078}},
                  {3, {7, 5359, 9418}},
                  {3, {8, 9024, 9515}},
                  {3, {9, 1206, 16354}},
                  {3, {10, 14994, 1102}},
                  {3, {11, 9375, 20796}},
                  {3, {12, 15964, 6027}},
                  {3, {13, 14789, 6452}},
                  {3, {14, 8002, 18591}},
                  {3, {15, 14742, 14089}},
                  {3, {16, 253, 3045}},
                  {3, {17, 1274, 19286}},
                  {3, {18, 14777, 2044}},
                  {3, {19, 13920, 9900}},
                  {3, {20, 452, 7374}},
                  {3, {21, 18206, 9921}},
                  {3, {22, 6131, 5414}},
                  {3, {23, 10077, 9726}},
                  {3, {24, 12045, 5479}},
                  {3, {25, 4322, 7990}},
                  {3, {26, 15616, 5550}},
                  {3, {27, 15561, 10661}},
                  {3, {28, 20718, 7387}},
                  {3, {29, 2518, 18804}},
                  {3, {30, 8984, 2600}},
                  {3, {31, 6516, 17909}},
                  {3, {32, 11148, 98}},
                  {3, {33, 20559, 3704}},
                  {3, {34, 7510, 1569}},
                  {3, {35, 16000, 11692}},
                  {3, {36, 9147, 10303}},
                  {3, {37, 16650, 191}},
                  {3, {38, 15577, 18685}},
                  {3, {39, 17167, 20917}},
                  {3, {40, 4256, 3391}},
                  {3, {41, 20092, 17219}},
                  {3, {42, 9218, 5056}},
                  {3, {43, 18429, 8472}},
                  {3, {44, 12093, 20753}},
                  {3, {45, 16345, 12748}},
                  {3, {46, 16023, 11095}},
                  {3, {47, 5048, 17595}},
                  {3, {48, 18995, 4817}},
                  {3, {49, 16483, 3536}},
                  {3, {50, 1439, 16148}},
                  {3, {51, 3661, 3039}},
                  {3, {52, 19010, 18121}},
                  {3, {53, 8968, 11793}},
                  {3, {54, 13427, 18003}},
                  {3, {55, 5303, 3083}},
                  {3, {56, 531, 16668}},
                  {3, {57, 4771, 6722}},
                  {3, {58, 5695, 7960}},
                  {3, {59, 3589, 14630}},
              }};

// EN 302 307-1 Table B.7
static const s2_ldpc_table ldpc_nf_fec34 =
    {45, 135, {
                  {12, {0, 6385, 7901, 14611, 13389, 11200, 3252, 5243, 2504, 2722, 821, 7374}},
                  {12, {1, 11359, 2698, 357, 13824, 12772, 7244, 6752, 15310, 852, 2001, 11417}},
                  {12, {2, 7862, 7977, 6321, 13612, 12197, 14449, 15137, 13860, 1708, 6399, 13444}},
                  {12, {3, 1560, 11804, 6975, 13292, 3646, 3812, 8772, 7306, 5795, 14327, 7866}},
                  {12, {4, 7626, 11407, 14599, 9689, 1628, 2113, 10809, 9283, 1230, 15241, 4870}},
                  {12, {5, 1610, 5699, 15876, 9446, 12515, 1400, 6303, 5411, 14181, 13925, 7358}},
                  {12, {6, 4059, 8836, 3405, 7853, 7992, 15336, 5970, 10368, 10278, 9675, 4651}},
                  {12, {7, 4441, 3963, 9153, 2109, 12683, 7459, 12030, 12221, 629, 15212, 406}},
                  {12, {8, 6007, 8411, 5771, 3497, 543, 14202, 875, 9186, 6235, 13908, 3563}},
                  {12, {9, 3232, 6625, 4795, 546, 9781, 2071, 7312, 3399, 7250, 4932, 12652}},
                  {12, {10, 8820, 10088, 11090, 7069, 6585, 13134, 10158, 7183, 488, 7455, 9238}},
                  {12, {11, 1903, 10818, 119, 215, 7558, 11046, 10615, 11545, 14784, 7961, 15619}},
                  {12, {12, 3655, 8736, 4917, 15874, 5129, 2134, 15944, 14768, 7150, 2692, 1469}},
                  {12, {13, 8316, 3820, 505, 8923, 6757, 806, 7957, 4216, 15589, 13244, 2622}},
                  {12, {14, 14463, 4852, 15733, 3041, 11193, 12860, 13673, 8152, 6551, 15108, 8758}},
                  {3, {15, 3149, 11981}},
                  {3, {16, 13416, 6906}},
                  {3, {17, 13098, 13352}},
                  {3, {18, 2009, 14460}},
                  {3, {19, 7207, 4314}},
                  {3, {20, 3312, 3945}},
                  {3, {21, 4418, 6248}},
                  {3, {22, 2669, 13975}},
                  {3, {23, 7571, 9023}},
                  {3, {24, 14172, 2967}},
                  {3, {25, 7271, 7138}},
                  {3, {26, 6135, 13670}},
                  {3, {27, 7490, 14559}},
                  {3, {28, 8657, 2466}},
                  {3, {29, 8599, 12834}},
                  {3, {30, 3470, 3152}},
                  {3, {31, 13917, 4365}},
                  {3, {32, 6024, 13730}},
                  {3, {33, 10973, 14182}},
                  {3, {34, 2464, 13167}},
                  {3, {35, 5281, 15049}},
                  {3, {36, 1103, 1849}},
                  {3, {37, 2058, 1069}},
                  {3, {38, 9654, 6095}},
                  {3, {39, 14311, 7667}},
                  {3, {40, 15617, 8146}},
                  {3, {41, 4588, 11218}},
                  {3, {42, 13660, 6243}},
                  {3, {43, 8578, 7874}},
                  {3, {44, 11741, 2686}},
                  {3, {0, 1022, 1264}},
                  {3, {1, 12604, 9965}},
                  {3, {2, 8217, 2707}},
                  {3, {3, 3156, 11793}},
                  {3, {4, 354, 1514}},
                  {3, {5, 6978, 14058}},
                  {3, {6, 7922, 16079}},
                  {3, {7, 15087, 12138}},
                  {3, {8, 5053, 6470}},
                  {3, {9, 12687, 14932}},
                  {3, {10, 15458, 1763}},
                  {3, {11, 8121, 1721}},
                  {3, {12, 12431, 549}},
                  {3, {13, 4129, 7091}},
                  {3, {14, 1426, 8415}},
                  {3, {15, 9783, 7604}},
                  {3, {16, 6295, 11329}},
                  {3, {17, 1409, 12061}},
                  {3, {18, 8065, 9087}},
                  {3, {19, 2918, 8438}},
                  {3, {20, 1293, 14115}},
                  {3, {21, 3922, 13851}},
                  {3, {22, 3851, 4000}},
                  {3, {23, 5865, 1768}},
                  {3, {24, 2655, 14957}},
                  {3, {25, 5565, 6332}},
                  {3, {26, 4303, 12631}},
                  {3, {27, 11653, 12236}},
                  {3, {28, 16025, 7632}},
                  {3, {29, 4655, 14128}},
                  {3, {30, 9584, 13123}},
                  {3, {31, 13987, 9597}},
                  {3, {32, 15409, 12110}},
                  {3, {33, 8754, 15490}},
                  {3, {34, 7416, 15325}},
                  {3, {35, 2909, 15549}},
                  {3, {36, 2995, 8257}},
                  {3, {37, 9406, 4791}},
                  {3, {38, 11111, 4854}},
                  {3, {39, 2812, 8521}},
                  {3, {40, 8476, 14717}},
                  {3, {41, 7820, 15360}},
                  {3, {42, 1179, 7939}},
                  {3, {43, 2357, 8678}},
                  {3, {44, 7703, 6216}},
                  {3, {0, 3477, 7067}},
                  {3, {1, 3931, 13845}},
                  {3, {2, 7675, 12899}},
                  {3, {3, 1754, 8187}},
                  {3, {4, 7785, 1400}},
                  {3, {5, 9213, 5891}},
                  {3, {6, 2494, 7703}},
                  {3, {7, 2576, 7902}},
                  {3, {8, 4821, 15682}},
                  {3, {9, 10426, 11935}},
                  {3, {10, 1810, 904}},
                  {3, {11, 11332, 9264}},
                  {3, {12, 11312, 3570}},
                  {3, {13, 14916, 2650}},
                  {3, {14, 7679, 7842}},
                  {3, {15, 6089, 13084}},
                  {3, {16, 3938, 2751}},
                  {3, {17, 8509, 4648}},
                  {3, {18, 12204, 8917}},
                  {3, {19, 5749, 12443}},
                  {3, {20, 12613, 4431}},
                  {3, {21, 1344, 4014}},
                  {3, {22, 8488, 13850}},
                  {3, {23, 1730, 14896}},
                  {3, {24, 14942, 7126}},
                  {3, {25, 14983, 8863}},
                  {3, {26, 6578, 8564}},
                  {3, {27, 4947, 396}},
                  {3, {28, 297, 12805}},
                  {3, {29, 13878, 6692}},
                  {3, {30, 11857, 11186}},
                  {3, {31, 14395, 11493}},
                  {3, {32, 16145, 12251}},
                  {3, {33, 13462, 7428}},
                  {3, {34, 14526, 13119}},
                  {3, {35, 2535, 11243}},
                  {3, {36, 6465, 12690}},
                  {3, {37, 6872, 9334}},
                  {3, {38, 15371, 14023}},
                  {3, {39, 8101, 10187}},
                  {3, {40, 11963, 4848}},
                  {3, {41, 15125, 6119}},
                  {3, {42, 8051, 14465}},
                  {3, {43, 11139, 5167}},
                  {3, {44, 2883, 14521}},
              }};

// EN 302 307-1 Table B.8
static const s2_ldpc_table ldpc_nf_fec45 =
    {36, 144, {
                  {11, {0, 149, 11212, 5575, 6360, 12559, 8108, 8505, 408, 10026, 12828}},
                  {11, {1, 5237, 490, 10677, 4998, 3869, 3734, 3092, 3509, 7703, 10305}},
                  {11, {2, 8742, 5553, 2820, 7085, 12116, 10485, 564, 7795, 2972, 2157}},
                  {11, {3, 2699, 4304, 8350, 712, 2841, 3250, 4731, 10105, 517, 7516}},
                  {11, {4, 12067, 1351, 11992, 12191, 11267, 5161, 537, 6166, 4246, 2363}},
                  {11, {5, 6828, 7107, 2127, 3724, 5743, 11040, 10756, 4073, 1011, 3422}},
                  {11, {6, 11259, 1216, 9526, 1466, 10816, 940, 3744, 2815, 11506, 11573}},
                  {11, {7, 4549, 11507, 1118, 1274, 11751, 5207, 7854, 12803, 4047, 6484}},
                  {11, {8, 8430, 4115, 9440, 413, 4455, 2262, 7915, 12402, 8579, 7052}},
                  {11, {9, 3885, 9126, 5665, 4505, 2343, 253, 4707, 3742, 4166, 1556}},
                  {11, {10, 1704, 8936, 6775, 8639, 8179, 7954, 8234, 7850, 8883, 8713}},
                  {11, {11, 11716, 4344, 9087, 11264, 2274, 8832, 9147, 11930, 6054, 5455}},
                  {11, {12, 7323, 3970, 10329, 2170, 8262, 3854, 2087, 12899, 9497, 11700}},
                  {11, {13, 4418, 1467, 2490, 5841, 817, 11453, 533, 11217, 11962, 5251}},
                  {11, {14, 1541, 4525, 7976, 3457, 9536, 7725, 3788, 2982, 6307, 5997}},
                  {11, {15, 11484, 2739, 4023, 12107, 6516, 551, 2572, 6628, 8150, 9852}},
                  {11, {16, 6070, 1761, 4627, 6534, 7913, 3730, 11866, 1813, 12306, 8249}},
                  {11, {17, 12441, 5489, 8748, 7837, 7660, 2102, 11341, 2936, 6712, 11977}},
                  {3, {18, 10155, 4210}},
                  {3, {19, 1010, 10483}},
                  {3, {20, 8900, 10250}},
                  {3, {21, 10243, 12278}},
                  {3, {22, 7070, 4397}},
                  {3, {23, 12271, 3887}},
                  {3, {24, 11980, 6836}},
                  {3, {25, 9514, 4356}},
                  {3, {26, 7137, 10281}},
                  {3, {27, 11881, 2526}},
                  {3, {28, 1969, 11477}},
                  {3, {29, 3044, 10921}},
                  {3, {30, 2236, 8724}},
                  {3, {31, 9104, 6340}},
                  {3, {32, 7342, 8582}},
                  {3, {33, 11675, 10405}},
                  {3, {34, 6467, 12775}},
                  {3, {35, 3186, 12198}},
                  {3, {0, 9621, 11445}},
                  {3, {1, 7486, 5611}},
                  {3, {2, 4319, 4879}},
                  {3, {3, 2196, 344}},
                  {3, {4, 7527, 6650}},
                  {3, {5, 10693, 2440}},
                  {3, {6, 6755, 2706}},
                  {3, {7, 5144, 5998}},
                  {3, {8, 11043, 8033}},
                  {3, {9, 4846, 4435}},
                  {3, {10, 4157, 9228}},
                  {3, {11, 12270, 6562}},
                  {3, {12, 11954, 7592}},
                  {3, {13, 7420, 2592}},
                  {3, {14, 8810, 9636}},
                  {3, {15, 689, 5430}},
                  {3, {16, 920, 1304}},
                  {3, {17, 1253, 11934}},
                  {3, {18, 9559, 6016}},
                  {3, {19, 312, 7589}},
                  {3, {20, 4439, 4197}},
                  {3, {21, 4002, 9555}},
                  {3, {22, 12232, 7779}},
                  {3, {23, 1494, 8782}},
                  {3, {24, 10749, 3969}},
                  {3, {25, 4368, 3479}},
                  {3, {26, 6316, 5342}},
                  {3, {27, 2455, 3493}},
                  {3, {28, 12157, 7405}},
                  {3, {29, 6598, 11495}},
                  {3, {30, 11805, 4455}},
                  {3, {31, 9625, 2090}},
                  {3, {32, 4731, 2321}},
                  {3, {33, 3578, 2608}},
                  {3, {34, 8504, 1849}},
                  {3, {35, 4027, 1151}},
                  {3, {0, 5647, 4935}},
                  {3, {1, 4219, 1870}},
                  {3, {2, 10968, 8054}},
                  {3, {3, 6970, 5447}},
                  {3, {4, 3217, 5638}},
                  {3, {5, 8972, 669}},
                  {3, {6, 5618, 12472}},
                  {3, {7, 1457, 1280}},
                  {3, {8, 8868, 3883}},
                  {3, {9, 8866, 1224}},
                  {3, {10, 8371, 5972}},
                  {3, {11, 266, 4405}},
                  {3, {12, 3706, 3244}},
                  {3, {13, 6039, 5844}},
                  {3, {14, 7200, 3283}},
                  {3, {15, 1502, 11282}},
                  {3, {16, 12318, 2202}},
                  {3, {17, 4523, 965}},
                  {3, {18, 9587, 7011}},
                  {3, {19, 2552, 2051}},
                  {3, {20, 12045, 10306}},
                  {3, {21, 11070, 5104}},
                  {3, {22, 6627, 6906}},
                  {3, {23, 9889, 2121}},
                  {3, {24, 829, 9701}},
                  {3, {25, 2201, 1819}},
                  {3, {26, 6689, 12925}},
                  {3, {27, 2139, 8757}},
                  {3, {28, 12004, 5948}},
                  {3, {29, 8704, 3191}},
                  {3, {30, 8171, 10933}},
                  {3, {31, 6297, 7116}},
                  {3, {32, 616, 7146}},
                  {3, {33, 5142, 9761}},
                  {3, {34, 10377, 8138}},
                  {3, {35, 7616, 5811}},
                  {3, {0, 7285, 9863}},
                  {3, {1, 7764, 10867}},
                  {3, {2, 12343, 9019}},
                  {3, {3, 4414, 8331}},
                  {3, {4, 3464, 642}},
                  {3, {5, 6960, 2039}},
                  {3, {6, 786, 3021}},
                  {3, {7, 710, 2086}},
                  {3, {8, 7423, 5601}},
                  {3, {9, 8120, 4885}},
                  {3, {10, 12385, 11990}},
                  {3, {11, 9739, 10034}},
                  {3, {12, 424, 10162}},
                  {3, {13, 1347, 7597}},
                  {3, {14, 1450, 112}},
                  {3, {15, 7965, 8478}},
                  {3, {16, 8945, 7397}},
                  {3, {17, 6590, 8316}},
                  {3, {18, 6838, 9011}},
                  {3, {19, 6174, 9410}},
                  {3, {20, 255, 113}},
                  {3, {21, 6197, 5835}},
                  {3, {22, 12902, 3844}},
                  {3, {23, 4377, 3505}},
                  {3, {24, 5478, 8672}},
                  {3, {25, 4453, 2132}},
                  {3, {26, 9724, 1380}},
                  {3, {27, 12131, 11526}},
                  {3, {28, 12323, 9511}},
                  {3, {29, 8231, 1752}},
                  {3, {30, 497, 9022}},
                  {3, {31, 9288, 3080}},
                  {3, {32, 2481, 7515}},
                  {3, {33, 2696, 268}},
                  {3, {34, 4023, 12341}},
                  {3, {35, 7108, 5553}},
              }};

// EN 302 307-1 Table B.9
static const s2_ldpc_table ldpc_nf_fec56 =
    {30, 150, {
                  {13, {0, 4362, 416, 8909, 4156, 3216, 3112, 2560, 2912, 6405, 8593, 4969, 6723}},
                  {13, {1, 2479, 1786, 8978, 3011, 4339, 9313, 6397, 2957, 7288, 5484, 6031, 10217}},
                  {13, {2, 10175, 9009, 9889, 3091, 4985, 7267, 4092, 8874, 5671, 2777, 2189, 8716}},
                  {13, {3, 9052, 4795, 3924, 3370, 10058, 1128, 9996, 10165, 9360, 4297, 434, 5138}},
                  {13, {4, 2379, 7834, 4835, 2327, 9843, 804, 329, 8353, 7167, 3070, 1528, 7311}},
                  {13, {5, 3435, 7871, 348, 3693, 1876, 6585, 10340, 7144, 5870, 2084, 4052, 2780}},
                  {13, {6, 3917, 3111, 3476, 1304, 10331, 5939, 5199, 1611, 1991, 699, 8316, 9960}},
                  {13, {7, 6883, 3237, 1717, 10752, 7891, 9764, 4745, 3888, 10009, 4176, 4614, 1567}},
                  {13, {8, 10587, 2195, 1689, 2968, 5420, 2580, 2883, 6496, 111, 6023, 1024, 4449}},
                  {13, {9, 3786, 8593, 2074, 3321, 5057, 1450, 3840, 5444, 6572, 3094, 9892, 1512}},
                  {13, {10, 8548, 1848, 10372, 4585, 7313, 6536, 6379, 1766, 9462, 2456, 5606, 9975}},
                  {13, {11, 8204, 10593, 7935, 3636, 3882, 394, 5968, 8561, 2395, 7289, 9267, 9978}},
                  {13, {12, 7795, 74, 1633, 9542, 6867, 7352, 6417, 7568, 10623, 725, 2531, 9115}},
                  {13, {13, 7151, 2482, 4260, 5003, 10105, 7419, 9203, 6691, 8798, 2092, 8263, 3755}},
                  {13, {14, 3600, 570, 4527, 200, 9718, 6771, 1995, 8902, 5446, 768, 1103, 6520}},
                  {3, {15, 6304, 7621}},
                  {3, {16, 6498, 9209}},
                  {3, {17, 7293, 6786}},
                  {3, {18, 5950, 1708}},
                  {3, {19, 8521, 1793}},
                  {3, {20, 6174, 7854}},
                  {3, {21, 9773, 1190}},
                  {3, {22, 9517, 10268}},
                  {3, {23, 2181, 9349}},
                  {3, {24, 1949, 5560}},
                  {3, {25, 1556, 555}},
                  {3, {26, 8600, 3827}},
                  {3, {27, 5072, 1057}},
                  {3, {28, 7928, 3542}},
                  {3, {29, 3226, 3762}},
                  {3, {0, 7045, 2420}},
                  {3, {1, 9645, 2641}},
                  {3, {2, 2774, 2452}},
                  {3, {3, 5331, 2031}},
                  {3, {4, 9400, 7503}},
                  {3, {5, 1850, 2338}},
                  {3, {6, 10456, 9774}},
                  {3, {7, 1692, 9276}},
                  {3, {8, 10037, 4038}},
                  {3, {9, 3964, 338}},
                  {3, {10, 2640, 5087}},
                  {3, {11, 858, 3473}},
                  {3, {12, 5582, 5683}},
                  {3, {13, 9523, 916}},
                  {3, {14, 4107, 1559}},
                  {3, {15, 4506, 3491}},
                  {3, {16, 8191, 4182}},
                  {3, {17, 10192, 6157}},
                  {3, {18, 5668, 3305}},
                  {3, {19, 3449, 1540}},
                  {3, {20, 4766, 2697}},
                  {3, {21, 4069, 6675}},
                  {3, {22, 1117, 1016}},
                  {3, {23, 5619, 3085}},
                  {3, {24, 8483, 8400}},
                  {3, {25, 8255, 394}},
                  {3, {26, 6338, 5042}},
                  {3, {27, 6174, 5119}},
                  {3, {28, 7203, 1989}},
                  {3, {29, 1781, 5174}},
                  {3, {0, 1464, 3559}},
                  {3, {1, 3376, 4214}},
                  {3, {2, 7238, 67}},
                  {3, {3, 10595, 8831}},
                  {3, {4, 1221, 6513}},
                  {3, {5, 5300, 4652}},
                  {3, {6, 1429, 9749}},
                  {3, {7, 7878, 5131}},
                  {3, {8, 4435, 10284}},
                  {3, {9, 6331, 5507}},
                  {3, {10, 6662, 4941}},
                  {3, {11, 9614, 10238}},
                  {3, {12, 8400, 8025}},
                  {3, {13, 9156, 5630}},
                  {3, {14, 7067, 8878}},
                  {3, {15, 9027, 3415}},
                  {3, {16, 1690, 3866}},
                  {3, {17, 2854, 8469}},
                  {3, {18, 6206, 630}},
                  {3, {19, 363, 5453}},
                  {3, {20, 4125, 7008}},
                  {3, {21, 1612, 6702}},
                  {3, {22, 9069, 9226}},
                  {3, {23, 5767, 4060}},
                  {3, {24, 3743, 9237}},
                  {3, {25, 7018, 5572}},
                  {3, {26, 8892, 4536}},
                  {3, {27, 853, 6064}},
                  {3, {28, 8069, 5893}},
                  {3, {29, 2051, 2885}},
                  {3, {0, 10691, 3153}},
                  {3, {1, 3602, 4055}},
                  {3, {2, 328, 1717}},
                  {3, {3, 2219, 9299}},
                  {3, {4, 1939, 7898}},
                  {3, {5, 617, 206}},
                  {3, {6, 8544, 1374}},
                  {3, {7, 10676, 3240}},
                  {3, {8, 6672, 9489}},
                  {3, {9, 3170, 7457}},
                  {3, {10, 7868, 5731}},
                  {3, {11, 6121, 10732}},
                  {3, {12, 4843, 9132}},
                  {3, {13, 580, 9591}},
                  {3, {14, 6267, 9290}},
                  {3, {15, 3009, 2268}},
                  {3, {16, 195, 2419}},
                  {3, {17, 8016, 1557}},
                  {3, {18, 1516, 9195}},
                  {3, {19, 8062, 9064}},
                  {3, {20, 2095, 8968}},
                  {3, {21, 753, 7326}},
                  {3, {22, 6291, 3833}},
                  {3, {23, 2614, 7844}},
                  {3, {24, 2303, 646}},
                  {3, {25, 2075, 611}},
                  {3, {26, 4687, 362}},
                  {3, {27, 8684, 9940}},
                  {3, {28, 4830, 2065}},
                  {3, {29, 7038, 1363}},
                  {3, {0, 1769, 7837}},
                  {3, {1, 3801, 1689}},
                  {3, {2, 10070, 2359}},
                  {3, {3, 3667, 9918}},
                  {3, {4, 1914, 6920}},
                  {3, {5, 4244, 5669}},
                  {3, {6, 10245, 7821}},
                  {3, {7, 7648, 3944}},
                  {3, {8, 3310, 5488}},
                  {3, {9, 6346, 9666}},
                  {3, {10, 7088, 6122}},
                  {3, {11, 1291, 7827}},
                  {3, {12, 10592, 8945}},
                  {3, {13, 3609, 7120}},
                  {3, {14, 9168, 9112}},
                  {3, {15, 6203, 8052}},
                  {3, {16, 3330, 2895}},
                  {3, {17, 4264, 10563}},
                  {3, {18, 10556, 6496}},
                  {3, {19, 8807, 7645}},
                  {3, {20, 1999, 4530}},
                  {3, {21, 9202, 6818}},
                  {3, {22, 3403, 1734}},
                  {3, {23, 2106, 9023}},
                  {3, {24, 6881, 3883}},
                  {3, {25, 3895, 2171}},
                  {3, {26, 4062, 6424}},
                  {3, {27, 3755, 9536}},
                  {3, {28, 4683, 2131}},
                  {3, {29, 7347, 8027}},
              }};

// EN 302 307-1 Table B.10
static const s2_ldpc_table ldpc_nf_fec89 =
    {20, 160, {
                  {4, {0, 6235, 2848, 3222}},
                  {4, {1, 5800, 3492, 5348}},
                  {4, {2, 2757, 927, 90}},
                  {4, {3, 6961, 4516, 4739}},
                  {4, {4, 1172, 3237, 6264}},
                  {4, {5, 1927, 2425, 3683}},
                  {4, {6, 3714, 6309, 2495}},
                  {4, {7, 3070, 6342, 7154}},
                  {4, {8, 2428, 613, 3761}},
                  {4, {9, 2906, 264, 5927}},
                  {4, {10, 1716, 1950, 4273}},
                  {4, {11, 4613, 6179, 3491}},
                  {4, {12, 4865, 3286, 6005}},
                  {4, {13, 1343, 5923, 3529}},
                  {4, {14, 4589, 4035, 2132}},
                  {4, {15, 1579, 3920, 6737}},
                  {4, {16, 1644, 1191, 5998}},
                  {4, {17, 1482, 2381, 4620}},
                  {4, {18, 6791, 6014, 6596}},
                  {4, {19, 2738, 5918, 3786}},
                  {3, {0, 5156, 6166}},
                  {3, {1, 1504, 4356}},
                  {3, {2, 130, 1904}},
                  {3, {3, 6027, 3187}},
                  {3, {4, 6718, 759}},
                  {3, {5, 6240, 2870}},
                  {3, {6, 2343, 1311}},
                  {3, {7, 1039, 5465}},
                  {3, {8, 6617, 2513}},
                  {3, {9, 1588, 5222}},
                  {3, {10, 6561, 535}},
                  {3, {11, 4765, 2054}},
                  {3, {12, 5966, 6892}},
                  {3, {13, 1969, 3869}},
                  {3, {14, 3571, 2420}},
                  {3, {15, 4632, 981}},
                  {3, {16, 3215, 4163}},
                  {3, {17, 973, 3117}},
                  {3, {18, 3802, 6198}},
                  {3, {19, 3794, 3948}},
                  {3, {0, 3196, 6126}},
                  {3, {1, 573, 1909}},
                  {3, {2, 850, 4034}},
                  {3, {3, 5622, 1601}},
                  {3, {4, 6005, 524}},
                  {3, {5, 5251, 5783}},
                  {3, {6, 172, 2032}},
                  {3, {7, 1875, 2475}},
                  {3, {8, 497, 1291}},
                  {3, {9, 2566, 3430}},
                  {3, {10, 1249, 740}},
                  {3, {11, 2944, 1948}},
                  {3, {12, 6528, 2899}},
                  {3, {13, 2243, 3616}},
                  {3, {14, 867, 3733}},
                  {3, {15, 1374, 4702}},
                  {3, {16, 4698, 2285}},
                  {3, {17, 4760, 3917}},
                  {3, {18, 1859, 4058}},
                  {3, {19, 6141, 3527}},
                  {3, {0, 2148, 5066}},
                  {3, {1, 1306, 145}},
                  {3, {2, 2319, 871}},
                  {3, {3, 3463, 1061}},
                  {3, {4, 5554, 6647}},
                  {3, {5, 5837, 339}},
                  {3, {6, 5821, 4932}},
                  {3, {7, 6356, 4756}},
                  {3, {8, 3930, 418}},
                  {3, {9, 211, 3094}},
                  {3, {10, 1007, 4928}},
                  {3, {11, 3584, 1235}},
                  {3, {12, 6982, 2869}},
                  {3, {13, 1612, 1013}},
                  {3, {14, 953, 4964}},
                  {3, {15, 4555, 4410}},
                  {3, {16, 4925, 4842}},
                  {3, {17, 5778, 600}},
                  {3, {18, 6509, 2417}},
                  {3, {19, 1260, 4903}},
                  {3, {0, 3369, 3031}},
                  {3, {1, 3557, 3224}},
                  {3, {2, 3028, 583}},
                  {3, {3, 3258, 440}},
                  {3, {4, 6226, 6655}},
                  {3, {5, 4895, 1094}},
                  {3, {6, 1481, 6847}},
                  {3, {7, 4433, 1932}},
                  {3, {8, 2107, 1649}},
                  {3, {9, 2119, 2065}},
                  {3, {10, 4003, 6388}},
                  {3, {11, 6720, 3622}},
                  {3, {12, 3694, 4521}},
                  {3, {13, 1164, 7050}},
                  {3, {14, 1965, 3613}},
                  {3, {15, 4331, 66}},
                  {3, {16, 2970, 1796}},
                  {3, {17, 4652, 3218}},
                  {3, {18, 1762, 4777}},
                  {3, {19, 5736, 1399}},
                  {3, {0, 970, 2572}},
                  {3, {1, 2062, 6599}},
                  {3, {2, 4597, 4870}},
                  {3, {3, 1228, 6913}},
                  {3, {4, 4159, 1037}},
                  {3, {5, 2916, 2362}},
                  {3, {6, 395, 1226}},
                  {3, {7, 6911, 4548}},
                  {3, {8, 4618, 2241}},
                  {3, {9, 4120, 4280}},
                  {3, {10, 5825, 474}},
                  {3, {11, 2154, 5558}},
                  {3, {12, 3793, 5471}},
                  {3, {13, 5707, 1595}},
                  {3, {14, 1403, 325}},
                  {3, {15, 6601, 5183}},
                  {3, {16, 6369, 4569}},
                  {3, {17, 4846, 896}},
                  {3, {18, 7092, 6184}},
                  {3, {19, 6764, 7127}},
                  {3, {0, 6358, 1951}},
                  {3, {1, 3117, 6960}},
                  {3, {2, 2710, 7062}},
                  {3, {3, 1133, 3604}},
                  {3, {4, 3694, 657}},
                  {3, {5, 1355, 110}},
                  {3, {6, 3329, 6736}},
                  {3, {7, 2505, 3407}},
                  {3, {8, 2462, 4806}},
                  {3, {9, 4216, 214}},
                  {3, {10, 5348, 5619}},
                  {3, {11, 6627, 6243}},
                  {3, {12, 2644, 5073}},
                  {3, {13, 4212, 5088}},
                  {3, {14, 3463, 3889}},
                  {3, {15, 5306, 478}},
                  {3, {16, 4320, 6121}},
                  {3, {17, 3961, 1125}},
                  {3, {18, 5699, 1195}},
                  {3, {19, 6511, 792}},
                  {3, {0, 3934, 2778}},
                  {3, {1, 3238, 6587}},
                  {3, {2, 1111, 6596}},
                  {3, {3, 1457, 6226}},
                  {3, {4, 1446, 3885}},
                  {3, {5, 3907, 4043}},
                  {3, {6, 6839, 2873}},
                  {3, {7, 1733, 5615}},
                  {3, {8, 5202, 4269}},
                  {3, {9, 3024, 4722}},
                  {3, {10, 5445, 6372}},
                  {3, {11, 370, 1828}},
                  {3, {12, 4695, 1600}},
                  {3, {13, 680, 2074}},
                  {3, {14, 1801, 6690}},
                  {3, {15, 2669, 1377}},
                  {3, {16, 2463, 1681}},
                  {3, {17, 5972, 5171}},
                  {3, {18, 5728, 4284}},
                  {3, {19, 1696, 1459}},
              }};

// EN 302 307-1 Table B.11
static const s2_ldpc_table ldpc_nf_fec910 =
    {18, 162, {
                  {4, {0, 5611, 2563, 2900}},
                  {4, {1, 5220, 3143, 4813}},
                  {4, {2, 2481, 834, 81}},
                  {4, {3, 6265, 4064, 4265}},
                  {4, {4, 1055, 2914, 5638}},
                  {4, {5, 1734, 2182, 3315}},
                  {4, {6, 3342, 5678, 2246}},
                  {4, {7, 2185, 552, 3385}},
                  {4, {8, 2615, 236, 5334}},
                  {4, {9, 1546, 1755, 3846}},
                  {4, {10, 4154, 5561, 3142}},
                  {4, {11, 4382, 2957, 5400}},
                  {4, {12, 1209, 5329, 3179}},
                  {4, {13, 1421, 3528, 6063}},
                  {4, {14, 1480, 1072, 5398}},
                  {4, {15, 3843, 1777, 4369}},
                  {4, {16, 1334, 2145, 4163}},
                  {4, {17, 2368, 5055, 260}},
                  {3, {0, 6118, 5405}},
                  {3, {1, 2994, 4370}},
                  {3, {2, 3405, 1669}},
                  {3, {3, 4640, 5550}},
                  {3, {4, 1354, 3921}},
                  {3, {5, 117, 1713}},
                  {3, {6, 5425, 2866}},
                  {3, {7, 6047, 683}},
                  {3, {8, 5616, 2582}},
                  {3, {9, 2108, 1179}},
                  {3, {10, 933, 4921}},
                  {3, {11, 5953, 2261}},
                  {3, {12, 1430, 4699}},
                  {3, {13, 5905, 480}},
                  {3, {14, 4289, 1846}},
                  {3, {15, 5374, 6208}},
                  {3, {16, 1775, 3476}},
                  {3, {17, 3216, 2178}},
                  {3, {0, 4165, 884}},
                  {3, {1, 2896, 3744}},
                  {3, {2, 874, 2801}},
                  {3, {3, 3423, 5579}},
                  {3, {4, 3404, 3552}},
                  {3, {5, 2876, 5515}},
                  {3, {6, 516, 1719}},
                  {3, {7, 765, 3631}},
                  {3, {8, 5059, 1441}},
                  {3, {9, 5629, 598}},
                  {3, {10, 5405, 473}},
                  {3, {11, 4724, 5210}},
                  {3, {12, 155, 1832}},
                  {3, {13, 1689, 2229}},
                  {3, {14, 449, 1164}},
                  {3, {15, 2308, 3088}},
                  {3, {16, 1122, 669}},
                  {3, {17, 2268, 5758}},
                  {3, {0, 5878, 2609}},
                  {3, {1, 782, 3359}},
                  {3, {2, 1231, 4231}},
                  {3, {3, 4225, 2052}},
                  {3, {4, 4286, 3517}},
                  {3, {5, 5531, 3184}},
                  {3, {6, 1935, 4560}},
                  {3, {7, 1174, 131}},
                  {3, {8, 3115, 956}},
                  {3, {9, 3129, 1088}},
                  {3, {10, 5238, 4440}},
                  {3, {11, 5722, 4280}},
                  {3, {12, 3540, 375}},
                  {3, {13, 191, 2782}},
                  {3, {14, 906, 4432}},
                  {3, {15, 3225, 1111}},
                  {3, {16, 6296, 2583}},
                  {3, {17, 1457, 903}},
                  {3, {0, 855, 4475}},
                  {3, {1, 4097, 3970}},
                  {3, {2, 4433, 4361}},
                  {3, {3, 5198, 541}},
                  {3, {4, 1146, 4426}},
                  {3, {5, 3202, 2902}},
                  {3, {6, 2724, 525}},
                  {3, {7, 1083, 4124}},
                  {3, {8, 2326, 6003}},
                  {3, {9, 5605, 5990}},
                  {3, {10, 4376, 1579}},
                  {3, {11, 4407, 984}},
                  {3, {12, 1332, 6163}},
                  {3, {13, 5359, 3975}},
                  {3, {14, 1907, 1854}},
                  {3, {15, 3601, 5748}},
                  {3, {16, 6056, 3266}},
                  {3, {17, 3322, 4085}},
                  {3, {0, 1768, 3244}},
                  {3, {1, 2149, 144}},
                  {3, {2, 1589, 4291}},
                  {3, {3, 5154, 1252}},
                  {3, {4, 1855, 5939}},
                  {3, {5, 4820, 2706}},
                  {3, {6, 1475, 3360}},
                  {3, {7, 4266, 693}},
                  {3, {8, 4156, 2018}},
                  {3, {9, 2103, 752}},
                  {3, {10, 3710, 3853}},
                  {3, {11, 5123, 931}},
                  {3, {12, 6146, 3323}},
                  {3, {13, 1939, 5002}},
                  {3, {14, 5140, 1437}},
                  {3, {15, 1263, 293}},
                  {3, {16, 5949, 4665}},
                  {3, {17, 4548, 6380}},
                  {3, {0, 3171, 4690}},
                  {3, {1, 5204, 2114}},
                  {3, {2, 6384, 5565}},
                  {3, {3, 5722, 1757}},
                  {3, {4, 2805, 6264}},
                  {3, {5, 1202, 2616}},
                  {3, {6, 1018, 3244}},
                  {3, {7, 4018, 5289}},
                  {3, {8, 2257, 3067}},
                  {3, {9, 2483, 3073}},
                  {3, {10, 1196, 5329}},
                  {3, {11, 649, 3918}},
                  {3, {12, 3791, 4581}},
                  {3, {13, 5028, 3803}},
                  {3, {14, 3119, 3506}},
                  {3, {15, 4779, 431}},
                  {3, {16, 3888, 5510}},
                  {3, {17, 4387, 4084}},
                  {3, {0, 5836, 1692}},
                  {3, {1, 5126, 1078}},
                  {3, {2, 5721, 6165}},
                  {3, {3, 3540, 2499}},
                  {3, {4, 2225, 6348}},
                  {3, {5, 1044, 1484}},
                  {3, {6, 6323, 4042}},
                  {3, {7, 1313, 5603}},
                  {3, {8, 1303, 3496}},
                  {3, {9, 3516, 3639}},
                  {3, {10, 5161, 2293}},
                  {3, {11, 4682, 3845}},
                  {3, {12, 3045, 643}},
                  {3, {13, 2818, 2616}},
                  {3, {14, 3267, 649}},
                  {3, {15, 6236, 593}},
                  {3, {16, 646, 2948}},
                  {3, {17, 4213, 1442}},
                  {3, {0, 5779, 1596}},
                  {3, {1, 2403, 1237}},
                  {3, {2, 2217, 1514}},
                  {3, {3, 5609, 716}},
                  {3, {4, 5155, 3858}},
                  {3, {5, 1517, 1312}},
                  {3, {6, 2554, 3158}},
                  {3, {7, 5280, 2643}},
                  {3, {8, 4990, 1353}},
                  {3, {9, 5648, 1170}},
                  {3, {10, 1152, 4366}},
                  {3, {11, 3561, 5368}},
                  {3, {12, 3581, 1411}},
                  {3, {13, 5647, 4661}},
                  {3, {14, 1542, 5401}},
                  {3, {15, 5078, 2687}},
                  {3, {16, 316, 1755}},
                  {3, {17, 3392, 1991}},
              }};

// EN 302 307-1 Table C.1
static const s2_ldpc_table ldpc_sf_fec14 =
    {36, 9, {
                {12, {6295, 9626, 304, 7695, 4839, 4936, 1660, 144, 11203, 5567, 6347, 12557}},
                {12, {10691, 4988, 3859, 3734, 3071, 3494, 7687, 10313, 5964, 8069, 8296, 11090}},
                {12, {10774, 3613, 5208, 11177, 7676, 3549, 8746, 6583, 7239, 12265, 2674, 4292}},
                {12, {11869, 3708, 5981, 8718, 4908, 10650, 6805, 3334, 2627, 10461, 9285, 11120}},
                {3, {7844, 3079, 10773}},
                {3, {3385, 10854, 5747}},
                {3, {1360, 12010, 12202}},
                {3, {6189, 4241, 2343}},
                {3, {9840, 12726, 4977}},
            }};

// EN 302 307-1 Table C.2
static const s2_ldpc_table ldpc_sf_fec13 =
    {30, 15, {
                 {12, {416, 8909, 4156, 3216, 3112, 2560, 2912, 6405, 8593, 4969, 6723, 6912}},
                 {12, {8978, 3011, 4339, 9312, 6396, 2957, 7288, 5485, 6031, 10218, 2226, 3575}},
                 {12, {3383, 10059, 1114, 10008, 10147, 9384, 4290, 434, 5139, 3536, 1965, 2291}},
                 {12, {2797, 3693, 7615, 7077, 743, 1941, 8716, 6215, 3840, 5140, 4582, 5420}},
                 {12, {6110, 8551, 1515, 7404, 4879, 4946, 5383, 1831, 3441, 9569, 10472, 4306}},
                 {3, {1505, 5682, 7778}},
                 {3, {7172, 6830, 6623}},
                 {3, {7281, 3941, 3505}},
                 {3, {10270, 8669, 914}},
                 {3, {3622, 7563, 9388}},
                 {3, {9930, 5058, 4554}},
                 {3, {4844, 9609, 2707}},
                 {3, {6883, 3237, 1714}},
                 {3, {4768, 3878, 10017}},
                 {3, {10127, 3334, 8267}},
             }};

// EN 302 307-1 Table C.3
static const s2_ldpc_table ldpc_sf_fec25 =
    {27, 18, {
                 {12, {5650, 4143, 8750, 583, 6720, 8071, 635, 1767, 1344, 6922, 738, 6658}},
                 {12, {5696, 1685, 3207, 415, 7019, 5023, 5608, 2605, 857, 6915, 1770, 8016}},
                 {12, {3992, 771, 2190, 7258, 8970, 7792, 1802, 1866, 6137, 8841, 886, 1931}},
                 {12, {4108, 3781, 7577, 6810, 9322, 8226, 5396, 5867, 4428, 8827, 7766, 2254}},
                 {12, {4247, 888, 4367, 8821, 9660, 324, 5864, 4774, 227, 7889, 6405, 8963}},
                 {12, {9693, 500, 2520, 2227, 1811, 9330, 1928, 5140, 4030, 4824, 806, 3134}},
                 {12, {1652, 8171, 1435}},
                 {12, {3366, 6543, 3745}},
                 {12, {9286, 8509, 4645}},
                 {12, {7397, 5790, 8972}},
                 {12, {6597, 4422, 1799}},
                 {12, {9276, 4041, 3847}},
                 {12, {8683, 7378, 4946}},
                 {12, {5348, 1993, 9186}},
                 {12, {6724, 9015, 5646}},
                 {12, {4502, 4439, 8474}},
                 {12, {5107, 7342, 9442}},
                 {12, {1387, 8910, 2660}},
             }};

// EN 302 307-1 Table C.4
static const s2_ldpc_table ldpc_sf_fec12 =
    {25, 20, {
                 {8, {20, 712, 2386, 6354, 4061, 1062, 5045, 5158}},
                 {8, {21, 2543, 5748, 4822, 2348, 3089, 6328, 5876}},
                 {8, {22, 926, 5701, 269, 3693, 2438, 3190, 3507}},
                 {8, {23, 2802, 4520, 3577, 5324, 1091, 4667, 4449}},
                 {8, {24, 5140, 2003, 1263, 4742, 6497, 1185, 6202}},
                 {3, {0, 4046, 6934}},
                 {3, {1, 2855, 66}},
                 {3, {2, 6694, 212}},
                 {3, {3, 3439, 1158}},
                 {3, {4, 3850, 4422}},
                 {3, {5, 5924, 290}},
                 {3, {6, 1467, 4049}},
                 {3, {7, 7820, 2242}},
                 {3, {8, 4606, 3080}},
                 {3, {9, 4633, 7877}},
                 {3, {10, 3884, 6868}},
                 {3, {11, 8935, 4996}},
                 {3, {12, 3028, 764}},
                 {3, {13, 5988, 1057}},
                 {3, {14, 7411, 3450}},
             }};

// EN 302 307-1 Table C.5
static const s2_ldpc_table ldpc_sf_fec35 =
    {18, 27, {
                 {12, {2765, 5713, 6426, 3596, 1374, 4811, 2182, 544, 3394, 2840, 4310, 771}},
                 {12, {4951, 211, 2208, 723, 1246, 2928, 398, 5739, 265, 5601, 5993, 2615}},
                 {12, {210, 4730, 5777, 3096, 4282, 6238, 4939, 1119, 6463, 5298, 6320, 4016}},
                 {12, {4167, 2063, 4757, 3157, 5664, 3956, 6045, 563, 4284, 2441, 3412, 6334}},
                 {12, {4201, 2428, 4474, 59, 1721, 736, 2997, 428, 3807, 1513, 4732, 6195}},
                 {12, {2670, 3081, 5139, 3736, 1999, 5889, 4362, 3806, 4534, 5409, 6384, 5809}},
                 {12, {5516, 1622, 2906, 3285, 1257, 5797, 3816, 817, 875, 2311, 3543, 1205}},
                 {12, {4244, 2184, 5415, 1705, 5642, 4886, 2333, 287, 1848, 1121, 3595, 6022}},
                 {12, {2142, 2830, 4069, 5654, 1295, 2951, 3919, 1356, 884, 1786, 396, 4738}},
                 {3, {0, 2161, 2653}},
                 {3, {1, 1380, 1461}},
                 {3, {2, 2502, 3707}},
                 {3, {3, 3971, 1057}},
                 {3, {4, 5985, 6062}},
                 {3, {5, 1733, 6028}},
                 {3, {6, 3786, 1936}},
                 {3, {7, 4292, 956}},
                 {3, {8, 5692, 3417}},
                 {3, {9, 266, 4878}},
                 {3, {10, 4913, 3247}},
                 {3, {11, 4763, 3937}},
                 {3, {12, 3590, 2903}},
                 {3, {13, 2566, 4215}},
                 {3, {14, 5208, 4707}},
                 {3, {15, 3940, 3388}},
                 {3, {16, 5109, 4556}},
                 {3, {17, 4908, 4177}},
             }};

// EN 302 307-1 Table C.6
static const s2_ldpc_table ldpc_sf_fec23 =
    {15, 30, {
                 {13, {0, 2084, 1613, 1548, 1286, 1460, 3196, 4297, 2481, 3369, 3451, 4620, 2622}},
                 {13, {1, 122, 1516, 3448, 2880, 1407, 1847, 3799, 3529, 373, 971, 4358, 3108}},
                 {13, {2, 259, 3399, 929, 2650, 864, 3996, 3833, 107, 5287, 164, 3125, 2350}},
                 {3, {3, 342, 3529}},
                 {3, {4, 4198, 2147}},
                 {3, {5, 1880, 4836}},
                 {3, {6, 3864, 4910}},
                 {3, {7, 243, 1542}},
                 {3, {8, 3011, 1436}},
                 {3, {9, 2167, 2512}},
                 {3, {10, 4606, 1003}},
                 {3, {11, 2835, 705}},
                 {3, {12, 3426, 2365}},
                 {3, {13, 3848, 2474}},
                 {3, {14, 1360, 1743}},
                 {3, {0, 163, 2536}},
                 {3, {1, 2583, 1180}},
                 {3, {2, 1542, 509}},
                 {3, {3, 4418, 1005}},
                 {3, {4, 5212, 5117}},
                 {3, {5, 2155, 2922}},
                 {3, {6, 347, 2696}},
                 {3, {7, 226, 4296}},
                 {3, {8, 1560, 487}},
                 {3, {9, 3926, 1640}},
                 {3, {10, 149, 2928}},
                 {3, {11, 2364, 563}},
                 {3, {12, 635, 688}},
                 {3, {13, 231, 1684}},
                 {3, {14, 1129, 3894}},
             }};

// EN 302 307-1 Table C.7
static const s2_ldpc_table ldpc_sf_fec34 =
    {12, 33, {
                 {3, {3, 3198, 478, 4207, 1481, 1009, 2616, 1924, 3437, 554, 683, 1801}},
                 {3, {4, 2681, 2135}},
                 {3, {5, 3107, 4027}},
                 {3, {6, 2637, 3373}},
                 {3, {7, 3830, 3449}},
                 {3, {8, 4129, 2060}},
                 {3, {9, 4184, 2742}},
                 {3, {10, 3946, 1070}},
                 {3, {11, 2239, 984}},
                 {3, {0, 1458, 3031}},
                 {3, {1, 3003, 1328}},
                 {3, {2, 1137, 1716}},
                 {3, {3, 132, 3725}},
                 {3, {4, 1817, 638}},
                 {3, {5, 1774, 3447}},
                 {3, {6, 3632, 1257}},
                 {3, {7, 542, 3694}},
                 {3, {8, 1015, 1945}},
                 {3, {9, 1948, 412}},
                 {3, {10, 995, 2238}},
                 {3, {11, 4141, 1907}},
                 {3, {0, 2480, 3079}},
                 {3, {1, 3021, 1088}},
                 {3, {2, 713, 1379}},
                 {3, {3, 997, 3903}},
                 {3, {4, 2323, 3361}},
                 {3, {5, 1110, 986}},
                 {3, {6, 2532, 142}},
                 {3, {7, 1690, 2405}},
                 {3, {8, 1298, 1881}},
                 {3, {9, 615, 174}},
                 {3, {10, 1648, 3112}},
                 {3, {11, 1415, 2808}},
             }};

// EN 302 307-1 Table C.8
static const s2_ldpc_table ldpc_sf_fec45 =
    {10, 35, {
                 {3, {5, 896, 1565}},
                 {3, {6, 2493, 184}},
                 {3, {7, 212, 3210}},
                 {3, {8, 727, 1339}},
                 {3, {9, 3428, 612}},
                 {3, {0, 2663, 1947}},
                 {3, {1, 230, 2695}},
                 {3, {2, 2025, 2794}},
                 {3, {3, 3039, 283}},
                 {3, {4, 862, 2889}},
                 {3, {5, 376, 2110}},
                 {3, {6, 2034, 2286}},
                 {3, {7, 951, 2068}},
                 {3, {8, 3108, 3542}},
                 {3, {9, 307, 1421}},
                 {3, {0, 2272, 1197}},
                 {3, {1, 1800, 3280}},
                 {3, {2, 331, 2308}},
                 {3, {3, 465, 2552}},
                 {3, {4, 1038, 2479}},
                 {3, {5, 1383, 343}},
                 {3, {6, 94, 236}},
                 {3, {7, 2619, 121}},
                 {3, {8, 1497, 2774}},
                 {3, {9, 2116, 1855}},
                 {3, {0, 722, 1584}},
                 {3, {1, 2767, 1881}},
                 {3, {2, 2701, 1610}},
                 {3, {3, 3283, 1732}},
                 {3, {4, 168, 1099}},
                 {3, {5, 3074, 243}},
                 {3, {6, 3460, 945}},
                 {3, {7, 2049, 1746}},
                 {3, {8, 566, 1427}},
                 {3, {9, 3545, 1168}},
             }};

// EN 302 307-1 Table C.9
static const s2_ldpc_table ldpc_sf_fec56 =
    {8, 37, {
                {13, {3, 2409, 499, 1481, 908, 559, 716, 1270, 333, 2508, 2264, 1702, 2805}},
                {3, {4, 2447, 1926}},
                {3, {5, 414, 1224}},
                {3, {6, 2114, 842}},
                {3, {7, 212, 573}},
                {3, {0, 2383, 2112}},
                {3, {1, 2286, 2348}},
                {3, {2, 545, 819}},
                {3, {3, 1264, 143}},
                {3, {4, 1701, 2258}},
                {3, {5, 964, 166}},
                {3, {6, 114, 2413}},
                {3, {7, 2243, 81}},
                {3, {0, 1245, 1581}},
                {3, {1, 775, 169}},
                {3, {2, 1696, 1104}},
                {3, {3, 1914, 2831}},
                {3, {4, 532, 1450}},
                {3, {5, 91, 974}},
                {3, {6, 497, 2228}},
                {3, {7, 2326, 1579}},
                {3, {0, 2482, 256}},
                {3, {1, 1117, 1261}},
                {3, {2, 1257, 1658}},
                {3, {3, 1478, 1225}},
                {3, {4, 2511, 980}},
                {3, {5, 2320, 2675}},
                {3, {6, 435, 1278}},
                {3, {7, 228, 503}},
                {3, {0, 1885, 2369}},
                {3, {1, 57, 483}},
                {3, {2, 838, 1050}},
                {3, {3, 1231, 1990}},
                {3, {4, 1738, 68}},
                {3, {5, 2392, 951}},
                {3, {6, 163, 645}},
                {3, {7, 2644, 1704}},
            }};

// EN 302 307-1 Table C.10
static const s2_ldpc_table ldpc_sf_fec89 =
    {5, 40, {
                {4, {0, 1558, 712, 805}},
                {4, {1, 1450, 873, 1337}},
                {4, {2, 1741, 1129, 1184}},
                {4, {3, 294, 806, 1566}},
                {4, {4, 482, 605, 923}},
                {3, {0, 926, 1578}},
                {3, {1, 777, 1374}},
                {3, {2, 608, 151}},
                {3, {3, 1195, 210}},
                {3, {4, 1484, 692}},
                {3, {0, 427, 488}},
                {3, {1, 828, 1124}},
                {3, {2, 874, 1366}},
                {3, {3, 1500, 835}},
                {3, {4, 1496, 502}},
                {3, {0, 1006, 1701}},
                {3, {1, 1155, 97}},
                {3, {2, 657, 1403}},
                {3, {3, 1453, 624}},
                {3, {4, 429, 1495}},
                {3, {0, 809, 385}},
                {3, {1, 367, 151}},
                {3, {2, 1323, 202}},
                {3, {3, 960, 318}},
                {3, {4, 1451, 1039}},
                {3, {0, 1098, 1722}},
                {3, {1, 1015, 1428}},
                {3, {2, 1261, 1564}},
                {3, {3, 544, 1190}},
                {3, {4, 1472, 1246}},
                {3, {0, 508, 630}},
                {3, {1, 421, 1704}},
                {3, {2, 284, 898}},
                {3, {3, 392, 577}},
                {3, {4, 1155, 556}},
                {3, {0, 631, 1000}},
                {3, {1, 732, 1368}},
                {3, {2, 1328, 329}},
                {3, {3, 1515, 506}},
                {3, {4, 1104, 1172}},
            }};
