/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGADSBDemodSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGADSBDemodSettings::SWGADSBDemodSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGADSBDemodSettings::SWGADSBDemodSettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    correlation_threshold = 0.0f;
    m_correlation_threshold_isSet = false;
    samples_per_bit = 0;
    m_samples_per_bit_isSet = false;
    correlate_full_preamble = 0;
    m_correlate_full_preamble_isSet = false;
    demod_mode_s = 0;
    m_demod_mode_s_isSet = false;
    interpolator_phase_steps = 0;
    m_interpolator_phase_steps_isSet = false;
    interpolator_taps_per_phase = 0.0f;
    m_interpolator_taps_per_phase_isSet = false;
    remove_timeout = 0;
    m_remove_timeout_isSet = false;
    feed_enabled = 0;
    m_feed_enabled_isSet = false;
    export_client_enabled = 0;
    m_export_client_enabled_isSet = false;
    export_client_host = nullptr;
    m_export_client_host_isSet = false;
    export_client_port = 0;
    m_export_client_port_isSet = false;
    export_client_format = 0;
    m_export_client_format_isSet = false;
    export_server_enabled = 0;
    m_export_server_enabled_isSet = false;
    export_server_port = 0;
    m_export_server_port_isSet = false;
    import_enabled = 0;
    m_import_enabled_isSet = false;
    import_host = nullptr;
    m_import_host_isSet = false;
    import_username = nullptr;
    m_import_username_isSet = false;
    import_password = nullptr;
    m_import_password_isSet = false;
    import_parameters = nullptr;
    m_import_parameters_isSet = false;
    import_period = 0.0f;
    m_import_period_isSet = false;
    import_min_latitude = nullptr;
    m_import_min_latitude_isSet = false;
    import_max_latitude = nullptr;
    m_import_max_latitude_isSet = false;
    import_min_longitude = nullptr;
    m_import_min_longitude_isSet = false;
    import_max_longitude = nullptr;
    m_import_max_longitude_isSet = false;
    log_filename = nullptr;
    m_log_filename_isSet = false;
    log_enabled = 0;
    m_log_enabled_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGADSBDemodSettings::~SWGADSBDemodSettings() {
    this->cleanup();
}

void
SWGADSBDemodSettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    correlation_threshold = 0.0f;
    m_correlation_threshold_isSet = false;
    samples_per_bit = 0;
    m_samples_per_bit_isSet = false;
    correlate_full_preamble = 0;
    m_correlate_full_preamble_isSet = false;
    demod_mode_s = 0;
    m_demod_mode_s_isSet = false;
    interpolator_phase_steps = 0;
    m_interpolator_phase_steps_isSet = false;
    interpolator_taps_per_phase = 0.0f;
    m_interpolator_taps_per_phase_isSet = false;
    remove_timeout = 0;
    m_remove_timeout_isSet = false;
    feed_enabled = 0;
    m_feed_enabled_isSet = false;
    export_client_enabled = 0;
    m_export_client_enabled_isSet = false;
    export_client_host = new QString("");
    m_export_client_host_isSet = false;
    export_client_port = 0;
    m_export_client_port_isSet = false;
    export_client_format = 0;
    m_export_client_format_isSet = false;
    export_server_enabled = 0;
    m_export_server_enabled_isSet = false;
    export_server_port = 0;
    m_export_server_port_isSet = false;
    import_enabled = 0;
    m_import_enabled_isSet = false;
    import_host = new QString("");
    m_import_host_isSet = false;
    import_username = new QString("");
    m_import_username_isSet = false;
    import_password = new QString("");
    m_import_password_isSet = false;
    import_parameters = new QString("");
    m_import_parameters_isSet = false;
    import_period = 0.0f;
    m_import_period_isSet = false;
    import_min_latitude = new QString("");
    m_import_min_latitude_isSet = false;
    import_max_latitude = new QString("");
    m_import_max_latitude_isSet = false;
    import_min_longitude = new QString("");
    m_import_min_longitude_isSet = false;
    import_max_longitude = new QString("");
    m_import_max_longitude_isSet = false;
    log_filename = new QString("");
    m_log_filename_isSet = false;
    log_enabled = 0;
    m_log_enabled_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGADSBDemodSettings::cleanup() {











    if(export_client_host != nullptr) { 
        delete export_client_host;
    }





    if(import_host != nullptr) { 
        delete import_host;
    }
    if(import_username != nullptr) { 
        delete import_username;
    }
    if(import_password != nullptr) { 
        delete import_password;
    }
    if(import_parameters != nullptr) { 
        delete import_parameters;
    }

    if(import_min_latitude != nullptr) { 
        delete import_min_latitude;
    }
    if(import_max_latitude != nullptr) { 
        delete import_max_latitude;
    }
    if(import_min_longitude != nullptr) { 
        delete import_min_longitude;
    }
    if(import_max_longitude != nullptr) { 
        delete import_max_longitude;
    }
    if(log_filename != nullptr) { 
        delete log_filename;
    }


    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGADSBDemodSettings*
SWGADSBDemodSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGADSBDemodSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&correlation_threshold, pJson["correlationThreshold"], "float", "");
    
    ::SWGSDRangel::setValue(&samples_per_bit, pJson["samplesPerBit"], "qint32", "");
    
    ::SWGSDRangel::setValue(&correlate_full_preamble, pJson["correlateFullPreamble"], "qint32", "");
    
    ::SWGSDRangel::setValue(&demod_mode_s, pJson["demodModeS"], "qint32", "");
    
    ::SWGSDRangel::setValue(&interpolator_phase_steps, pJson["interpolatorPhaseSteps"], "qint32", "");
    
    ::SWGSDRangel::setValue(&interpolator_taps_per_phase, pJson["interpolatorTapsPerPhase"], "float", "");
    
    ::SWGSDRangel::setValue(&remove_timeout, pJson["removeTimeout"], "qint32", "");
    
    ::SWGSDRangel::setValue(&feed_enabled, pJson["feedEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&export_client_enabled, pJson["exportClientEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&export_client_host, pJson["exportClientHost"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&export_client_port, pJson["exportClientPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&export_client_format, pJson["exportClientFormat"], "qint32", "");
    
    ::SWGSDRangel::setValue(&export_server_enabled, pJson["exportServerEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&export_server_port, pJson["exportServerPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&import_enabled, pJson["importEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&import_host, pJson["importHost"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_username, pJson["importUsername"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_password, pJson["importPassword"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_parameters, pJson["importParameters"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_period, pJson["importPeriod"], "float", "");
    
    ::SWGSDRangel::setValue(&import_min_latitude, pJson["importMinLatitude"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_max_latitude, pJson["importMaxLatitude"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_min_longitude, pJson["importMinLongitude"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&import_max_longitude, pJson["importMaxLongitude"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&log_filename, pJson["logFilename"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&log_enabled, pJson["logEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGADSBDemodSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGADSBDemodSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_correlation_threshold_isSet){
        obj->insert("correlationThreshold", QJsonValue(correlation_threshold));
    }
    if(m_samples_per_bit_isSet){
        obj->insert("samplesPerBit", QJsonValue(samples_per_bit));
    }
    if(m_correlate_full_preamble_isSet){
        obj->insert("correlateFullPreamble", QJsonValue(correlate_full_preamble));
    }
    if(m_demod_mode_s_isSet){
        obj->insert("demodModeS", QJsonValue(demod_mode_s));
    }
    if(m_interpolator_phase_steps_isSet){
        obj->insert("interpolatorPhaseSteps", QJsonValue(interpolator_phase_steps));
    }
    if(m_interpolator_taps_per_phase_isSet){
        obj->insert("interpolatorTapsPerPhase", QJsonValue(interpolator_taps_per_phase));
    }
    if(m_remove_timeout_isSet){
        obj->insert("removeTimeout", QJsonValue(remove_timeout));
    }
    if(m_feed_enabled_isSet){
        obj->insert("feedEnabled", QJsonValue(feed_enabled));
    }
    if(m_export_client_enabled_isSet){
        obj->insert("exportClientEnabled", QJsonValue(export_client_enabled));
    }
    if(export_client_host != nullptr && *export_client_host != QString("")){
        toJsonValue(QString("exportClientHost"), export_client_host, obj, QString("QString"));
    }
    if(m_export_client_port_isSet){
        obj->insert("exportClientPort", QJsonValue(export_client_port));
    }
    if(m_export_client_format_isSet){
        obj->insert("exportClientFormat", QJsonValue(export_client_format));
    }
    if(m_export_server_enabled_isSet){
        obj->insert("exportServerEnabled", QJsonValue(export_server_enabled));
    }
    if(m_export_server_port_isSet){
        obj->insert("exportServerPort", QJsonValue(export_server_port));
    }
    if(m_import_enabled_isSet){
        obj->insert("importEnabled", QJsonValue(import_enabled));
    }
    if(import_host != nullptr && *import_host != QString("")){
        toJsonValue(QString("importHost"), import_host, obj, QString("QString"));
    }
    if(import_username != nullptr && *import_username != QString("")){
        toJsonValue(QString("importUsername"), import_username, obj, QString("QString"));
    }
    if(import_password != nullptr && *import_password != QString("")){
        toJsonValue(QString("importPassword"), import_password, obj, QString("QString"));
    }
    if(import_parameters != nullptr && *import_parameters != QString("")){
        toJsonValue(QString("importParameters"), import_parameters, obj, QString("QString"));
    }
    if(m_import_period_isSet){
        obj->insert("importPeriod", QJsonValue(import_period));
    }
    if(import_min_latitude != nullptr && *import_min_latitude != QString("")){
        toJsonValue(QString("importMinLatitude"), import_min_latitude, obj, QString("QString"));
    }
    if(import_max_latitude != nullptr && *import_max_latitude != QString("")){
        toJsonValue(QString("importMaxLatitude"), import_max_latitude, obj, QString("QString"));
    }
    if(import_min_longitude != nullptr && *import_min_longitude != QString("")){
        toJsonValue(QString("importMinLongitude"), import_min_longitude, obj, QString("QString"));
    }
    if(import_max_longitude != nullptr && *import_max_longitude != QString("")){
        toJsonValue(QString("importMaxLongitude"), import_max_longitude, obj, QString("QString"));
    }
    if(log_filename != nullptr && *log_filename != QString("")){
        toJsonValue(QString("logFilename"), log_filename, obj, QString("QString"));
    }
    if(m_log_enabled_isSet){
        obj->insert("logEnabled", QJsonValue(log_enabled));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGADSBDemodSettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGADSBDemodSettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

float
SWGADSBDemodSettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGADSBDemodSettings::setRfBandwidth(float rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

float
SWGADSBDemodSettings::getCorrelationThreshold() {
    return correlation_threshold;
}
void
SWGADSBDemodSettings::setCorrelationThreshold(float correlation_threshold) {
    this->correlation_threshold = correlation_threshold;
    this->m_correlation_threshold_isSet = true;
}

qint32
SWGADSBDemodSettings::getSamplesPerBit() {
    return samples_per_bit;
}
void
SWGADSBDemodSettings::setSamplesPerBit(qint32 samples_per_bit) {
    this->samples_per_bit = samples_per_bit;
    this->m_samples_per_bit_isSet = true;
}

qint32
SWGADSBDemodSettings::getCorrelateFullPreamble() {
    return correlate_full_preamble;
}
void
SWGADSBDemodSettings::setCorrelateFullPreamble(qint32 correlate_full_preamble) {
    this->correlate_full_preamble = correlate_full_preamble;
    this->m_correlate_full_preamble_isSet = true;
}

qint32
SWGADSBDemodSettings::getDemodModeS() {
    return demod_mode_s;
}
void
SWGADSBDemodSettings::setDemodModeS(qint32 demod_mode_s) {
    this->demod_mode_s = demod_mode_s;
    this->m_demod_mode_s_isSet = true;
}

qint32
SWGADSBDemodSettings::getInterpolatorPhaseSteps() {
    return interpolator_phase_steps;
}
void
SWGADSBDemodSettings::setInterpolatorPhaseSteps(qint32 interpolator_phase_steps) {
    this->interpolator_phase_steps = interpolator_phase_steps;
    this->m_interpolator_phase_steps_isSet = true;
}

float
SWGADSBDemodSettings::getInterpolatorTapsPerPhase() {
    return interpolator_taps_per_phase;
}
void
SWGADSBDemodSettings::setInterpolatorTapsPerPhase(float interpolator_taps_per_phase) {
    this->interpolator_taps_per_phase = interpolator_taps_per_phase;
    this->m_interpolator_taps_per_phase_isSet = true;
}

qint32
SWGADSBDemodSettings::getRemoveTimeout() {
    return remove_timeout;
}
void
SWGADSBDemodSettings::setRemoveTimeout(qint32 remove_timeout) {
    this->remove_timeout = remove_timeout;
    this->m_remove_timeout_isSet = true;
}

qint32
SWGADSBDemodSettings::getFeedEnabled() {
    return feed_enabled;
}
void
SWGADSBDemodSettings::setFeedEnabled(qint32 feed_enabled) {
    this->feed_enabled = feed_enabled;
    this->m_feed_enabled_isSet = true;
}

qint32
SWGADSBDemodSettings::getExportClientEnabled() {
    return export_client_enabled;
}
void
SWGADSBDemodSettings::setExportClientEnabled(qint32 export_client_enabled) {
    this->export_client_enabled = export_client_enabled;
    this->m_export_client_enabled_isSet = true;
}

QString*
SWGADSBDemodSettings::getExportClientHost() {
    return export_client_host;
}
void
SWGADSBDemodSettings::setExportClientHost(QString* export_client_host) {
    this->export_client_host = export_client_host;
    this->m_export_client_host_isSet = true;
}

qint32
SWGADSBDemodSettings::getExportClientPort() {
    return export_client_port;
}
void
SWGADSBDemodSettings::setExportClientPort(qint32 export_client_port) {
    this->export_client_port = export_client_port;
    this->m_export_client_port_isSet = true;
}

qint32
SWGADSBDemodSettings::getExportClientFormat() {
    return export_client_format;
}
void
SWGADSBDemodSettings::setExportClientFormat(qint32 export_client_format) {
    this->export_client_format = export_client_format;
    this->m_export_client_format_isSet = true;
}

qint32
SWGADSBDemodSettings::getExportServerEnabled() {
    return export_server_enabled;
}
void
SWGADSBDemodSettings::setExportServerEnabled(qint32 export_server_enabled) {
    this->export_server_enabled = export_server_enabled;
    this->m_export_server_enabled_isSet = true;
}

qint32
SWGADSBDemodSettings::getExportServerPort() {
    return export_server_port;
}
void
SWGADSBDemodSettings::setExportServerPort(qint32 export_server_port) {
    this->export_server_port = export_server_port;
    this->m_export_server_port_isSet = true;
}

qint32
SWGADSBDemodSettings::getImportEnabled() {
    return import_enabled;
}
void
SWGADSBDemodSettings::setImportEnabled(qint32 import_enabled) {
    this->import_enabled = import_enabled;
    this->m_import_enabled_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportHost() {
    return import_host;
}
void
SWGADSBDemodSettings::setImportHost(QString* import_host) {
    this->import_host = import_host;
    this->m_import_host_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportUsername() {
    return import_username;
}
void
SWGADSBDemodSettings::setImportUsername(QString* import_username) {
    this->import_username = import_username;
    this->m_import_username_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportPassword() {
    return import_password;
}
void
SWGADSBDemodSettings::setImportPassword(QString* import_password) {
    this->import_password = import_password;
    this->m_import_password_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportParameters() {
    return import_parameters;
}
void
SWGADSBDemodSettings::setImportParameters(QString* import_parameters) {
    this->import_parameters = import_parameters;
    this->m_import_parameters_isSet = true;
}

float
SWGADSBDemodSettings::getImportPeriod() {
    return import_period;
}
void
SWGADSBDemodSettings::setImportPeriod(float import_period) {
    this->import_period = import_period;
    this->m_import_period_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportMinLatitude() {
    return import_min_latitude;
}
void
SWGADSBDemodSettings::setImportMinLatitude(QString* import_min_latitude) {
    this->import_min_latitude = import_min_latitude;
    this->m_import_min_latitude_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportMaxLatitude() {
    return import_max_latitude;
}
void
SWGADSBDemodSettings::setImportMaxLatitude(QString* import_max_latitude) {
    this->import_max_latitude = import_max_latitude;
    this->m_import_max_latitude_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportMinLongitude() {
    return import_min_longitude;
}
void
SWGADSBDemodSettings::setImportMinLongitude(QString* import_min_longitude) {
    this->import_min_longitude = import_min_longitude;
    this->m_import_min_longitude_isSet = true;
}

QString*
SWGADSBDemodSettings::getImportMaxLongitude() {
    return import_max_longitude;
}
void
SWGADSBDemodSettings::setImportMaxLongitude(QString* import_max_longitude) {
    this->import_max_longitude = import_max_longitude;
    this->m_import_max_longitude_isSet = true;
}

QString*
SWGADSBDemodSettings::getLogFilename() {
    return log_filename;
}
void
SWGADSBDemodSettings::setLogFilename(QString* log_filename) {
    this->log_filename = log_filename;
    this->m_log_filename_isSet = true;
}

qint32
SWGADSBDemodSettings::getLogEnabled() {
    return log_enabled;
}
void
SWGADSBDemodSettings::setLogEnabled(qint32 log_enabled) {
    this->log_enabled = log_enabled;
    this->m_log_enabled_isSet = true;
}

qint32
SWGADSBDemodSettings::getRgbColor() {
    return rgb_color;
}
void
SWGADSBDemodSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGADSBDemodSettings::getTitle() {
    return title;
}
void
SWGADSBDemodSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGADSBDemodSettings::getStreamIndex() {
    return stream_index;
}
void
SWGADSBDemodSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGADSBDemodSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGADSBDemodSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGADSBDemodSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGADSBDemodSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGADSBDemodSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGADSBDemodSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGADSBDemodSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGADSBDemodSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGADSBDemodSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGADSBDemodSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGChannelMarker*
SWGADSBDemodSettings::getChannelMarker() {
    return channel_marker;
}
void
SWGADSBDemodSettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGADSBDemodSettings::getRollupState() {
    return rollup_state;
}
void
SWGADSBDemodSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGADSBDemodSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_correlation_threshold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_samples_per_bit_isSet){
            isObjectUpdated = true; break;
        }
        if(m_correlate_full_preamble_isSet){
            isObjectUpdated = true; break;
        }
        if(m_demod_mode_s_isSet){
            isObjectUpdated = true; break;
        }
        if(m_interpolator_phase_steps_isSet){
            isObjectUpdated = true; break;
        }
        if(m_interpolator_taps_per_phase_isSet){
            isObjectUpdated = true; break;
        }
        if(m_remove_timeout_isSet){
            isObjectUpdated = true; break;
        }
        if(m_feed_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(m_export_client_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(export_client_host && *export_client_host != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_export_client_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_export_client_format_isSet){
            isObjectUpdated = true; break;
        }
        if(m_export_server_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(m_export_server_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_import_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(import_host && *import_host != QString("")){
            isObjectUpdated = true; break;
        }
        if(import_username && *import_username != QString("")){
            isObjectUpdated = true; break;
        }
        if(import_password && *import_password != QString("")){
            isObjectUpdated = true; break;
        }
        if(import_parameters && *import_parameters != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_import_period_isSet){
            isObjectUpdated = true; break;
        }
        if(import_min_latitude && *import_min_latitude != QString("")){
            isObjectUpdated = true; break;
        }
        if(import_max_latitude && *import_max_latitude != QString("")){
            isObjectUpdated = true; break;
        }
        if(import_min_longitude && *import_min_longitude != QString("")){
            isObjectUpdated = true; break;
        }
        if(import_max_longitude && *import_max_longitude != QString("")){
            isObjectUpdated = true; break;
        }
        if(log_filename && *log_filename != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_log_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

