/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAudioInputSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAudioInputSettings::SWGAudioInputSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAudioInputSettings::SWGAudioInputSettings() {
    title = nullptr;
    m_title_isSet = false;
    device = nullptr;
    m_device_isSet = false;
    dev_sample_rate = 0;
    m_dev_sample_rate_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    iq_mapping = 0;
    m_iq_mapping_isSet = false;
    dc_block = 0;
    m_dc_block_isSet = false;
    iq_imbalance = 0;
    m_iq_imbalance_isSet = false;
    fc_pos = 0;
    m_fc_pos_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
}

SWGAudioInputSettings::~SWGAudioInputSettings() {
    this->cleanup();
}

void
SWGAudioInputSettings::init() {
    title = new QString("");
    m_title_isSet = false;
    device = new QString("");
    m_device_isSet = false;
    dev_sample_rate = 0;
    m_dev_sample_rate_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    iq_mapping = 0;
    m_iq_mapping_isSet = false;
    dc_block = 0;
    m_dc_block_isSet = false;
    iq_imbalance = 0;
    m_iq_imbalance_isSet = false;
    fc_pos = 0;
    m_fc_pos_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
}

void
SWGAudioInputSettings::cleanup() {
    if(title != nullptr) { 
        delete title;
    }
    if(device != nullptr) { 
        delete device;
    }








    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }


}

SWGAudioInputSettings*
SWGAudioInputSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAudioInputSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&device, pJson["device"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&dev_sample_rate, pJson["devSampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&volume, pJson["volume"], "float", "");
    
    ::SWGSDRangel::setValue(&log2_decim, pJson["log2Decim"], "qint32", "");
    
    ::SWGSDRangel::setValue(&iq_mapping, pJson["iqMapping"], "qint32", "");
    
    ::SWGSDRangel::setValue(&dc_block, pJson["dcBlock"], "qint32", "");
    
    ::SWGSDRangel::setValue(&iq_imbalance, pJson["iqImbalance"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fc_pos, pJson["fcPos"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
}

QString
SWGAudioInputSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAudioInputSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(device != nullptr && *device != QString("")){
        toJsonValue(QString("device"), device, obj, QString("QString"));
    }
    if(m_dev_sample_rate_isSet){
        obj->insert("devSampleRate", QJsonValue(dev_sample_rate));
    }
    if(m_volume_isSet){
        obj->insert("volume", QJsonValue(volume));
    }
    if(m_log2_decim_isSet){
        obj->insert("log2Decim", QJsonValue(log2_decim));
    }
    if(m_iq_mapping_isSet){
        obj->insert("iqMapping", QJsonValue(iq_mapping));
    }
    if(m_dc_block_isSet){
        obj->insert("dcBlock", QJsonValue(dc_block));
    }
    if(m_iq_imbalance_isSet){
        obj->insert("iqImbalance", QJsonValue(iq_imbalance));
    }
    if(m_fc_pos_isSet){
        obj->insert("fcPos", QJsonValue(fc_pos));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }

    return obj;
}

QString*
SWGAudioInputSettings::getTitle() {
    return title;
}
void
SWGAudioInputSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

QString*
SWGAudioInputSettings::getDevice() {
    return device;
}
void
SWGAudioInputSettings::setDevice(QString* device) {
    this->device = device;
    this->m_device_isSet = true;
}

qint32
SWGAudioInputSettings::getDevSampleRate() {
    return dev_sample_rate;
}
void
SWGAudioInputSettings::setDevSampleRate(qint32 dev_sample_rate) {
    this->dev_sample_rate = dev_sample_rate;
    this->m_dev_sample_rate_isSet = true;
}

float
SWGAudioInputSettings::getVolume() {
    return volume;
}
void
SWGAudioInputSettings::setVolume(float volume) {
    this->volume = volume;
    this->m_volume_isSet = true;
}

qint32
SWGAudioInputSettings::getLog2Decim() {
    return log2_decim;
}
void
SWGAudioInputSettings::setLog2Decim(qint32 log2_decim) {
    this->log2_decim = log2_decim;
    this->m_log2_decim_isSet = true;
}

qint32
SWGAudioInputSettings::getIqMapping() {
    return iq_mapping;
}
void
SWGAudioInputSettings::setIqMapping(qint32 iq_mapping) {
    this->iq_mapping = iq_mapping;
    this->m_iq_mapping_isSet = true;
}

qint32
SWGAudioInputSettings::getDcBlock() {
    return dc_block;
}
void
SWGAudioInputSettings::setDcBlock(qint32 dc_block) {
    this->dc_block = dc_block;
    this->m_dc_block_isSet = true;
}

qint32
SWGAudioInputSettings::getIqImbalance() {
    return iq_imbalance;
}
void
SWGAudioInputSettings::setIqImbalance(qint32 iq_imbalance) {
    this->iq_imbalance = iq_imbalance;
    this->m_iq_imbalance_isSet = true;
}

qint32
SWGAudioInputSettings::getFcPos() {
    return fc_pos;
}
void
SWGAudioInputSettings::setFcPos(qint32 fc_pos) {
    this->fc_pos = fc_pos;
    this->m_fc_pos_isSet = true;
}

qint32
SWGAudioInputSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGAudioInputSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGAudioInputSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGAudioInputSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGAudioInputSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGAudioInputSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGAudioInputSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGAudioInputSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}


bool
SWGAudioInputSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(device && *device != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_dev_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_volume_isSet){
            isObjectUpdated = true; break;
        }
        if(m_log2_decim_isSet){
            isObjectUpdated = true; break;
        }
        if(m_iq_mapping_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dc_block_isSet){
            isObjectUpdated = true; break;
        }
        if(m_iq_imbalance_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fc_pos_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

